/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Arrays;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationElement;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.utils.ArrayUtils;

public class DexEncodedAnnotation
extends DexItem {
    private static final int UNSORTED = 0;
    public final DexType type;
    public final DexAnnotationElement[] elements;
    private int sorted = 0;

    public DexEncodedAnnotation(DexType type, DexAnnotationElement[] elements) {
        this.type = type;
        this.elements = elements;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.type.collectIndexedItems(indexedItems, method, instructionOffset);
        DexEncodedAnnotation.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.elements);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        assert (false);
    }

    public String toString() {
        return "Encoded annotation " + this.type + " " + Arrays.toString(this.elements);
    }

    public int hashCode() {
        return this.type.hashCode() * 7 + Arrays.hashCode(this.elements);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexEncodedAnnotation) {
            DexEncodedAnnotation that = (DexEncodedAnnotation)other;
            return that.type.equals(this.type) && Arrays.equals(that.elements, this.elements);
        }
        return false;
    }

    public void sort() {
        if (this.sorted != 0) {
            assert (this.sorted == this.sortedHashCode());
            return;
        }
        Arrays.sort(this.elements, (a, b) -> a.name.compareTo(b.name));
        for (DexAnnotationElement element : this.elements) {
            element.value.sort();
        }
        this.sorted = this.sortedHashCode();
    }

    private int sortedHashCode() {
        int hashCode = this.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }

    public DexEncodedAnnotation rewrite(Function<DexType, DexType> typeRewriter, Function<DexAnnotationElement, DexAnnotationElement> elementRewriter) {
        DexType rewrittenType = typeRewriter.apply(this.type);
        DexAnnotationElement[] rewrittenElements = ArrayUtils.map(DexAnnotationElement[].class, this.elements, elementRewriter);
        if (rewrittenType == this.type && rewrittenElements == this.elements) {
            return this;
        }
        return new DexEncodedAnnotation(rewrittenType, rewrittenElements);
    }
}

