/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;

public class DexField
extends Descriptor<DexEncodedField, DexField>
implements PresortedComparable<DexField> {
    public final DexType holder;
    public final DexType type;
    public final DexString name;

    DexField(DexType holder, DexType type, DexString name, boolean skipNameValidationForTesting) {
        this.holder = holder;
        this.type = type;
        this.name = name;
        if (!skipNameValidationForTesting && !name.isValidFieldName()) {
            throw new CompilationError("Field name '" + name.toString() + "' cannot be represented in dex format.");
        }
    }

    @Override
    public int computeHashCode() {
        return this.holder.hashCode() + this.type.hashCode() * 7 + this.name.hashCode() * 31;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexField) {
            DexField o = (DexField)other;
            return this.holder.equals(o.holder) && this.type.equals(o.type) && this.name.equals(o.name);
        }
        return false;
    }

    public String toString() {
        return "Field " + this.type + " " + this.holder + "." + this.name;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        if (indexedItems.addField(this)) {
            this.holder.collectIndexedItems(indexedItems, method, instructionOffset);
            this.type.collectIndexedItems(indexedItems, method, instructionOffset);
            indexedItems.getRenamedName(this).collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public boolean isDexField() {
        return true;
    }

    @Override
    public DexField asDexField() {
        return this;
    }

    @Override
    public int compareTo(DexField other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexField other) {
        int result = this.holder.slowCompareTo(other.holder);
        if (result != 0) {
            return result;
        }
        result = this.name.slowCompareTo(other.name);
        if (result != 0) {
            return result;
        }
        return this.type.slowCompareTo(other.type);
    }

    @Override
    public int slowCompareTo(DexField other, NamingLens namingLens) {
        int result = this.holder.slowCompareTo(other.holder, namingLens);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).slowCompareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.type.slowCompareTo(other.type, namingLens);
    }

    @Override
    public int layeredCompareTo(DexField other, NamingLens namingLens) {
        int result = this.holder.compareTo(other.holder);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).compareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.type.compareTo(other.type);
    }

    @Override
    public boolean match(DexField field) {
        return field.name == this.name && field.type == this.type;
    }

    @Override
    public boolean match(DexEncodedField encodedField) {
        return this.match(encodedField.field);
    }

    public String qualifiedName() {
        return this.holder + "." + this.name;
    }

    @Override
    public String toSmaliString() {
        return this.holder.toSmaliString() + "->" + this.name + ":" + this.type.toSmaliString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString() + " " + this.holder.toSourceString() + "." + this.name.toSourceString();
    }
}

