/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationDirectory;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedArray;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.EnclosingMethodAttribute;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.NestHostClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.NestMemberClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinInfo;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class DexProgramClass
extends DexClass
implements Supplier<DexProgramClass> {
    public static final DexProgramClass[] EMPTY_ARRAY = new DexProgramClass[0];
    private static final DexEncodedArray SENTINEL_NOT_YET_COMPUTED = new DexEncodedArray(DexValue.EMPTY_ARRAY);
    private final ProgramResource.Kind originKind;
    private DexEncodedArray staticValues = SENTINEL_NOT_YET_COMPUTED;
    private final Collection<DexProgramClass> synthesizedFrom;
    private int initialClassFileVersion = -1;
    private KotlinInfo kotlinInfo = null;
    private final ChecksumSupplier checksumSupplier;

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, NestHostClassAttribute nestHost, List<NestMemberClassAttribute> nestMembers, EnclosingMethodAttribute enclosingMember, List<InnerClassAttribute> innerClasses, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, boolean skipNameValidationForTesting, ChecksumSupplier checksumSupplier) {
        this(type, originKind, origin, accessFlags, superType, interfaces, sourceFile, nestHost, nestMembers, enclosingMember, innerClasses, classAnnotations, staticFields, instanceFields, directMethods, virtualMethods, skipNameValidationForTesting, checksumSupplier, Collections.emptyList());
    }

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, NestHostClassAttribute nestHost, List<NestMemberClassAttribute> nestMembers, EnclosingMethodAttribute enclosingMember, List<InnerClassAttribute> innerClasses, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, boolean skipNameValidationForTesting, ChecksumSupplier checksumSupplier, Collection<DexProgramClass> synthesizedDirectlyFrom) {
        super(sourceFile, interfaces, accessFlags, superType, type, staticFields, instanceFields, directMethods, virtualMethods, nestHost, nestMembers, enclosingMember, innerClasses, classAnnotations, origin, skipNameValidationForTesting);
        assert (checksumSupplier != null);
        assert (classAnnotations != null);
        this.originKind = originKind;
        this.checksumSupplier = checksumSupplier;
        this.synthesizedFrom = new HashSet<DexProgramClass>();
        synthesizedDirectlyFrom.forEach(this::addSynthesizedFrom);
    }

    public boolean originatesFromDexResource() {
        return this.originKind == ProgramResource.Kind.DEX;
    }

    public boolean originatesFromClassResource() {
        return this.originKind == ProgramResource.Kind.CF;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        if (indexedItems.addClass(this)) {
            this.type.collectIndexedItems(indexedItems, method, instructionOffset);
            if (this.superType != null) {
                this.superType.collectIndexedItems(indexedItems, method, instructionOffset);
            } else assert (this.type.toDescriptorString().equals("Ljava/lang/Object;"));
            if (this.sourceFile != null) {
                this.sourceFile.collectIndexedItems(indexedItems, method, instructionOffset);
            }
            if (this.annotations != null) {
                this.annotations.collectIndexedItems(indexedItems, method, instructionOffset);
            }
            if (this.interfaces != null) {
                this.interfaces.collectIndexedItems(indexedItems, method, instructionOffset);
            }
            if (this.getEnclosingMethod() != null) {
                this.getEnclosingMethod().collectIndexedItems(indexedItems);
            }
            for (InnerClassAttribute attribute : this.getInnerClasses()) {
                attribute.collectIndexedItems(indexedItems);
            }
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.staticFields);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.instanceFields);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.directMethods);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.virtualMethods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DexItem> void synchronizedCollectAll(IndexedItemCollection collection, T[] items) {
        T[] TArray = items;
        synchronized (items) {
            DexProgramClass.collectAll((IndexedItemCollection)collection, items);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Collection<DexProgramClass> getSynthesizedFrom() {
        return this.synthesizedFrom;
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        assert (this.getEnclosingMethod() == null);
        assert (this.getInnerClasses().isEmpty());
        if (this.hasAnnotations()) {
            mixedItems.setAnnotationsDirectoryForClass(this, new DexAnnotationDirectory(this));
        }
    }

    @Override
    public void addDependencies(MixedSectionCollection collector) {
        assert (this.getEnclosingMethod() == null);
        assert (this.getInnerClasses().isEmpty());
        if (this.hasMethodsOrFields()) {
            collector.add(this);
            this.sortMembers();
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.directMethods);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.virtualMethods);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.staticFields);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.instanceFields);
        }
        if (this.annotations != null) {
            this.annotations.collectMixedSectionItems(collector);
        }
        if (this.interfaces != null) {
            this.interfaces.collectMixedSectionItems(collector);
        }
        this.annotations.collectMixedSectionItems(collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DexItem> void synchronizedCollectAll(MixedSectionCollection collection, T[] items) {
        T[] TArray = items;
        synchronized (items) {
            DexProgramClass.collectAll((MixedSectionCollection)collection, items);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString();
    }

    @Override
    public boolean isEffectivelyFinal(AppView<?> appView) {
        if (this.isFinal()) {
            return true;
        }
        if (appView.enableWholeProgramOptimizations()) {
            assert (((AppInfo)appView.appInfo()).hasLiveness());
            AppInfoWithLiveness appInfo = ((AppInfo)appView.appInfo()).withLiveness();
            if (appInfo.isPinned(this.type)) {
                return false;
            }
            return !appInfo.hasSubtypes(this.type) || !appInfo.isInstantiatedIndirectly(this);
        }
        return false;
    }

    @Override
    public boolean isProgramClass() {
        return true;
    }

    @Override
    public DexProgramClass asProgramClass() {
        return this;
    }

    public static DexProgramClass asProgramClassOrNull(DexClass clazz) {
        return clazz != null ? clazz.asProgramClass() : null;
    }

    @Override
    public boolean isNotProgramClass() {
        return false;
    }

    @Override
    public KotlinInfo getKotlinInfo() {
        return this.kotlinInfo;
    }

    public void setKotlinInfo(KotlinInfo kotlinInfo) {
        assert (this.kotlinInfo == null || kotlinInfo == null);
        this.kotlinInfo = kotlinInfo;
    }

    public boolean hasFields() {
        return this.instanceFields.length + this.staticFields.length > 0;
    }

    public boolean hasMethods() {
        return this.directMethods.length + this.virtualMethods.length > 0;
    }

    public boolean hasMethodsOrFields() {
        return this.hasMethods() || this.hasFields();
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty() || this.hasAnnotations(this.virtualMethods) || this.hasAnnotations(this.directMethods) || this.hasAnnotations(this.staticFields) || this.hasAnnotations(this.instanceFields);
    }

    boolean hasOnlyInternalizableAnnotations() {
        return !this.hasAnnotations(this.virtualMethods) && !this.hasAnnotations(this.directMethods) && !this.hasAnnotations(this.staticFields) && !this.hasAnnotations(this.instanceFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(DexEncodedField[] fields) {
        DexEncodedField[] dexEncodedFieldArray = fields;
        synchronized (fields) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.stream(fields).anyMatch(DexEncodedField::hasAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(DexEncodedMethod[] methods) {
        DexEncodedMethod[] dexEncodedMethodArray = methods;
        synchronized (methods) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.stream(methods).anyMatch(DexEncodedMethod::hasAnnotation);
        }
    }

    public void addSynthesizedFrom(DexProgramClass clazz) {
        if (clazz.synthesizedFrom.isEmpty()) {
            this.synthesizedFrom.add(clazz);
        } else {
            clazz.synthesizedFrom.forEach(this::addSynthesizedFrom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeStaticValues() {
        if (this.staticValues != SENTINEL_NOT_YET_COMPUTED) return;
        DexEncodedField[] dexEncodedFieldArray = this.staticFields;
        synchronized (this.staticFields) {
            assert (PresortedComparable.isSorted(Arrays.asList(this.staticFields)));
            DexEncodedField[] fields = this.staticFields;
            int length = 0;
            ArrayList<DexValue> values2 = new ArrayList<DexValue>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                DexEncodedField field = fields[i];
                DexValue staticValue = field.getStaticValue();
                assert (staticValue != null);
                values2.add(staticValue);
                if (staticValue.isDefault(field.field.type)) continue;
                length = i + 1;
            }
            this.staticValues = length > 0 ? new DexEncodedArray(values2.subList(0, length).toArray(DexValue.EMPTY_ARRAY)) : null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isSorted() {
        return DexProgramClass.isSorted((KeyedDexItem[])this.virtualMethods) && DexProgramClass.isSorted((KeyedDexItem[])this.directMethods) && DexProgramClass.isSorted((KeyedDexItem[])this.staticFields) && DexProgramClass.isSorted((KeyedDexItem[])this.instanceFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends KeyedDexItem<S>, S extends PresortedComparable<S>> boolean isSorted(T[] items) {
        T[] TArray = items;
        synchronized (items) {
            Object[] sorted2 = (KeyedDexItem[])items.clone();
            Arrays.sort(sorted2, Comparator.comparing(KeyedDexItem::getKey));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.equals(items, sorted2);
        }
    }

    public DexEncodedArray getStaticValues() {
        if (this.staticValues == SENTINEL_NOT_YET_COMPUTED) {
            assert (!this.hasMethodsOrFields());
            return null;
        }
        return this.staticValues;
    }

    public void addMethod(DexEncodedMethod method) {
        if (method.accessFlags.isStatic() || method.accessFlags.isPrivate() || method.accessFlags.isConstructor()) {
            this.addDirectMethod(method);
        } else {
            this.addVirtualMethod(method);
        }
    }

    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        assert (!virtualMethod.accessFlags.isStatic());
        assert (!virtualMethod.accessFlags.isPrivate());
        assert (!virtualMethod.accessFlags.isConstructor());
        this.virtualMethods = Arrays.copyOf(this.virtualMethods, this.virtualMethods.length + 1);
        this.virtualMethods[this.virtualMethods.length - 1] = virtualMethod;
    }

    public void addDirectMethod(DexEncodedMethod staticMethod) {
        assert (staticMethod.accessFlags.isStatic() || staticMethod.accessFlags.isPrivate() || staticMethod.accessFlags.isConstructor());
        this.directMethods = Arrays.copyOf(this.directMethods, this.directMethods.length + 1);
        this.directMethods[this.directMethods.length - 1] = staticMethod;
    }

    public void sortMembers() {
        this.sortEncodedFields(this.staticFields);
        this.sortEncodedFields(this.instanceFields);
        this.sortEncodedMethods(this.directMethods);
        this.sortEncodedMethods(this.virtualMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortEncodedFields(DexEncodedField[] fields) {
        DexEncodedField[] dexEncodedFieldArray = fields;
        synchronized (fields) {
            Arrays.sort(fields, Comparator.comparing(a -> a.field));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortEncodedMethods(DexEncodedMethod[] methods) {
        DexEncodedMethod[] dexEncodedMethodArray = methods;
        synchronized (methods) {
            Arrays.sort(methods, Comparator.comparing(a -> a.method));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public DexProgramClass get() {
        return this;
    }

    public void setInitialClassFileVersion(int initialClassFileVersion) {
        assert (this.initialClassFileVersion == -1 && initialClassFileVersion > 0);
        this.initialClassFileVersion = initialClassFileVersion;
    }

    public boolean hasClassFileVersion() {
        return this.initialClassFileVersion > -1;
    }

    public int getInitialClassFileVersion() {
        assert (this.initialClassFileVersion > -1);
        return this.initialClassFileVersion;
    }

    public boolean hasReachabilitySensitiveAnnotation(DexItemFactory factory) {
        for (DexEncodedMethod dexEncodedMethod : this.directMethods) {
            for (DexAnnotation annotation : dexEncodedMethod.annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        for (DexEncodedMethod dexEncodedMethod : this.virtualMethods) {
            for (DexAnnotation annotation : dexEncodedMethod.annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        for (KeyedDexItem keyedDexItem : this.staticFields) {
            for (DexAnnotation annotation : ((DexEncodedField)keyedDexItem).annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        for (KeyedDexItem keyedDexItem : this.instanceFields) {
            for (DexAnnotation annotation : ((DexEncodedField)keyedDexItem).annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        return false;
    }

    public static Iterable<DexProgramClass> asProgramClasses(final Iterable<DexType> types, final DexDefinitionSupplier definitions) {
        return () -> new Iterator<DexProgramClass>(){
            private DexProgramClass next;
            private final Iterator iterator;
            {
                this.iterator = types.iterator();
                this.next = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DexProgramClass next() {
                DexProgramClass current = this.next;
                this.next = this.findNext();
                return current;
            }

            private DexProgramClass findNext() {
                while (this.iterator.hasNext()) {
                    DexType next = (DexType)this.iterator.next();
                    DexClass clazz = definitions.definitionFor(next);
                    if (clazz == null || !clazz.isProgramClass()) continue;
                    return clazz.asProgramClass();
                }
                return null;
            }
        };
    }

    public static long invalidChecksumRequest(DexProgramClass clazz) {
        throw new CompilationError(clazz + " has no checksum information while checksum encoding is requested", clazz.origin);
    }

    public static long checksumFromType(DexProgramClass clazz) {
        return clazz.type.hashCode();
    }

    public long getChecksum() {
        return this.checksumSupplier.getChecksum(this);
    }

    @FunctionalInterface
    public static interface ChecksumSupplier {
        public long getChecksum(DexProgramClass var1);
    }
}

