/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AccessControl;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public abstract class ResolutionResult {
    public boolean isSingleResolution() {
        return false;
    }

    public SingleResolutionResult asSingleResolution() {
        return null;
    }

    public boolean isFailedResolution() {
        return false;
    }

    public FailedResolutionResult asFailedResolution() {
        return null;
    }

    public final DexEncodedMethod getSingleTarget() {
        return this.isSingleResolution() ? this.asSingleResolution().getResolvedMethod() : null;
    }

    public abstract boolean isAccessibleFrom(DexProgramClass var1, AppInfoWithSubtyping var2);

    public abstract boolean isAccessibleForVirtualDispatchFrom(DexProgramClass var1, AppInfoWithSubtyping var2);

    @Deprecated
    public abstract boolean isVirtualTarget();

    public abstract DexEncodedMethod lookupInvokeSpecialTarget(DexProgramClass var1, AppInfoWithSubtyping var2);

    public abstract DexEncodedMethod lookupInvokeSuperTarget(DexProgramClass var1, AppInfoWithSubtyping var2);

    @Deprecated
    public abstract DexEncodedMethod lookupInvokeSuperTarget(DexClass var1, AppInfo var2);

    public final Set<DexEncodedMethod> lookupVirtualDispatchTargets(boolean isInterface, AppInfoWithSubtyping appInfo) {
        return isInterface ? this.lookupInterfaceTargets(appInfo) : this.lookupVirtualTargets(appInfo);
    }

    public abstract Set<DexEncodedMethod> lookupVirtualTargets(AppInfoWithSubtyping var1);

    public abstract Set<DexEncodedMethod> lookupInterfaceTargets(AppInfoWithSubtyping var1);

    public static class IllegalAccessOrNoSuchMethodResult
    extends FailedResolutionWithCausingMethods {
        public IllegalAccessOrNoSuchMethodResult(DexEncodedMethod methodCausingError) {
            super(Collections.singletonList(methodCausingError));
            assert (methodCausingError != null);
        }
    }

    public static class NoSuchMethodResult
    extends FailedResolutionResult {
        static final NoSuchMethodResult INSTANCE = new NoSuchMethodResult();
    }

    public static class IncompatibleClassResult
    extends FailedResolutionWithCausingMethods {
        static final IncompatibleClassResult INSTANCE = new IncompatibleClassResult(Collections.emptyList());

        private IncompatibleClassResult(Collection<DexEncodedMethod> methodsCausingError) {
            super(methodsCausingError);
        }

        static IncompatibleClassResult create(Collection<DexEncodedMethod> methodsCausingError) {
            return methodsCausingError.isEmpty() ? INSTANCE : new IncompatibleClassResult(methodsCausingError);
        }
    }

    static abstract class FailedResolutionWithCausingMethods
    extends FailedResolutionResult {
        private final Collection<DexEncodedMethod> methodsCausingError;

        private FailedResolutionWithCausingMethods(Collection<DexEncodedMethod> methodsCausingError) {
            this.methodsCausingError = methodsCausingError;
        }

        @Override
        public void forEachFailureDependency(Consumer<DexEncodedMethod> methodCausingFailureConsumer) {
            this.methodsCausingError.forEach(methodCausingFailureConsumer);
        }
    }

    public static class ClassNotFoundResult
    extends FailedResolutionResult {
        static final ClassNotFoundResult INSTANCE = new ClassNotFoundResult();

        private ClassNotFoundResult() {
        }
    }

    public static abstract class FailedResolutionResult
    extends EmptyResult {
        @Override
        public boolean isFailedResolution() {
            return true;
        }

        @Override
        public FailedResolutionResult asFailedResolution() {
            return this;
        }

        public void forEachFailureDependency(Consumer<DexEncodedMethod> methodCausingFailureConsumer) {
        }

        @Override
        public boolean isAccessibleFrom(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return false;
        }

        @Override
        public boolean isAccessibleForVirtualDispatchFrom(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return false;
        }

        @Override
        public boolean isVirtualTarget() {
            return false;
        }
    }

    public static class ArrayCloneMethodResult
    extends EmptyResult {
        static final ArrayCloneMethodResult INSTANCE = new ArrayCloneMethodResult();

        private ArrayCloneMethodResult() {
        }

        @Override
        public boolean isAccessibleFrom(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return true;
        }

        @Override
        public boolean isAccessibleForVirtualDispatchFrom(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return true;
        }

        @Override
        public boolean isVirtualTarget() {
            return true;
        }
    }

    static abstract class EmptyResult
    extends ResolutionResult {
        EmptyResult() {
        }

        @Override
        public final DexEncodedMethod lookupInvokeSpecialTarget(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return null;
        }

        @Override
        public DexEncodedMethod lookupInvokeSuperTarget(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return null;
        }

        @Override
        public final DexEncodedMethod lookupInvokeSuperTarget(DexClass context, AppInfo appInfo) {
            return null;
        }

        @Override
        public final Set<DexEncodedMethod> lookupVirtualTargets(AppInfoWithSubtyping appInfo) {
            return null;
        }

        @Override
        public final Set<DexEncodedMethod> lookupInterfaceTargets(AppInfoWithSubtyping appInfo) {
            return null;
        }
    }

    public static class SingleResolutionResult
    extends ResolutionResult {
        private final DexClass initialResolutionHolder;
        private final DexClass resolvedHolder;
        private final DexEncodedMethod resolvedMethod;

        public SingleResolutionResult(DexClass initialResolutionHolder, DexClass resolvedHolder, DexEncodedMethod resolvedMethod) {
            assert (initialResolutionHolder != null);
            assert (resolvedHolder != null);
            assert (resolvedMethod != null);
            assert (resolvedHolder.type == resolvedMethod.method.holder);
            this.resolvedHolder = resolvedHolder;
            this.resolvedMethod = resolvedMethod;
            this.initialResolutionHolder = initialResolutionHolder;
        }

        public DexClass getResolvedHolder() {
            return this.resolvedHolder;
        }

        public DexEncodedMethod getResolvedMethod() {
            return this.resolvedMethod;
        }

        @Override
        public boolean isSingleResolution() {
            return true;
        }

        @Override
        public SingleResolutionResult asSingleResolution() {
            return this;
        }

        @Override
        public boolean isAccessibleFrom(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return AccessControl.isMethodAccessible(this.resolvedMethod, this.initialResolutionHolder, context, appInfo);
        }

        @Override
        public boolean isAccessibleForVirtualDispatchFrom(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            return this.resolvedMethod.isVirtualMethod() && this.isAccessibleFrom(context, appInfo);
        }

        @Override
        public boolean isVirtualTarget() {
            return this.resolvedMethod.isVirtualMethod();
        }

        @Override
        public DexEncodedMethod lookupInvokeSpecialTarget(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            if (!this.isAccessibleFrom(context, appInfo)) {
                return null;
            }
            DexEncodedMethod target = this.internalInvokeSpecialOrSuper(context, appInfo, (sup, sub) -> SingleResolutionResult.isSuperclass(sup, sub, appInfo));
            if (target == null) {
                return null;
            }
            DexClass holder = appInfo.definitionFor(target.method.holder);
            if (!AccessControl.isMethodAccessible(target, holder, context, appInfo)) {
                return null;
            }
            return target;
        }

        @Override
        public DexEncodedMethod lookupInvokeSuperTarget(DexProgramClass context, AppInfoWithSubtyping appInfo) {
            if (!this.isAccessibleFrom(context, appInfo)) {
                return null;
            }
            DexEncodedMethod target = this.lookupInvokeSuperTarget(context.asDexClass(), (AppInfo)appInfo);
            if (target == null) {
                return null;
            }
            DexClass holder = appInfo.definitionFor(target.method.holder);
            if (!AccessControl.isMethodAccessible(target, holder, context, appInfo)) {
                return null;
            }
            return target;
        }

        @Override
        public DexEncodedMethod lookupInvokeSuperTarget(DexClass context, AppInfo appInfo) {
            assert (context != null);
            if (this.resolvedMethod.isInstanceInitializer() || appInfo.hasSubtyping() && this.initialResolutionHolder != context && !SingleResolutionResult.isSuperclass(this.initialResolutionHolder, context, appInfo.withSubtyping())) {
                throw new CompilationError("Illegal invoke-super to " + this.resolvedMethod.toSourceString(), context.getOrigin());
            }
            return this.internalInvokeSpecialOrSuper(context, appInfo, (sup, sub) -> true);
        }

        private DexEncodedMethod internalInvokeSpecialOrSuper(DexClass context, AppInfo appInfo, BiPredicate<DexClass, DexClass> isSuperclass) {
            if (this.getResolvedMethod().isStatic()) {
                return null;
            }
            DexClass symbolicReference = this.initialResolutionHolder;
            DexClass initialType = !this.resolvedMethod.isInstanceInitializer() && !symbolicReference.isInterface() && isSuperclass.test(symbolicReference, context) ? (context.superType == null ? null : appInfo.definitionFor(context.superType)) : symbolicReference;
            if (initialType == null) {
                return null;
            }
            DexMethod method = this.getResolvedMethod().method;
            DexEncodedMethod target = null;
            DexClass current = initialType;
            while (current != null && (target = current.lookupMethod(method)) == null) {
                current = current.superType == null ? null : appInfo.definitionFor(current.superType);
            }
            if (target == null) {
                target = appInfo.resolveMaximallySpecificMethods(initialType, method).getSingleTarget();
            }
            if (target == null) {
                return null;
            }
            if (target.isStatic()) {
                return null;
            }
            if ((target.isInstanceInitializer() || target.isPrivateMethod()) && target.method.holder != symbolicReference.type) {
                return null;
            }
            if (target.isAbstract()) {
                return null;
            }
            return target;
        }

        private static boolean isSuperclass(DexClass sup, DexClass sub, AppInfoWithSubtyping appInfo) {
            return sup != sub && appInfo.isSubtype(sub.type, sup.type);
        }

        @Override
        public Set<DexEncodedMethod> lookupVirtualTargets(AppInfoWithSubtyping appInfo) {
            if (this.resolvedMethod.isPrivateMethod()) {
                return Collections.singleton(this.resolvedMethod);
            }
            assert (this.resolvedMethod.isNonPrivateVirtualMethod());
            Set<DexEncodedMethod> result = SetUtils.newIdentityHashSet(this.resolvedMethod);
            DexMethod method = this.resolvedMethod.method;
            for (DexType type : appInfo.subtypes(method.holder)) {
                ResolutionResult methods;
                DexEncodedMethod target;
                DexClass clazz = appInfo.definitionFor(type);
                if (clazz.isInterface() || (target = (methods = appInfo.resolveMethodOnClass(clazz, method)).getSingleTarget()) == null || !target.isNonPrivateVirtualMethod()) continue;
                result.add(target);
            }
            return result;
        }

        @Override
        public Set<DexEncodedMethod> lookupInterfaceTargets(AppInfoWithSubtyping appInfo) {
            DexProgramClass holder;
            if (this.resolvedMethod.isPrivateMethod()) {
                assert (this.resolvedMethod.hasCode());
                return Collections.singleton(this.resolvedMethod);
            }
            assert (this.resolvedMethod.isNonPrivateVirtualMethod());
            Set<DexEncodedMethod> result = Sets.newIdentityHashSet();
            if (this.resolvedMethod.hasCode() && appInfo.hasAnyInstantiatedLambdas(holder = this.resolvedHolder.asProgramClass())) {
                result.add(this.resolvedMethod);
            }
            DexMethod method = this.resolvedMethod.method;
            Consumer<DexEncodedMethod> addIfNotAbstract = m -> {
                if (!m.accessFlags.isAbstract()) {
                    result.add((DexEncodedMethod)m);
                }
            };
            Consumer<DexEncodedMethod> addIfNotAbstractAndBridge = m -> {
                if (!m.accessFlags.isAbstract() && m.accessFlags.isBridge()) {
                    result.add((DexEncodedMethod)m);
                }
            };
            for (DexType type : appInfo.subtypes(method.holder)) {
                ResolutionResult targetMethods;
                DexClass clazz = appInfo.definitionFor(type);
                if (clazz.isInterface()) {
                    targetMethods = appInfo.resolveMethodOnInterface(clazz, method);
                    if (!targetMethods.isSingleResolution()) continue;
                    addIfNotAbstractAndBridge.accept(targetMethods.getSingleTarget());
                    continue;
                }
                targetMethods = appInfo.resolveMethodOnClass(clazz, method);
                if (!targetMethods.isSingleResolution()) continue;
                addIfNotAbstract.accept(targetMethods.getSingleTarget());
            }
            return result;
        }
    }
}

