/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;

public abstract class UseRegistry {
    private DexItemFactory factory;

    public UseRegistry(DexItemFactory factory) {
        this.factory = factory;
    }

    public abstract boolean registerInvokeVirtual(DexMethod var1);

    public abstract boolean registerInvokeDirect(DexMethod var1);

    public abstract boolean registerInvokeStatic(DexMethod var1);

    public abstract boolean registerInvokeInterface(DexMethod var1);

    public abstract boolean registerInvokeSuper(DexMethod var1);

    public abstract boolean registerInstanceFieldWrite(DexField var1);

    public abstract boolean registerInstanceFieldRead(DexField var1);

    public abstract boolean registerNewInstance(DexType var1);

    public abstract boolean registerStaticFieldRead(DexField var1);

    public abstract boolean registerStaticFieldWrite(DexField var1);

    public abstract boolean registerTypeReference(DexType var1);

    public boolean registerConstClass(DexType type) {
        return this.registerTypeReference(type);
    }

    public boolean registerCheckCast(DexType type) {
        return this.registerTypeReference(type);
    }

    public void registerMethodHandle(DexMethodHandle methodHandle, MethodHandleUse use) {
        switch (methodHandle.type) {
            case INSTANCE_GET: {
                this.registerInstanceFieldRead(methodHandle.asField());
                break;
            }
            case INSTANCE_PUT: {
                this.registerInstanceFieldWrite(methodHandle.asField());
                break;
            }
            case STATIC_GET: {
                this.registerStaticFieldRead(methodHandle.asField());
                break;
            }
            case STATIC_PUT: {
                this.registerStaticFieldWrite(methodHandle.asField());
                break;
            }
            case INVOKE_INSTANCE: {
                this.registerInvokeVirtual(methodHandle.asMethod());
                break;
            }
            case INVOKE_STATIC: {
                this.registerInvokeStatic(methodHandle.asMethod());
                break;
            }
            case INVOKE_CONSTRUCTOR: {
                DexMethod method = methodHandle.asMethod();
                this.registerNewInstance(method.holder);
                this.registerInvokeDirect(method);
                break;
            }
            case INVOKE_INTERFACE: {
                this.registerInvokeInterface(methodHandle.asMethod());
                break;
            }
            case INVOKE_SUPER: {
                this.registerInvokeSuper(methodHandle.asMethod());
                break;
            }
            case INVOKE_DIRECT: {
                this.registerInvokeDirect(methodHandle.asMethod());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void registerCallSite(DexCallSite callSite) {
        boolean isLambdaMetaFactory = this.factory.isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
        this.registerMethodHandle(callSite.bootstrapMethod, MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
        this.registerTypeReference(callSite.methodProto.returnType);
        for (DexValue arg : callSite.bootstrapArgs) {
            if (arg instanceof DexValue.DexValueType) {
                this.registerTypeReference((DexType)((DexValue.DexValueType)arg).value);
                continue;
            }
            if (arg instanceof DexValue.DexValueMethodHandle) {
                DexMethodHandle handle = (DexMethodHandle)((DexValue.DexValueMethodHandle)arg).value;
                MethodHandleUse use = isLambdaMetaFactory ? MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY : MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;
                this.registerMethodHandle(handle, use);
                continue;
            }
            if (arg instanceof DexValue.DexValueMethodType) {
                this.registerProto((DexProto)((DexValue.DexValueMethodType)arg).value);
                continue;
            }
            assert (arg instanceof DexValue.DexValueInt || arg instanceof DexValue.DexValueLong || arg instanceof DexValue.DexValueFloat || arg instanceof DexValue.DexValueDouble || arg instanceof DexValue.DexValueString);
        }
    }

    public void registerProto(DexProto proto) {
        this.registerTypeReference(proto.returnType);
        for (DexType type : proto.parameters.values) {
            this.registerTypeReference(type);
        }
    }

    public static enum MethodHandleUse {
        ARGUMENT_TO_LAMBDA_METAFACTORY,
        NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;

    }
}

