/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis;

import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Return;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Throw;

public class TypeChecker {
    private final AppView<? extends AppInfoWithSubtyping> appView;

    public TypeChecker(AppView<? extends AppInfoWithSubtyping> appView) {
        this.appView = appView;
    }

    public boolean check(IRCode code) {
        for (Instruction instruction : code.instructions()) {
            if (!(instruction.isInstancePut() ? !this.check(instruction.asInstancePut()) : (instruction.isReturn() ? !this.check(instruction.asReturn(), code.method) : (instruction.isStaticPut() ? !this.check(instruction.asStaticPut()) : instruction.isThrow() && !this.check(instruction.asThrow()))))) continue;
            return false;
        }
        return true;
    }

    public boolean check(InstancePut instruction) {
        return this.checkFieldPut(instruction);
    }

    public boolean check(Return instruction, DexEncodedMethod method) {
        TypeLatticeElement returnType;
        if (instruction.isReturnVoid()) {
            return true;
        }
        TypeLatticeElement valueType = instruction.returnValue().getTypeLattice();
        if (this.isSubtypeOf(valueType, returnType = TypeLatticeElement.fromDexType(method.method.proto.returnType, Nullability.maybeNull(), this.appView))) {
            return true;
        }
        if (returnType.isClassType() && valueType.isReference()) {
            DexClass clazz = this.appView.definitionFor(method.method.proto.returnType);
            return clazz != null && clazz.isInterface();
        }
        return false;
    }

    public boolean check(StaticPut instruction) {
        return this.checkFieldPut(instruction);
    }

    public boolean checkFieldPut(FieldInstruction instruction) {
        TypeLatticeElement fieldType;
        assert (instruction.isFieldPut());
        TypeLatticeElement valueType = instruction.value().getTypeLattice();
        if (this.isSubtypeOf(valueType, fieldType = TypeLatticeElement.fromDexType(instruction.getField().type, valueType.nullability(), this.appView))) {
            return true;
        }
        if (fieldType.isClassType() && valueType.isReference()) {
            DexClass clazz = this.appView.definitionFor(instruction.getField().type);
            return clazz != null && clazz.isInterface();
        }
        return false;
    }

    public boolean check(Throw instruction) {
        TypeLatticeElement valueType = instruction.exception().getTypeLattice();
        TypeLatticeElement throwableType = TypeLatticeElement.fromDexType(this.appView.dexItemFactory().throwableType, valueType.nullability(), this.appView);
        return this.isSubtypeOf(valueType, throwableType);
    }

    private boolean isSubtypeOf(TypeLatticeElement expectedSubtype, TypeLatticeElement expectedSupertype) {
        return expectedSubtype.isNullType() && expectedSupertype.isReference() || expectedSubtype.lessThanOrEqual(expectedSupertype, this.appView) || expectedSubtype.isBasedOnMissingClass(this.appView);
    }
}

