/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.type;

import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.BooleanTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.BottomTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ByteTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.CharTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.DoubleTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.FloatTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.IntTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.LongTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ShortTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.SinglePrimitiveTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TopTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.WidePrimitiveTypeLatticeElement;

public abstract class TypeLatticeElement {
    public static final BottomTypeLatticeElement BOTTOM = BottomTypeLatticeElement.getInstance();
    public static final TopTypeLatticeElement TOP = TopTypeLatticeElement.getInstance();
    public static final BooleanTypeLatticeElement BOOLEAN = BooleanTypeLatticeElement.getInstance();
    public static final ByteTypeLatticeElement BYTE = ByteTypeLatticeElement.getInstance();
    static final ShortTypeLatticeElement SHORT = ShortTypeLatticeElement.getInstance();
    static final CharTypeLatticeElement CHAR = CharTypeLatticeElement.getInstance();
    public static final IntTypeLatticeElement INT = IntTypeLatticeElement.getInstance();
    public static final FloatTypeLatticeElement FLOAT = FloatTypeLatticeElement.getInstance();
    public static final SinglePrimitiveTypeLatticeElement SINGLE = SinglePrimitiveTypeLatticeElement.getInstance();
    public static final LongTypeLatticeElement LONG = LongTypeLatticeElement.getInstance();
    public static final DoubleTypeLatticeElement DOUBLE = DoubleTypeLatticeElement.getInstance();
    public static final WidePrimitiveTypeLatticeElement WIDE = WidePrimitiveTypeLatticeElement.getInstance();
    public static final ReferenceTypeLatticeElement NULL = ReferenceTypeLatticeElement.getNullTypeLatticeElement();

    public TypeLatticeElement fixupClassTypeReferences(Function<DexType, DexType> mapping, AppView<? extends AppInfoWithSubtyping> appView) {
        return this;
    }

    public boolean isNullable() {
        return this.nullability().isNullable();
    }

    public abstract Nullability nullability();

    public TypeLatticeElement join(TypeLatticeElement other, AppView<?> appView) {
        if (this == other) {
            return this;
        }
        if (this.isBottom()) {
            return other;
        }
        if (other.isBottom()) {
            return this;
        }
        if (this.isTop() || other.isTop()) {
            return TOP;
        }
        if (this.isPrimitive()) {
            return other.isPrimitive() ? this.asPrimitiveTypeLatticeElement().join(other.asPrimitiveTypeLatticeElement()) : TOP;
        }
        if (other.isPrimitive()) {
            return TOP;
        }
        assert (this.isReference() && other.isReference());
        assert (this.isPreciseType() && other.isPreciseType());
        Nullability nullabilityJoin = this.nullability().join(other.nullability());
        if (this.isNullType()) {
            return other.asReferenceTypeLatticeElement().getOrCreateVariant(nullabilityJoin);
        }
        if (other.isNullType()) {
            return this.asReferenceTypeLatticeElement().getOrCreateVariant(nullabilityJoin);
        }
        if (this.getClass() != other.getClass()) {
            return TypeLatticeElement.objectClassType(appView, nullabilityJoin);
        }
        if (this.isArrayType()) {
            assert (other.isArrayType());
            return this.asArrayTypeLatticeElement().join(other.asArrayTypeLatticeElement(), appView);
        }
        if (this.isClassType()) {
            assert (other.isClassType());
            return this.asClassTypeLatticeElement().join(other.asClassTypeLatticeElement(), appView);
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    public static TypeLatticeElement join(Iterable<TypeLatticeElement> typeLattices, AppView<?> appView) {
        TypeLatticeElement result = BOTTOM;
        for (TypeLatticeElement other : typeLattices) {
            result = result.join(other, appView);
        }
        return result;
    }

    public boolean strictlyLessThan(TypeLatticeElement other, AppView<?> appView) {
        if (this.equals(other)) {
            return false;
        }
        TypeLatticeElement lub = this.join(other, appView);
        return !this.equals(lub) && other.equals(lub);
    }

    public boolean lessThanOrEqual(TypeLatticeElement other, AppView<?> appView) {
        return this.equals(other) || this.strictlyLessThan(other, appView);
    }

    public boolean lessThanOrEqualUpToNullability(TypeLatticeElement other, AppView<?> appView) {
        if (this == other) {
            return true;
        }
        if (this.isTop()) {
            return other.isTop();
        }
        if (other.isTop()) {
            return true;
        }
        if (this.isBottom()) {
            return true;
        }
        if (other.isBottom()) {
            return false;
        }
        if (this.isPrimitive()) {
            return this.lessThanOrEqual(other, appView);
        }
        assert (this.isReference() && other.isReference());
        ReferenceTypeLatticeElement otherAsNullable = other.isNullable() ? other.asReferenceTypeLatticeElement() : other.asReferenceTypeLatticeElement().getOrCreateVariant(Nullability.maybeNull());
        return this.lessThanOrEqual(otherAsNullable, appView);
    }

    public boolean equalUpToNullability(TypeLatticeElement other) {
        if (this == other) {
            return true;
        }
        if (this.isPrimitive() || other.isPrimitive()) {
            return false;
        }
        assert (this.isReference() && other.isReference());
        ReferenceTypeLatticeElement thisAsMaybeNull = this.asReferenceTypeLatticeElement().getOrCreateVariant(Nullability.maybeNull());
        ReferenceTypeLatticeElement otherAsMaybeNull = other.asReferenceTypeLatticeElement().getOrCreateVariant(Nullability.maybeNull());
        return thisAsMaybeNull.equals(otherAsMaybeNull);
    }

    public boolean isBasedOnMissingClass(AppView<? extends AppInfoWithSubtyping> appView) {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public ReferenceTypeLatticeElement asReferenceTypeLatticeElement() {
        return null;
    }

    public boolean isArrayType() {
        return false;
    }

    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return null;
    }

    public boolean isClassType() {
        return false;
    }

    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return null;
    }

    public boolean isSinglePrimitive() {
        return false;
    }

    public boolean isWidePrimitive() {
        return false;
    }

    boolean isBoolean() {
        return false;
    }

    boolean isByte() {
        return false;
    }

    boolean isShort() {
        return false;
    }

    boolean isChar() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isPreciseType() {
        return this.isArrayType() || this.isClassType() || this.isNullType() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble() || this.isBottom();
    }

    public boolean isFineGrainedType() {
        return this.isBoolean() || this.isByte() || this.isShort() || this.isChar();
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isDefinitelyNull() {
        return this.nullability().isDefinitelyNull();
    }

    public boolean isDefinitelyNotNull() {
        return this.nullability().isDefinitelyNotNull();
    }

    public int requiredRegisters() {
        assert (!this.isBottom() && !this.isTop());
        return 1;
    }

    public static ClassTypeLatticeElement objectClassType(AppView<?> appView, Nullability nullability) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().objectType, nullability, appView).asClassTypeLatticeElement();
    }

    static ArrayTypeLatticeElement objectArrayType(AppView<?> appView, Nullability nullability) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return TypeLatticeElement.fromDexType(dexItemFactory.createArrayType(1, dexItemFactory.objectType), nullability, appView).asArrayTypeLatticeElement();
    }

    public static ClassTypeLatticeElement classClassType(AppView<?> appView, Nullability nullability) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().classType, nullability, appView).asClassTypeLatticeElement();
    }

    public static ClassTypeLatticeElement stringClassType(AppView<?> appView, Nullability nullability) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().stringType, nullability, appView).asClassTypeLatticeElement();
    }

    public static TypeLatticeElement fromDexType(DexType type, Nullability nullability, AppView<?> appView) {
        return TypeLatticeElement.fromDexType(type, nullability, appView, false);
    }

    public static TypeLatticeElement fromDexType(DexType type, Nullability nullability, AppView<?> appView, boolean asArrayElementType) {
        if (type == DexItemFactory.nullValueType) {
            assert (!nullability.isDefinitelyNotNull());
            return NULL;
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.fromDexType(type, asArrayElementType);
        }
        return appView.dexItemFactory().createReferenceTypeLatticeElement(type, nullability, appView);
    }

    public boolean isValueTypeCompatible(TypeLatticeElement other) {
        return this.isReference() && other.isReference() || this.isSinglePrimitive() && other.isSinglePrimitive() || this.isWidePrimitive() && other.isWidePrimitive();
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

