/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Collections;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.AbstractError;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.ConcreteMutableFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.UnknownFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.UnknownValue;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldMemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public abstract class FieldInstruction
extends Instruction {
    private final DexField field;

    protected FieldInstruction(DexField field, Value dest, Value value) {
        this(field, dest, Collections.singletonList(value));
    }

    protected FieldInstruction(DexField field, Value dest, List<Value> inValues) {
        super(dest, inValues);
        assert (field != null);
        this.field = field;
    }

    public abstract Value value();

    public FieldMemberType getType() {
        return FieldMemberType.fromDexType(this.field.type);
    }

    public DexField getField() {
        return this.field;
    }

    @Override
    public boolean isFieldInstruction() {
        return true;
    }

    @Override
    public FieldInstruction asFieldInstruction() {
        return this;
    }

    @Override
    public AbstractError instructionInstanceCanThrow(AppView<?> appView, DexType context) {
        boolean mayTriggerClassInitialization;
        Value receiver;
        DexEncodedField resolvedField;
        if (appView.enableWholeProgramOptimizations()) {
            resolvedField = ((AppInfo)appView.appInfo()).resolveField(this.field);
        } else {
            if (this.field.holder != context) {
                return AbstractError.top();
            }
            DexClass holder = appView.definitionFor(this.field.holder);
            if (holder == null) {
                return AbstractError.top();
            }
            resolvedField = holder.lookupField(this.field);
        }
        if (resolvedField == null) {
            if (appView.enableWholeProgramOptimizations()) {
                return AbstractError.specific(appView.dexItemFactory().noSuchFieldErrorType);
            }
            return AbstractError.top();
        }
        if (resolvedField.isStaticMember() ? this.isInstanceGet() || this.isInstancePut() : this.isStaticGet() || this.isStaticPut()) {
            return AbstractError.specific(appView.dexItemFactory().icceType);
        }
        if (!MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(appView, context, resolvedField.field.holder, resolvedField.accessFlags)) {
            return AbstractError.specific(appView.dexItemFactory().illegalAccessErrorType);
        }
        if ((this.isInstanceGet() || this.isInstancePut()) && ((receiver = (Value)this.inValues.get(0)).isAlwaysNull(appView) || receiver.typeLattice.isNullable())) {
            return AbstractError.specific(appView.dexItemFactory().npeType);
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return AbstractError.bottom();
        }
        boolean bl = mayTriggerClassInitialization = this.isStaticGet() || this.isStaticPut();
        if (mayTriggerClassInitialization) {
            if (((AppInfo)appView.appInfo()).hasLiveness()) {
                AppInfoWithLiveness appInfoWithLiveness = ((AppInfo)appView.appInfo()).withLiveness();
                if (appInfoWithLiveness.noSideEffects.containsKey(resolvedField.field)) {
                    return AbstractError.bottom();
                }
            }
            if (this.field.holder.classInitializationMayHaveSideEffects(appView, type -> appView.isSubtype(context, (DexType)type).isTrue())) {
                return AbstractError.top();
            }
        }
        return AbstractError.bottom();
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public AbstractFieldSet readSet(AppView<?> appView, DexType context) {
        if (this.instructionMayTriggerMethodInvocation(appView, context)) {
            return UnknownFieldSet.getInstance();
        }
        if (this.isFieldGet()) {
            DexField field = this.getField();
            DexEncodedField encodedField = null;
            if (appView.enableWholeProgramOptimizations()) {
                encodedField = ((AppInfo)appView.appInfo()).resolveField(field);
            } else {
                DexClass clazz = appView.definitionFor(field.holder);
                if (clazz != null) {
                    encodedField = clazz.lookupField(field);
                }
            }
            if (encodedField != null) {
                return new ConcreteMutableFieldSet(encodedField);
            }
            return UnknownFieldSet.getInstance();
        }
        assert (this.isFieldPut());
        return EmptyFieldSet.getInstance();
    }

    boolean isStoringObjectWithFinalizer(AppInfoWithLiveness appInfo) {
        TypeLatticeElement baseType;
        assert (this.isFieldPut());
        TypeLatticeElement type = this.value().getTypeLattice();
        TypeLatticeElement typeLatticeElement = baseType = type.isArrayType() ? type.asArrayTypeLatticeElement().getArrayBaseTypeLattice() : type;
        if (baseType.isClassType()) {
            Value root = this.value().getAliasedValue();
            if (!root.isPhi() && root.definition.isNewInstance()) {
                DexClass clazz = appInfo.definitionFor(root.definition.asNewInstance().clazz);
                if (clazz == null) {
                    return true;
                }
                if (clazz.superType == null) {
                    return false;
                }
                DexItemFactory dexItemFactory = appInfo.dexItemFactory();
                DexEncodedMethod resolutionResult = appInfo.resolveMethod(clazz.type, dexItemFactory.objectMethods.finalize).getSingleTarget();
                return resolutionResult != null && resolutionResult.isProgramMethod(appInfo);
            }
            return appInfo.mayHaveFinalizeMethodDirectlyOrIndirectly(baseType.asClassTypeLatticeElement());
        }
        return false;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<?> appView, DexType context) {
        assert (this.isFieldGet());
        DexEncodedField field = ((AppInfo)appView.appInfo()).resolveField(this.getField());
        if (field != null) {
            return field.getOptimizationInfo().getAbstractValue();
        }
        return UnknownValue.getInstance();
    }
}

