/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.code.FillArrayData;
import shadow.bundletool.com.android.tools.r8.code.FillArrayDataPayload;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.AbstractError;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class NewArrayFilledData
extends Instruction {
    private static final String ERROR_MESSAGE = "Conversion from DEX to classfile not supported for NewArrayFilledData";
    public final int element_width;
    public final long size;
    public final short[] data;

    public NewArrayFilledData(Value src, int element_width, long size, short[] data2) {
        super(null, src);
        this.element_width = element_width;
        this.size = size;
        this.data = data2;
    }

    @Override
    public int opcode() {
        return 47;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value src() {
        return (Value)this.inValues.get(0);
    }

    public FillArrayDataPayload createPayload() {
        return new FillArrayDataPayload(this.element_width, this.size, this.data);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int src = builder.allocatedRegister(this.src(), this.getNumber());
        builder.addFillArrayData(this, new FillArrayData(src));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isNewArrayFilledData()) {
            return false;
        }
        NewArrayFilledData o = other.asNewArrayFilledData();
        return o.element_width == this.element_width && o.size == this.size && Arrays.equals(o.data, this.data);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "NewArrayFilledData defines no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isNewArrayFilledData() {
        return true;
    }

    @Override
    public NewArrayFilledData asNewArrayFilledData() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forNewArrayFilledData();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public AbstractError instructionInstanceCanThrow(AppView<?> appView, DexType context) {
        if (appView.options().debug) {
            return AbstractError.top();
        }
        if (this.src().getTypeLattice().isNullable()) {
            return AbstractError.top();
        }
        return AbstractError.bottom();
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (this.instructionInstanceCanThrow(appView, context).isThrowing() || this.src().numberOfAllUsers() > 1) {
            return true;
        }
        assert (this.src().singleUniqueUser() == this);
        assert (!this.src().isPhi());
        assert (this.src().definition.isNewArrayEmpty());
        return false;
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }
}

