/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraph;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CodeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PartialCallGraphBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PostOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.IROrdering;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

class PostMethodProcessor
implements MethodProcessor {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexEncodedMethod, Collection<CodeOptimization>> methodsMap;
    private final Deque<Collection<DexEncodedMethod>> waves;
    private Collection<DexEncodedMethod> wave;

    private PostMethodProcessor(AppView<AppInfoWithLiveness> appView, Map<DexEncodedMethod, Collection<CodeOptimization>> methodsMap, CallGraph callGraph) {
        this.appView = appView;
        this.methodsMap = methodsMap;
        this.waves = this.createWaves(appView, callGraph);
    }

    @Override
    public MethodProcessor.Phase getPhase() {
        return MethodProcessor.Phase.POST;
    }

    private Deque<Collection<DexEncodedMethod>> createWaves(AppView<?> appView, CallGraph callGraph) {
        IROrdering shuffle = appView.options().testing.irOrdering;
        ArrayDeque<Collection<DexEncodedMethod>> waves = new ArrayDeque<Collection<DexEncodedMethod>>();
        int waveCount = 1;
        while (!callGraph.isEmpty()) {
            Set<DexEncodedMethod> wave = callGraph.extractRoots();
            waves.addLast(shuffle.order((Collection<DexEncodedMethod>)wave));
            if (!Log.ENABLED || !Log.isLoggingEnabledFor(PostMethodProcessor.class)) continue;
            Log.info(this.getClass(), "Wave #%d: %d", waveCount++, wave.size());
        }
        return waves;
    }

    @Override
    public boolean isProcessedConcurrently(DexEncodedMethod method) {
        return this.wave != null && this.wave.contains(method);
    }

    void forEachWave(OptimizationFeedback feedback, ExecutorService executorService) throws ExecutionException {
        while (!this.waves.isEmpty()) {
            this.wave = this.waves.removeFirst();
            assert (this.wave.size() > 0);
            ThreadUtils.processItems(this.wave, method -> {
                Collection<CodeOptimization> codeOptimizations = this.methodsMap.get(method);
                assert (codeOptimizations != null && !codeOptimizations.isEmpty());
                this.forEachMethod((DexEncodedMethod)method, codeOptimizations, feedback);
            }, executorService);
        }
    }

    private void forEachMethod(DexEncodedMethod method, Collection<CodeOptimization> codeOptimizations, OptimizationFeedback feedback) {
        Origin origin = this.appView.appInfo().originFor(method.method.holder);
        if (this.appView.options().skipIR) {
            feedback.markProcessed(method, Inliner.ConstraintWithTarget.NEVER);
            return;
        }
        IRCode code = method.buildIR(this.appView, origin);
        if (code == null) {
            feedback.markProcessed(method, Inliner.ConstraintWithTarget.NEVER);
            return;
        }
        for (CodeOptimization codeOptimization : codeOptimizations) {
            codeOptimization.optimize(code, feedback, this);
        }
    }

    static class Builder {
        private final Collection<CodeOptimization> defaultCodeOptimizations;
        private final Map<DexEncodedMethod, Collection<CodeOptimization>> methodsMap = Maps.newIdentityHashMap();

        Builder(Collection<CodeOptimization> defaultCodeOptimizations) {
            this.defaultCodeOptimizations = defaultCodeOptimizations;
        }

        private void put(Set<DexEncodedMethod> methodsToRevisit, Collection<CodeOptimization> codeOptimizations) {
            if (codeOptimizations.isEmpty()) {
                return;
            }
            for (DexEncodedMethod method : methodsToRevisit) {
                this.methodsMap.computeIfAbsent(method, k -> new LinkedHashSet()).addAll(codeOptimizations);
            }
        }

        void put(Set<DexEncodedMethod> methodsToRevisit) {
            this.put(methodsToRevisit, this.defaultCodeOptimizations);
        }

        void put(PostOptimization postOptimization) {
            Collection<CodeOptimization> codeOptimizations = postOptimization.codeOptimizationsForPostProcessing();
            if (codeOptimizations == null) {
                codeOptimizations = this.defaultCodeOptimizations;
            }
            this.put(postOptimization.methodsToRevisit(), codeOptimizations);
        }

        PostMethodProcessor build(AppView<AppInfoWithLiveness> appView, ExecutorService executorService, Timing timing) throws ExecutionException {
            if (this.methodsMap.keySet().isEmpty()) {
                return null;
            }
            CallGraph callGraph = new PartialCallGraphBuilder(appView, this.methodsMap.keySet()).build(executorService, timing);
            return new PostMethodProcessor(appView, this.methodsMap, callGraph);
        }
    }
}

