/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.NestMemberClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.BackportedMethods;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.BooleanMethodRewrites;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.CollectionMethodGenerators;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.CollectionMethodRewrites;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.FloatMethodRewrites;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.LongMethodRewrites;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.NumericMethodRewrites;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.ObjectsMethodRewrites;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.OptionalMethodRewrites;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public final class BackportedMethodRewriter {
    public static final String UTILITY_CLASS_NAME_PREFIX = "$r8$backportedMethods$utility";
    private final AppView<?> appView;
    private final IRConverter converter;
    private final DexItemFactory factory;
    private final RewritableMethods rewritableMethods;
    private final Set<DexType> holders = Sets.newConcurrentHashSet();
    private final Map<DexMethod, MethodProvider> methodProviders = new ConcurrentHashMap<DexMethod, MethodProvider>();

    public BackportedMethodRewriter(AppView<?> appView, IRConverter converter) {
        this.appView = appView;
        this.converter = converter;
        this.factory = appView.dexItemFactory();
        this.rewritableMethods = new RewritableMethods(appView.options(), appView);
    }

    public static List<DexMethod> generateListOfBackportedMethods(AndroidApiLevel apiLevel) {
        ArrayList<DexMethod> methods = new ArrayList<DexMethod>();
        InternalOptions options = new InternalOptions();
        options.minApiLevel = apiLevel.getLevel();
        AppView<Object> appView = AppView.createForD8(null, options);
        RewritableMethods rewritableMethods = new RewritableMethods(options, appView);
        rewritableMethods.visit(methods::add);
        return methods;
    }

    public void desugar(IRCode code) {
        if (this.rewritableMethods.isEmpty()) {
            return;
        }
        InstructionListIterator iterator2 = code.instructionListIterator();
        while (iterator2.hasNext()) {
            DexEncodedMethod dexEncodedMethod;
            Instruction instruction = (Instruction)iterator2.next();
            if (!instruction.isInvokeMethod()) continue;
            InvokeMethod invoke = instruction.asInvokeMethod();
            MethodProvider provider = this.getMethodProviderOrNull(invoke.getInvokedMethod());
            if (provider == null) {
                ResolutionResult resolutionResult;
                if (!this.rewritableMethods.matchesVirtualRewrite(invoke.getInvokedMethod()) || (resolutionResult = ((AppInfo)this.appView.appInfo()).resolveMethod(invoke.getInvokedMethod().holder, invoke.getInvokedMethod())).isFailedResolution()) continue;
                DexEncodedMethod singleTarget = resolutionResult.getSingleTarget();
                assert (singleTarget != null);
                provider = this.getMethodProviderOrNull(singleTarget.method);
                if (provider == null) continue;
            }
            if (invoke.isInvokeSuper() && this.rewritableMethods.matchesVirtualRewrite(invoke.getInvokedMethod()) && (dexEncodedMethod = ((AppInfo)this.appView.appInfo()).lookupSuperTarget(invoke.getInvokedMethod(), code.method.method.holder)) != null && !dexEncodedMethod.isFinal()) {
                DexMethod retargetMethod = this.appView.options().desugaredLibraryConfiguration.retargetMethod(dexEncodedMethod.method, this.appView);
                if (retargetMethod == null) continue;
                iterator2.replaceCurrentInstruction(new InvokeStatic(retargetMethod, invoke.outValue(), invoke.arguments()));
                continue;
            }
            provider.rewriteInvoke(invoke, iterator2, code, this.appView);
            if (!provider.requiresGenerationOfCode()) continue;
            DexMethod newMethod = provider.provideMethod(this.appView);
            this.methodProviders.putIfAbsent(newMethod, provider);
            this.holders.add(code.method.method.holder);
        }
    }

    private Collection<DexProgramClass> findSynthesizedFrom(DexApplication.Builder<?> builder, DexType holder) {
        for (DexProgramClass synthesizedClass : builder.getSynthesizedClasses()) {
            if (holder != synthesizedClass.getType()) continue;
            return synthesizedClass.getSynthesizedFrom();
        }
        return null;
    }

    public static boolean hasRewrittenMethodPrefix(DexType clazz) {
        return clazz.descriptor.toString().contains(UTILITY_CLASS_NAME_PREFIX);
    }

    public void synthesizeUtilityClasses(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.appView.options().isDesugaredLibraryCompilation()) {
            this.synthesizeEmulatedDispatchMethods(builder);
        } else {
            this.addInterfacesAndForwardingMethods(executorService);
        }
        if (this.holders.isEmpty()) {
            return;
        }
        Set<DexProgramClass> referencingClasses = Sets.newConcurrentHashSet();
        for (DexType holder : this.holders) {
            DexClass definitionFor = this.appView.definitionFor(holder);
            if (definitionFor == null) {
                Collection<DexProgramClass> synthesizedFrom = this.findSynthesizedFrom(builder, holder);
                assert (synthesizedFrom != null);
                referencingClasses.addAll(synthesizedFrom);
                continue;
            }
            referencingClasses.add(definitionFor.asProgramClass());
        }
        MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
        ClassAccessFlags classAccessFlags = ClassAccessFlags.fromSharedAccessFlags(4097);
        while (!this.methodProviders.isEmpty()) {
            DexMethod method = this.methodProviders.keySet().iterator().next();
            MethodProvider provider = this.methodProviders.remove(method);
            assert (provider.requiresGenerationOfCode());
            if (this.appView.definitionFor(method.holder) != null) continue;
            Code code = provider.generateTemplateMethod(this.appView.options(), method);
            DexEncodedMethod dexEncodedMethod = new DexEncodedMethod(method, flags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code, true);
            boolean addToMainDexList = referencingClasses.stream().anyMatch(clazz -> ((AppInfo)this.appView.appInfo()).isInMainDexList(clazz.type));
            DexProgramClass utilityClass = this.synthesizeClassWithUniqueMethod(builder, classAccessFlags, method.holder, dexEncodedMethod, "java8 methods utility class", addToMainDexList);
            this.converter.optimizeSynthesizedClass(utilityClass, executorService);
        }
    }

    private void addInterfacesAndForwardingMethods(ExecutorService executorService) throws ExecutionException {
        assert (!this.appView.options().isDesugaredLibraryCompilation());
        IdentityHashMap map2 = Maps.newIdentityHashMap();
        for (DexMethod emulatedDispatchMethod : this.rewritableMethods.getEmulatedDispatchMethods()) {
            map2.putIfAbsent(emulatedDispatchMethod.holder, new ArrayList(1));
            ((List)map2.get(emulatedDispatchMethod.holder)).add(emulatedDispatchMethod);
        }
        ArrayList<DexEncodedMethod> addedMethods = new ArrayList<DexEncodedMethod>();
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            if (clazz.superType == null) {
                assert (clazz.type == this.appView.dexItemFactory().objectType) : clazz.type.toSourceString();
                continue;
            }
            DexClass dexClass = this.appView.definitionFor(clazz.superType);
            if (dexClass == null || !dexClass.isLibraryClass() || dexClass.type == this.appView.dexItemFactory().objectType) continue;
            for (DexType dexType : map2.keySet()) {
                if (!this.inherit(dexClass.asLibraryClass(), dexType)) continue;
                addedMethods.addAll(this.addInterfacesAndForwardingMethods(clazz, (List)map2.get(dexType)));
            }
        }
        if (addedMethods.isEmpty()) {
            return;
        }
        this.converter.processMethodsConcurrently(addedMethods, executorService);
    }

    private boolean inherit(DexLibraryClass clazz, DexType typeToInherit) {
        DexLibraryClass current = clazz;
        while (current.type != this.appView.dexItemFactory().objectType) {
            if (current.type == typeToInherit) {
                return true;
            }
            current = this.appView.definitionFor(current.superType).asLibraryClass();
        }
        return false;
    }

    private List<DexEncodedMethod> addInterfacesAndForwardingMethods(DexProgramClass clazz, List<DexMethod> dexMethods) {
        ArrayList<DexEncodedMethod> newForwardingMethods = new ArrayList<DexEncodedMethod>();
        for (DexMethod dexMethod : dexMethods) {
            DexType[] newInterfaces = Arrays.copyOf(clazz.interfaces.values, clazz.interfaces.size() + 1);
            newInterfaces[newInterfaces.length - 1] = BackportedMethodRewriter.dispatchInterfaceTypeFor(this.appView, dexMethod);
            clazz.interfaces = new DexTypeList(newInterfaces);
            DexEncodedMethod dexEncodedMethod = clazz.lookupVirtualMethod(dexMethod);
            if (dexEncodedMethod != null) continue;
            DexEncodedMethod newMethod = this.createForwardingMethod(dexMethod, clazz);
            clazz.addVirtualMethod(newMethod);
            newForwardingMethods.add(newMethod);
        }
        return newForwardingMethods;
    }

    private DexEncodedMethod createForwardingMethod(DexMethod target, DexClass clazz) {
        DexMethod forwardMethod = this.appView.options().desugaredLibraryConfiguration.retargetMethod(target, this.appView);
        assert (forwardMethod != null && forwardMethod != target);
        return DexEncodedMethod.createDesugaringForwardingMethod(this.appView.definitionFor(target), clazz, forwardMethod, this.appView.dexItemFactory());
    }

    private void synthesizeEmulatedDispatchMethods(DexApplication.Builder<?> builder) {
        assert (this.appView.options().isDesugaredLibraryCompilation());
        if (this.rewritableMethods.getEmulatedDispatchMethods().isEmpty()) {
            return;
        }
        ClassAccessFlags itfAccessFlags = ClassAccessFlags.fromSharedAccessFlags(5633);
        ClassAccessFlags holderAccessFlags = ClassAccessFlags.fromSharedAccessFlags(4097);
        for (DexMethod emulatedDispatchMethod : this.rewritableMethods.getEmulatedDispatchMethods()) {
            DexType interfaceType = BackportedMethodRewriter.dispatchInterfaceTypeFor(this.appView, emulatedDispatchMethod);
            DexEncodedMethod itfMethod = this.generateInterfaceDispatchMethod(emulatedDispatchMethod, interfaceType);
            this.synthesizeClassWithUniqueMethod(builder, itfAccessFlags, interfaceType, itfMethod, "desugared library dispatch interface", false);
            DexType holderType = BackportedMethodRewriter.dispatchHolderTypeFor(this.appView, emulatedDispatchMethod);
            DexEncodedMethod dispatchMethod = this.generateHolderDispatchMethod(emulatedDispatchMethod, holderType, itfMethod.method);
            this.synthesizeClassWithUniqueMethod(builder, holderAccessFlags, holderType, dispatchMethod, "desugared library dispatch class", false);
        }
    }

    private DexProgramClass synthesizeClassWithUniqueMethod(DexApplication.Builder<?> builder, ClassAccessFlags accessFlags, DexType type, DexEncodedMethod uniqueMethod, String origin, boolean addToMainDexList) {
        DexEncodedMethod[] dexEncodedMethodArray;
        DexEncodedMethod[] dexEncodedMethodArray2;
        SynthesizedOrigin synthesizedOrigin = new SynthesizedOrigin(origin, this.getClass());
        DexType dexType = this.factory.objectType;
        DexTypeList dexTypeList = DexTypeList.empty();
        List<NestMemberClassAttribute> list = Collections.emptyList();
        List<InnerClassAttribute> list2 = Collections.emptyList();
        DexAnnotationSet dexAnnotationSet = DexAnnotationSet.empty();
        if (uniqueMethod.isStatic()) {
            DexEncodedMethod[] dexEncodedMethodArray3 = new DexEncodedMethod[1];
            dexEncodedMethodArray2 = dexEncodedMethodArray3;
            dexEncodedMethodArray3[0] = uniqueMethod;
        } else {
            dexEncodedMethodArray2 = DexEncodedMethod.EMPTY_ARRAY;
        }
        if (uniqueMethod.isStatic()) {
            dexEncodedMethodArray = DexEncodedMethod.EMPTY_ARRAY;
        } else {
            DexEncodedMethod[] dexEncodedMethodArray4 = new DexEncodedMethod[1];
            dexEncodedMethodArray = dexEncodedMethodArray4;
            dexEncodedMethodArray4[0] = uniqueMethod;
        }
        DexProgramClass newClass = new DexProgramClass(type, null, synthesizedOrigin, accessFlags, dexType, dexTypeList, null, null, list, null, list2, dexAnnotationSet, DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, dexEncodedMethodArray2, dexEncodedMethodArray, this.factory.getSkipNameValidationForTesting(), this.getChecksumSupplier(uniqueMethod));
        ((AppInfo)this.appView.appInfo()).addSynthesizedClass(newClass);
        builder.addSynthesizedClass(newClass, addToMainDexList);
        return newClass;
    }

    private DexEncodedMethod generateInterfaceDispatchMethod(DexMethod emulatedDispatchMethod, DexType interfaceType) {
        MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(5121, false);
        DexMethod newMethod = this.factory.createMethod(interfaceType, emulatedDispatchMethod.proto, emulatedDispatchMethod.name);
        return new DexEncodedMethod(newMethod, flags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), null, true);
    }

    private DexEncodedMethod generateHolderDispatchMethod(DexMethod emulatedDispatchMethod, DexType dispatchHolder, DexMethod itfMethod) {
        DexMethod desugarMethod = this.appView.options().desugaredLibraryConfiguration.retargetMethod(emulatedDispatchMethod, this.appView);
        assert (desugarMethod != null);
        DexMethod newMethod = this.appView.dexItemFactory().createMethod(dispatchHolder, desugarMethod.proto, emulatedDispatchMethod.name);
        return DexEncodedMethod.toEmulateDispatchLibraryMethod(emulatedDispatchMethod.holder, newMethod, desugarMethod, itfMethod, Collections.emptyList(), this.appView);
    }

    private DexProgramClass.ChecksumSupplier getChecksumSupplier(DexEncodedMethod method) {
        if (!this.appView.options().encodeChecksums) {
            return DexProgramClass::invalidChecksumRequest;
        }
        return c -> method.method.hashCode();
    }

    public static DexType dispatchInterfaceTypeFor(AppView<?> appView, DexMethod method) {
        return BackportedMethodRewriter.dispatchTypeFor(appView, method, "dispatchInterface");
    }

    static DexType dispatchHolderTypeFor(AppView<?> appView, DexMethod method) {
        return BackportedMethodRewriter.dispatchTypeFor(appView, method, "dispatchHolder");
    }

    private static DexType dispatchTypeFor(AppView<?> appView, DexMethod method, String suffix) {
        String desugaredLibPrefix = appView.options().desugaredLibraryConfiguration.getSynthesizedLibraryClassesPackagePrefix();
        String descriptor = "L" + desugaredLibPrefix + UTILITY_CLASS_NAME_PREFIX + '$' + method.holder.getName() + '$' + method.name + '$' + suffix + ';';
        return appView.dexItemFactory().createType(descriptor);
    }

    private MethodProvider getMethodProviderOrNull(DexMethod method) {
        DexMethod original = this.appView.graphLense().getOriginalMethodSignature(method);
        assert (original != null);
        Map<DexType, DexType> backportCoreLibraryMembers = this.appView.options().desugaredLibraryConfiguration.getBackportCoreLibraryMember();
        if (backportCoreLibraryMembers.containsKey(original.holder)) {
            DexType newHolder = backportCoreLibraryMembers.get(original.holder);
            DexMethod newMethod = this.appView.dexItemFactory().createMethod(newHolder, original.proto, original.name);
            MethodProvider provider = this.rewritableMethods.getProvider(newMethod);
            if (provider != null) {
                return provider;
            }
            RetargetCoreLibraryMethodProvider extraProvider = new RetargetCoreLibraryMethodProvider(newHolder, original, true);
            return extraProvider;
        }
        return this.rewritableMethods.getProvider(original);
    }

    private static interface MethodInvokeRewriter {
        public void rewrite(InvokeMethod var1, InstructionListIterator var2, DexItemFactory var3);
    }

    private static interface TemplateMethodFactory {
        public Code create(InternalOptions var1, DexMethod var2);
    }

    private static class StatifyingMethodGenerator
    extends MethodGenerator {
        private final DexType receiverType;

        StatifyingMethodGenerator(DexMethod method, TemplateMethodFactory factory, String methodName, DexType receiverType) {
            super(method, factory, methodName);
            this.receiverType = receiverType;
        }

        @Override
        public DexMethod provideMethod(AppView<?> appView) {
            if (this.generatedMethod != null) {
                return this.generatedMethod;
            }
            super.provideMethod(appView);
            assert (this.generatedMethod != null);
            DexProto newProto = appView.dexItemFactory().prependTypeToProto(this.receiverType, this.method.proto);
            this.generatedMethod = appView.dexItemFactory().createMethod(this.generatedMethod.holder, newProto, this.method.name);
            return this.generatedMethod;
        }
    }

    private static class MethodGenerator
    extends MethodProvider {
        private final TemplateMethodFactory factory;
        private final String methodName;
        DexMethod generatedMethod;

        MethodGenerator(DexMethod method, TemplateMethodFactory factory) {
            this(method, factory, method.name.toString());
        }

        MethodGenerator(DexMethod method, TemplateMethodFactory factory, String methodName) {
            super(method);
            this.factory = factory;
            this.methodName = methodName;
        }

        @Override
        public void rewriteInvoke(InvokeMethod invoke, InstructionListIterator iterator2, IRCode code, AppView<?> appView) {
            iterator2.replaceCurrentInstruction(new InvokeStatic(this.provideMethod(appView), invoke.outValue(), invoke.inValues()));
        }

        @Override
        public DexMethod provideMethod(AppView<?> appView) {
            if (this.generatedMethod != null) {
                return this.generatedMethod;
            }
            DexItemFactory factory = appView.dexItemFactory();
            String unqualifiedName = this.method.holder.getName();
            String desugaredLibPrefix = appView.options().desugaredLibraryConfiguration.getSynthesizedLibraryClassesPackagePrefix(appView);
            String descriptor = "L" + desugaredLibPrefix + BackportedMethodRewriter.UTILITY_CLASS_NAME_PREFIX + '$' + unqualifiedName + '$' + this.method.proto.parameters.size() + '$' + this.methodName + ';';
            DexType type = factory.createType(descriptor);
            this.generatedMethod = factory.createMethod(type, this.method.proto, this.method.name);
            return this.generatedMethod;
        }

        @Override
        public Code generateTemplateMethod(InternalOptions options, DexMethod method) {
            return this.factory.create(options, method);
        }

        @Override
        public boolean requiresGenerationOfCode() {
            return true;
        }
    }

    private static final class InvokeRewriter
    extends MethodProvider {
        private final MethodInvokeRewriter rewriter;

        InvokeRewriter(DexMethod method, MethodInvokeRewriter rewriter) {
            super(method);
            this.rewriter = rewriter;
        }

        @Override
        public void rewriteInvoke(InvokeMethod invoke, InstructionListIterator iterator2, IRCode code, AppView<?> appView) {
            this.rewriter.rewrite(invoke, iterator2, appView.dexItemFactory());
            assert (code.isConsistentSSA());
        }

        @Override
        public boolean requiresGenerationOfCode() {
            return false;
        }

        @Override
        public DexMethod provideMethod(AppView<?> appView) {
            throw new Unreachable();
        }

        @Override
        public Code generateTemplateMethod(InternalOptions options, DexMethod method) {
            throw new Unreachable();
        }
    }

    private static class RetargetCoreLibraryMethodProvider
    extends MethodProvider {
        private final DexType newHolder;
        private DexMethod targetMethod;
        private boolean isStatic;

        RetargetCoreLibraryMethodProvider(DexType newHolder, DexMethod method, boolean isStatic) {
            super(method);
            this.newHolder = newHolder;
            this.isStatic = isStatic;
        }

        @Override
        public void rewriteInvoke(InvokeMethod invoke, InstructionListIterator iterator2, IRCode code, AppView<?> appView) {
            iterator2.replaceCurrentInstruction(new InvokeStatic(this.provideMethod(appView), invoke.outValue(), invoke.inValues()));
        }

        @Override
        public DexMethod provideMethod(AppView<?> appView) {
            if (this.targetMethod != null) {
                return this.targetMethod;
            }
            DexItemFactory factory = appView.dexItemFactory();
            DexProto newProto = this.isStatic ? this.method.proto : factory.prependTypeToProto(this.method.holder, this.method.proto);
            this.targetMethod = factory.createMethod(this.newHolder, newProto, this.method.name);
            return this.targetMethod;
        }

        @Override
        public Code generateTemplateMethod(InternalOptions options, DexMethod method) {
            throw new Unreachable("Does not generate any method.");
        }

        @Override
        public boolean requiresGenerationOfCode() {
            return false;
        }
    }

    public static abstract class MethodProvider {
        final DexMethod method;

        public MethodProvider(DexMethod method) {
            this.method = method;
        }

        public abstract void rewriteInvoke(InvokeMethod var1, InstructionListIterator var2, IRCode var3, AppView<?> var4);

        public abstract DexMethod provideMethod(AppView<?> var1);

        public abstract Code generateTemplateMethod(InternalOptions var1, DexMethod var2);

        public abstract boolean requiresGenerationOfCode();
    }

    private static final class RewritableMethods {
        private final Map<DexMethod, MethodProvider> rewritable = new IdentityHashMap<DexMethod, MethodProvider>();
        private final Map<DexString, List<DexMethod>> virtualRewrites = new IdentityHashMap<DexString, List<DexMethod>>();
        private final Set<DexMethod> emulatedDispatchMethods = Sets.newHashSet();

        RewritableMethods(InternalOptions options, AppView<?> appView) {
            DexItemFactory factory = options.itemFactory;
            if (options.minApiLevel < AndroidApiLevel.K.getLevel()) {
                this.initializeAndroidKMethodProviders(factory);
            }
            if (options.minApiLevel < AndroidApiLevel.N.getLevel()) {
                this.initializeAndroidNMethodProviders(factory);
            }
            if (options.minApiLevel < AndroidApiLevel.O.getLevel()) {
                this.initializeAndroidOMethodProviders(factory);
            }
            if (appView.rewritePrefix.hasRewrittenType(factory.optionalType) || options.minApiLevel >= AndroidApiLevel.N.getLevel()) {
                this.initializeJava9OptionalMethodProviders(factory);
                this.initializeJava10OptionalMethodProviders(factory);
                this.initializeJava11OptionalMethodProviders(factory);
            }
            if (appView.rewritePrefix.hasRewrittenType(factory.streamType) || options.minApiLevel >= AndroidApiLevel.N.getLevel()) {
                this.initializeStreamMethodProviders(factory);
            }
            this.initializeJava9MethodProviders(factory);
            this.initializeJava10MethodProviders(factory);
            this.initializeJava11MethodProviders(factory);
            if (!options.desugaredLibraryConfiguration.getRetargetCoreLibMember().isEmpty()) {
                this.initializeRetargetCoreLibraryMembers(appView);
            }
        }

        boolean matchesVirtualRewrite(DexMethod method) {
            List<DexMethod> dexMethods = this.virtualRewrites.get(method.name);
            if (dexMethods == null) {
                return false;
            }
            for (DexMethod dexMethod : dexMethods) {
                if (!method.match(dexMethod)) continue;
                return true;
            }
            return false;
        }

        public Set<DexMethod> getEmulatedDispatchMethods() {
            return this.emulatedDispatchMethods;
        }

        boolean isEmpty() {
            return this.rewritable.isEmpty();
        }

        public void visit(Consumer<DexMethod> consumer) {
            this.rewritable.keySet().forEach(consumer);
        }

        private void initializeAndroidKMethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("compare");
            DexProto proto = factory.createProto(factory.intType, factory.byteType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_compare));
            type = factory.boxedShortType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.shortType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_compare));
            type = factory.boxedIntType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_compare));
            type = factory.boxedLongType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, LongMethodRewrites::rewriteCompare));
            type = factory.boxedBooleanType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::BooleanMethods_compare));
            type = factory.boxedCharType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.charType, factory.charType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CharacterMethods_compare));
            type = factory.objectsType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.objectType, factory.objectType, factory.comparatorType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_compare));
            name = factory.createString("deepEquals");
            proto = factory.createProto(factory.booleanType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_deepEquals));
            name = factory.createString("equals");
            proto = factory.createProto(factory.booleanType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_equals));
            name = factory.createString("hash");
            proto = factory.createProto(factory.intType, factory.objectArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, ObjectsMethodRewrites::rewriteToArraysHashCode));
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_hashCode));
            method = factory.objectsMethods.requireNonNull;
            this.addProvider(new InvokeRewriter(method, ObjectsMethodRewrites::rewriteRequireNonNull));
            name = factory.createString("requireNonNull");
            proto = factory.createProto(factory.objectType, factory.objectType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_requireNonNullMessage, "requireNonNullMessage"));
            name = factory.createString("toString");
            proto = factory.createProto(factory.stringType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_toString));
            name = factory.createString("toString");
            proto = factory.createProto(factory.stringType, factory.objectType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_toStringDefault, "toStringDefault"));
            type = factory.collectionsType;
            name = factory.createString("emptyEnumeration");
            proto = factory.createProto(factory.enumerationType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_emptyEnumeration));
            name = factory.createString("emptyIterator");
            proto = factory.createProto(factory.iteratorType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_emptyIterator));
            name = factory.createString("emptyListIterator");
            proto = factory.createProto(factory.listIteratorType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_emptyListIterator));
        }

        private void initializeAndroidNMethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("hashCode");
            DexProto proto = factory.createProto(factory.intType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteAsIdentity));
            type = factory.boxedShortType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteAsIdentity));
            type = factory.boxedIntType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteAsIdentity));
            name = factory.createString("max");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("min");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("sum");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToAddInstruction));
            type = factory.boxedDoubleType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::DoubleMethods_hashCode));
            name = factory.createString("max");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("min");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("sum");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToAddInstruction));
            name = factory.createString("isFinite");
            proto = factory.createProto(factory.booleanType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::DoubleMethods_isFinite));
            type = factory.boxedFloatType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, FloatMethodRewrites::rewriteHashCode));
            name = factory.createString("max");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("min");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("sum");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToAddInstruction));
            name = factory.createString("isFinite");
            proto = factory.createProto(factory.booleanType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::FloatMethods_isFinite));
            type = factory.boxedBooleanType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::BooleanMethods_hashCode));
            name = factory.createString("logicalAnd");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, BooleanMethodRewrites::rewriteLogicalAnd));
            name = factory.createString("logicalOr");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, BooleanMethodRewrites::rewriteLogicalOr));
            name = factory.createString("logicalXor");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, BooleanMethodRewrites::rewriteLogicalXor));
            type = factory.boxedLongType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_hashCode));
            name = factory.createString("max");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("min");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToInvokeMath));
            name = factory.createString("sum");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteToAddInstruction));
            type = factory.boxedCharType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.charType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites::rewriteAsIdentity));
            type = factory.objectsType;
            name = factory.createString("isNull");
            proto = factory.createProto(factory.booleanType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_isNull));
            name = factory.createString("nonNull");
            proto = factory.createProto(factory.booleanType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_nonNull));
            DexType[] mathTypes = new DexType[]{factory.mathType, factory.strictMathType};
            for (int i = 0; i < mathTypes.length; ++i) {
                type = mathTypes[i];
                name = factory.createString("addExact");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_addExactInt, "addExactInt"));
                name = factory.createString("addExact");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_addExactLong, "addExactLong"));
                name = factory.createString("floorDiv");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorDivInt, "floorDivInt"));
                name = factory.createString("floorDiv");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorDivLong, "floorDivLong"));
                name = factory.createString("floorMod");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorModInt, "floorModInt"));
                name = factory.createString("floorMod");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorModLong, "floorModLong"));
                name = factory.createString("multiplyExact");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyExactInt, "multiplyExactInt"));
                name = factory.createString("multiplyExact");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyExactLong, "multiplyExactLong"));
                name = factory.createString("nextDown");
                proto = factory.createProto(factory.doubleType, factory.doubleType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_nextDownDouble, "nextDownDouble"));
                name = factory.createString("nextDown");
                proto = factory.createProto(factory.floatType, factory.floatType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_nextDownFloat, "nextDownFloat"));
                name = factory.createString("subtractExact");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_subtractExactInt, "subtractExactInt"));
                name = factory.createString("subtractExact");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_subtractExactLong, "subtractExactLong"));
                name = factory.createString("toIntExact");
                proto = factory.createProto(factory.intType, factory.longType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_toIntExact));
            }
            type = factory.mathType;
            name = factory.createString("decrementExact");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_decrementExactInt, "decrementExactInt"));
            name = factory.createString("decrementExact");
            proto = factory.createProto(factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_decrementExactLong, "decrementExactLong"));
            name = factory.createString("incrementExact");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_incrementExactInt, "incrementExactInt"));
            name = factory.createString("incrementExact");
            proto = factory.createProto(factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_incrementExactLong, "incrementExactLong"));
            name = factory.createString("negateExact");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_negateExactInt, "negateExactInt"));
            name = factory.createString("negateExact");
            proto = factory.createProto(factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_negateExactLong, "negateExactLong"));
        }

        private void initializeAndroidOMethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("toUnsignedInt");
            DexProto proto = factory.createProto(factory.intType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_toUnsignedInt));
            name = factory.createString("toUnsignedLong");
            proto = factory.createProto(factory.longType, factory.byteType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_toUnsignedLong));
            type = factory.boxedShortType;
            name = factory.createString("toUnsignedInt");
            proto = factory.createProto(factory.intType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_toUnsignedInt));
            name = factory.createString("toUnsignedLong");
            proto = factory.createProto(factory.longType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_toUnsignedLong));
            type = factory.boxedIntType;
            name = factory.createString("divideUnsigned");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_divideUnsigned));
            name = factory.createString("remainderUnsigned");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_remainderUnsigned));
            name = factory.createString("compareUnsigned");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_compareUnsigned));
            name = factory.createString("toUnsignedLong");
            proto = factory.createProto(factory.longType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_toUnsignedLong));
            name = factory.createString("parseUnsignedInt");
            proto = factory.createProto(factory.intType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_parseUnsignedInt));
            name = factory.createString("parseUnsignedInt");
            proto = factory.createProto(factory.intType, factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_parseUnsignedIntWithRadix, "parseUnsignedIntWithRadix"));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_toUnsignedString));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_toUnsignedStringWithRadix, "toUnsignedStringWithRadix"));
            type = factory.boxedLongType;
            name = factory.createString("divideUnsigned");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_divideUnsigned));
            name = factory.createString("remainderUnsigned");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_remainderUnsigned));
            name = factory.createString("compareUnsigned");
            proto = factory.createProto(factory.intType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_compareUnsigned));
            name = factory.createString("parseUnsignedLong");
            proto = factory.createProto(factory.longType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_parseUnsignedLong));
            name = factory.createString("parseUnsignedLong");
            proto = factory.createProto(factory.longType, factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_parseUnsignedLongWithRadix, "parseUnsignedLongWithRadix"));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_toUnsignedString));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.longType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_toUnsignedStringWithRadix, "toUnsignedStringWithRadix"));
            type = factory.stringType;
            name = factory.createString("join");
            proto = factory.createProto(factory.stringType, factory.charSequenceType, factory.charSequenceArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::StringMethods_joinArray, "joinArray"));
            name = factory.createString("join");
            proto = factory.createProto(factory.stringType, factory.charSequenceType, factory.iterableType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::StringMethods_joinIterable, "joinIterable"));
        }

        private void initializeJava9MethodProviders(DexItemFactory factory) {
            int formalCount;
            int i;
            DexType[] mathTypes = new DexType[]{factory.mathType, factory.strictMathType};
            for (int i2 = 0; i2 < mathTypes.length; ++i2) {
                DexType type = mathTypes[i2];
                DexString name = factory.createString("multiplyExact");
                DexProto proto = factory.createProto(factory.longType, factory.longType, factory.intType);
                DexMethod method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyExactLongInt, "multiplyExactLongInt"));
                name = factory.createString("multiplyFull");
                proto = factory.createProto(factory.longType, factory.intType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyFull));
                name = factory.createString("multiplyHigh");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyHigh));
                name = factory.createString("floorDiv");
                proto = factory.createProto(factory.longType, factory.longType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorDivLongInt, "floorDivLongInt"));
                name = factory.createString("floorMod");
                proto = factory.createProto(factory.intType, factory.longType, factory.intType);
                method = factory.createMethod(type, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorModLongInt, "floorModLongInt"));
            }
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("compareUnsigned");
            DexProto proto = factory.createProto(factory.intType, factory.byteType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_compareUnsigned));
            type = factory.boxedShortType;
            name = factory.createString("compareUnsigned");
            proto = factory.createProto(factory.intType, factory.shortType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_compareUnsigned));
            type = factory.objectsType;
            name = factory.createString("requireNonNullElse");
            proto = factory.createProto(factory.objectType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_requireNonNullElse));
            name = factory.createString("requireNonNullElseGet");
            proto = factory.createProto(factory.objectType, factory.objectType, factory.supplierType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_requireNonNullElseGet));
            name = factory.createString("checkIndex");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_checkIndex));
            name = factory.createString("checkFromToIndex");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_checkFromToIndex));
            name = factory.createString("checkFromIndexSize");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_checkFromIndexSize));
            type = factory.listType;
            name = factory.createString("of");
            for (i = 0; i <= 10; ++i) {
                formalCount = i;
                proto = factory.createProto(type, Collections.nCopies(i, factory.objectType));
                method = factory.createMethod(type, proto, name);
                this.addProvider(i == 0 ? new InvokeRewriter(method, CollectionMethodRewrites::rewriteListOfEmpty) : new MethodGenerator(method, (options, methodArg) -> CollectionMethodGenerators.generateListOf(options, methodArg, formalCount)));
            }
            proto = factory.createProto(type, factory.objectArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_listOfArray, "ofArray"));
            type = factory.setType;
            name = factory.createString("of");
            for (i = 0; i <= 10; ++i) {
                formalCount = i;
                proto = factory.createProto(type, Collections.nCopies(i, factory.objectType));
                method = factory.createMethod(type, proto, name);
                this.addProvider(i == 0 ? new InvokeRewriter(method, CollectionMethodRewrites::rewriteSetOfEmpty) : new MethodGenerator(method, (options, methodArg) -> CollectionMethodGenerators.generateSetOf(options, methodArg, formalCount)));
            }
            proto = factory.createProto(type, factory.objectArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_setOfArray, "ofArray"));
            type = factory.mapType;
            name = factory.createString("of");
            for (i = 0; i <= 10; ++i) {
                formalCount = i;
                proto = factory.createProto(type, Collections.nCopies(i * 2, factory.objectType));
                method = factory.createMethod(type, proto, name);
                this.addProvider(i == 0 ? new InvokeRewriter(method, CollectionMethodRewrites::rewriteMapOfEmpty) : new MethodGenerator(method, (options, methodArg) -> CollectionMethodGenerators.generateMapOf(options, methodArg, formalCount)));
            }
            proto = factory.createProto(type, factory.createArrayType(1, factory.mapEntryType));
            method = factory.createMethod(type, proto, "ofEntries");
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_mapOfEntries, "ofEntries"));
            type = factory.mapType;
            proto = factory.createProto(factory.mapEntryType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, "entry");
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_mapEntry));
        }

        private void initializeJava10MethodProviders(DexItemFactory factory) {
            DexType type = factory.listType;
            DexString name = factory.createString("copyOf");
            DexProto proto = factory.createProto(factory.listType, factory.collectionType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_copyOfList, "copyOfList"));
            type = factory.setType;
            name = factory.createString("copyOf");
            proto = factory.createProto(factory.setType, factory.collectionType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_copyOfSet, "copyOfSet"));
            type = factory.mapType;
            name = factory.createString("copyOf");
            proto = factory.createProto(factory.mapType, factory.mapType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_copyOfMap, "copyOfMap"));
        }

        private void initializeJava11MethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedCharType;
            DexString name = factory.createString("toString");
            DexProto proto = factory.createProto(factory.stringType, factory.intType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CharacterMethods_toStringCodepoint, "toStringCodepoint"));
            type = factory.stringType;
            name = factory.createString("repeat");
            proto = factory.createProto(factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_repeat, "repeat", type));
            name = factory.createString("isBlank");
            proto = factory.createProto(factory.booleanType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_isBlank, "isBlank", type));
            name = factory.createString("strip");
            proto = factory.createProto(factory.stringType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_strip, "strip", type));
            name = factory.createString("stripLeading");
            proto = factory.createProto(factory.stringType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_stripLeading, "stripLeading", type));
            name = factory.createString("stripTrailing");
            proto = factory.createProto(factory.stringType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_stripTrailing, "stripTrailing", type));
        }

        private void initializeJava9OptionalMethodProviders(DexItemFactory factory) {
            DexType optionalType = factory.optionalType;
            DexString name = factory.createString("or");
            DexProto proto = factory.createProto(optionalType, factory.supplierType);
            DexMethod method = factory.createMethod(optionalType, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::OptionalMethods_or, "or", optionalType));
            DexType[] optionalTypes = new DexType[]{optionalType, factory.optionalDoubleType, factory.optionalLongType, factory.optionalIntType};
            DexType[] streamReturnTypes = new DexType[]{factory.streamType, factory.createType(factory.createString("Ljava/util/stream/DoubleStream;")), factory.createType(factory.createString("Ljava/util/stream/LongStream;")), factory.createType(factory.createString("Ljava/util/stream/IntStream;"))};
            TemplateMethodFactory[] streamMethodFactories = new TemplateMethodFactory[]{BackportedMethods::OptionalMethods_stream, BackportedMethods::OptionalMethods_streamDouble, BackportedMethods::OptionalMethods_streamLong, BackportedMethods::OptionalMethods_streamInt};
            name = factory.createString("stream");
            for (int i = 0; i < optionalTypes.length; ++i) {
                DexType optional = optionalTypes[i];
                DexType streamReturnType = streamReturnTypes[i];
                proto = factory.createProto(streamReturnType, new DexType[0]);
                method = factory.createMethod(optional, proto, name);
                this.addProvider(new StatifyingMethodGenerator(method, streamMethodFactories[i], "stream", optional));
            }
            DexType[] consumerTypes = new DexType[]{factory.consumerType, factory.createType("Ljava/util/function/DoubleConsumer;"), factory.createType("Ljava/util/function/LongConsumer;"), factory.createType("Ljava/util/function/IntConsumer;")};
            TemplateMethodFactory[] methodFactories = new TemplateMethodFactory[]{BackportedMethods::OptionalMethods_ifPresentOrElse, BackportedMethods::OptionalMethods_ifPresentOrElseDouble, BackportedMethods::OptionalMethods_ifPresentOrElseLong, BackportedMethods::OptionalMethods_ifPresentOrElseInt};
            for (int i = 0; i < optionalTypes.length; ++i) {
                DexType optional = optionalTypes[i];
                DexType consumer = consumerTypes[i];
                name = factory.createString("ifPresentOrElse");
                proto = factory.createProto(factory.voidType, consumer, factory.runnableType);
                method = factory.createMethod(optional, proto, name);
                this.addProvider(new StatifyingMethodGenerator(method, methodFactories[i], "ifPresentOrElse", optional));
            }
        }

        private void initializeJava10OptionalMethodProviders(DexItemFactory factory) {
            DexType[] optionalTypes = new DexType[]{factory.optionalType, factory.optionalDoubleType, factory.optionalLongType, factory.optionalIntType};
            DexType[] returnTypes = new DexType[]{factory.objectType, factory.doubleType, factory.longType, factory.intType};
            MethodInvokeRewriter[] rewriters = new MethodInvokeRewriter[]{OptionalMethodRewrites::rewriteOrElseGet, OptionalMethodRewrites::rewriteDoubleOrElseGet, OptionalMethodRewrites::rewriteLongOrElseGet, OptionalMethodRewrites::rewriteIntOrElseGet};
            DexString name = factory.createString("orElseThrow");
            for (int i = 0; i < optionalTypes.length; ++i) {
                DexProto proto = factory.createProto(returnTypes[i], new DexType[0]);
                DexMethod method = factory.createMethod(optionalTypes[i], proto, name);
                this.addProvider(new InvokeRewriter(method, rewriters[i]));
            }
        }

        private void initializeJava11OptionalMethodProviders(DexItemFactory factory) {
            DexType[] optionalTypes = new DexType[]{factory.optionalType, factory.optionalDoubleType, factory.optionalLongType, factory.optionalIntType};
            TemplateMethodFactory[] methodFactories = new TemplateMethodFactory[]{BackportedMethods::OptionalMethods_isEmpty, BackportedMethods::OptionalMethods_isEmptyDouble, BackportedMethods::OptionalMethods_isEmptyLong, BackportedMethods::OptionalMethods_isEmptyInt};
            DexString name = factory.createString("isEmpty");
            for (int i = 0; i < optionalTypes.length; ++i) {
                DexType optionalType = optionalTypes[i];
                DexProto proto = factory.createProto(factory.booleanType, new DexType[0]);
                DexMethod method = factory.createMethod(optionalType, proto, name);
                this.addProvider(new StatifyingMethodGenerator(method, methodFactories[i], "isEmpty", optionalType));
            }
        }

        private void initializeStreamMethodProviders(DexItemFactory factory) {
            DexType streamType = factory.streamType;
            DexString name = factory.createString("ofNullable");
            DexProto proto = factory.createProto(factory.streamType, factory.objectType);
            DexMethod method = factory.createMethod(streamType, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::StreamMethods_ofNullable, "ofNullable"));
        }

        private void warnMissingRetargetCoreLibraryMember(DexType type, AppView<?> appView) {
            StringDiagnostic warning = new StringDiagnostic("Cannot retarget core library member " + type.getName() + " because the class is missing.");
            appView.options().reporter.warning(warning);
        }

        private void initializeRetargetCoreLibraryMembers(AppView<?> appView) {
            Map<DexString, Map<DexType, DexType>> retargetCoreLibMember = appView.options().desugaredLibraryConfiguration.getRetargetCoreLibMember();
            for (DexString methodName : retargetCoreLibMember.keySet()) {
                for (DexType inType : retargetCoreLibMember.get(methodName).keySet()) {
                    DexClass typeClass = appView.definitionFor(inType);
                    if (typeClass == null) {
                        this.warnMissingRetargetCoreLibraryMember(inType, appView);
                        continue;
                    }
                    DexType newHolder = retargetCoreLibMember.get(methodName).get(inType);
                    List<DexEncodedMethod> found = this.findDexEncodedMethodsWithName(methodName, typeClass);
                    for (DexEncodedMethod encodedMethod : found) {
                        if (!encodedMethod.isStatic()) {
                            this.virtualRewrites.putIfAbsent(encodedMethod.method.name, new ArrayList());
                            this.virtualRewrites.get(encodedMethod.method.name).add(encodedMethod.method);
                            if (InterfaceMethodRewriter.isEmulatedInterfaceDispatch(appView, encodedMethod)) continue;
                            if (!encodedMethod.isFinal()) {
                                this.handleEmulateDispatch(appView, encodedMethod.method);
                                newHolder = BackportedMethodRewriter.dispatchHolderTypeFor(appView, encodedMethod.method);
                            }
                        }
                        DexProto proto = encodedMethod.method.proto;
                        DexMethod method = appView.dexItemFactory().createMethod(inType, proto, methodName);
                        this.addProvider(new RetargetCoreLibraryMethodProvider(newHolder, method, encodedMethod.isStatic()));
                    }
                }
            }
        }

        private List<DexEncodedMethod> findDexEncodedMethodsWithName(DexString methodName, DexClass clazz) {
            ArrayList<DexEncodedMethod> found = new ArrayList<DexEncodedMethod>();
            for (DexEncodedMethod encodedMethod : clazz.methods()) {
                if (encodedMethod.method.name != methodName) continue;
                found.add(encodedMethod);
            }
            assert (found.size() > 0) : "Should have found a method (library specifications).";
            return found;
        }

        private void handleEmulateDispatch(AppView<?> appView, DexMethod method) {
            this.emulatedDispatchMethods.add(method);
            if (!appView.options().isDesugaredLibraryCompilation()) {
                DexType dispatchInterfaceType = BackportedMethodRewriter.dispatchInterfaceTypeFor(appView, method);
                appView.rewritePrefix.rewriteType(dispatchInterfaceType, dispatchInterfaceType);
                DexType dispatchHolderType = BackportedMethodRewriter.dispatchHolderTypeFor(appView, method);
                appView.rewritePrefix.rewriteType(dispatchHolderType, dispatchHolderType);
            }
        }

        private void addProvider(MethodProvider generator) {
            MethodProvider replaced = this.rewritable.put(generator.method, generator);
            assert (replaced == null);
        }

        MethodProvider getProvider(DexMethod method) {
            return this.rewritable.get(method);
        }
    }
}

