/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryWrapperSynthesizer;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.DesugaredLibraryAPIConversionCfCodeProvider;
import shadow.bundletool.com.android.tools.r8.utils.BooleanUtils;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class DesugaredLibraryAPIConverter {
    static final String VIVIFIED_PREFIX = "$-vivified-$.";
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final DesugaredLibraryWrapperSynthesizer wrapperSynthesizor;
    private final Map<DexClass, Set<DexEncodedMethod>> callBackMethods = new HashMap<DexClass, Set<DexEncodedMethod>>();
    private final Set<DexMethod> trackedCallBackAPIs;
    private final Set<DexMethod> trackedAPIs;

    public DesugaredLibraryAPIConverter(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.wrapperSynthesizor = new DesugaredLibraryWrapperSynthesizer(appView, this);
        if (appView.options().testing.trackDesugaredAPIConversions) {
            this.trackedCallBackAPIs = Sets.newConcurrentHashSet();
            this.trackedAPIs = Sets.newConcurrentHashSet();
        } else {
            this.trackedCallBackAPIs = null;
            this.trackedAPIs = null;
        }
    }

    public void desugar(IRCode code) {
        if (this.wrapperSynthesizor.hasSynthesized(code.method.method.holder)) {
            return;
        }
        this.generateCallBackIfNeeded(code);
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                DexClass dexClass;
                Instruction instruction = (Instruction)iterator2.next();
                if (!instruction.isInvokeMethod()) continue;
                InvokeMethod invokeMethod = instruction.asInvokeMethod();
                DexMethod invokedMethod = invokeMethod.getInvokedMethod();
                if (this.appView.rewritePrefix.hasRewrittenType(invokedMethod.holder) || invokedMethod.holder.isArrayType() || (dexClass = this.appView.definitionFor(invokedMethod.holder)) == null || !dexClass.isLibraryClass() || !this.appView.rewritePrefix.hasRewrittenTypeInSignature(invokedMethod.proto)) continue;
                this.rewriteLibraryInvoke(code, invokeMethod, iterator2, blockIterator);
            }
        }
    }

    private void generateCallBackIfNeeded(IRCode code) {
        if (code.method.isPrivateMethod() || code.method.isStatic()) {
            return;
        }
        DexMethod method = code.method.method;
        if (method.holder.isArrayType() || !this.appView.rewritePrefix.hasRewrittenTypeInSignature(method.proto) || this.appView.options().desugaredLibraryConfiguration.getEmulateLibraryInterface().containsKey(method.holder)) {
            return;
        }
        DexClass dexClass = this.appView.definitionFor(method.holder);
        if (dexClass == null) {
            return;
        }
        if (this.overridesLibraryMethod(dexClass, method)) {
            this.generateCallBack(dexClass, code.method);
        }
    }

    private boolean overridesLibraryMethod(DexClass theClass, DexMethod method) {
        LinkedList<DexType> workList = new LinkedList<DexType>();
        Collections.addAll(workList, theClass.interfaces.values);
        boolean foundOverrideToRewrite = false;
        if (theClass.superType != this.factory.objectType) {
            workList.add(theClass.superType);
        }
        while (!workList.isEmpty()) {
            DexEncodedMethod dexEncodedMethod;
            DexType current = (DexType)workList.removeFirst();
            DexClass dexClass = this.appView.definitionFor(current);
            if (dexClass == null) continue;
            workList.addAll(Arrays.asList(dexClass.interfaces.values));
            if (dexClass.superType != this.factory.objectType) {
                workList.add(dexClass.superType);
            }
            if (!dexClass.isLibraryClass() && !this.appView.options().isDesugaredLibraryCompilation() || (dexEncodedMethod = dexClass.lookupVirtualMethod(method)) == null) continue;
            if (this.appView.rewritePrefix.hasRewrittenType(dexClass.type)) {
                return false;
            }
            foundOverrideToRewrite = true;
        }
        return foundOverrideToRewrite;
    }

    private synchronized void generateCallBack(DexClass dexClass, DexEncodedMethod originalMethod) {
        if (dexClass.isInterface() && originalMethod.isDefaultMethod() && (!this.appView.options().canUseDefaultAndStaticInterfaceMethods() || this.appView.options().isDesugaredLibraryCompilation())) {
            return;
        }
        if (this.trackedCallBackAPIs != null) {
            this.trackedCallBackAPIs.add(originalMethod.method);
        }
        this.addCallBackSignature(dexClass, originalMethod);
    }

    private synchronized void addCallBackSignature(DexClass dexClass, DexEncodedMethod method) {
        assert (dexClass.type == method.method.holder);
        this.callBackMethods.putIfAbsent(dexClass, new HashSet());
        this.callBackMethods.get(dexClass).add(method);
    }

    public static DexMethod methodWithVivifiedTypeInSignature(DexMethod originalMethod, DexType holder, AppView<?> appView) {
        DexType[] newParameters = (DexType[])originalMethod.proto.parameters.values.clone();
        int index = 0;
        for (DexType param : originalMethod.proto.parameters.values) {
            if (appView.rewritePrefix.hasRewrittenType(param)) {
                newParameters[index] = DesugaredLibraryAPIConverter.vivifiedTypeFor(param, appView);
            }
            ++index;
        }
        DexType returnType = originalMethod.proto.returnType;
        DexType newReturnType = appView.rewritePrefix.hasRewrittenType(returnType) ? DesugaredLibraryAPIConverter.vivifiedTypeFor(returnType, appView) : returnType;
        DexProto newProto = appView.dexItemFactory().createProto(newReturnType, newParameters);
        return appView.dexItemFactory().createMethod(holder, newProto, originalMethod.name);
    }

    public void generateWrappers(DexApplication.Builder<?> builder, IRConverter irConverter, ExecutorService executorService) throws ExecutionException {
        if (this.appView.options().testing.trackDesugaredAPIConversions) {
            this.generateTrackDesugaredAPIWarnings(this.trackedAPIs, "");
            this.generateTrackDesugaredAPIWarnings(this.trackedCallBackAPIs, "callback ");
        }
        for (DexClass dexClass : this.callBackMethods.keySet()) {
            Set<DexEncodedMethod> dexEncodedMethods = this.generateCallbackMethods(this.callBackMethods.get(dexClass), dexClass);
            dexClass.appendVirtualMethods(dexEncodedMethods);
            irConverter.processMethodsConcurrently(dexEncodedMethods, executorService);
        }
        this.wrapperSynthesizor.finalizeWrappers(builder, irConverter, executorService);
    }

    private Set<DexEncodedMethod> generateCallbackMethods(Set<DexEncodedMethod> originalMethods, DexClass dexClass) {
        HashSet<DexEncodedMethod> newDexEncodedMethods = new HashSet<DexEncodedMethod>();
        for (DexEncodedMethod originalMethod : originalMethods) {
            DexMethod methodToInstall = DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(originalMethod.method, dexClass.type, this.appView);
            CfCode cfCode = new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterWrapperCfCodeProvider(this.appView, originalMethod.method, null, this, dexClass.isInterface()).generateCfCode();
            DexEncodedMethod newDexEncodedMethod = this.wrapperSynthesizor.newSynthesizedMethod(methodToInstall, originalMethod, cfCode);
            newDexEncodedMethod.setCode(cfCode, this.appView);
            newDexEncodedMethods.add(newDexEncodedMethod);
        }
        return newDexEncodedMethods;
    }

    private void generateTrackDesugaredAPIWarnings(Set<DexMethod> tracked, String inner) {
        StringBuilder sb = new StringBuilder();
        sb.append("Tracked ").append(inner).append("desugared API conversions: ");
        for (DexMethod method : tracked) {
            sb.append("\n");
            sb.append(method);
        }
        this.appView.options().reporter.warning(new StringDiagnostic(sb.toString()));
    }

    private void warnInvalidInvoke(DexType type, DexMethod invokedMethod, String debugString) {
        DexType desugaredType = this.appView.rewritePrefix.rewrittenType(type);
        this.appView.options().reporter.warning(new StringDiagnostic("Invoke to " + invokedMethod.holder + "#" + invokedMethod.name + " may not work correctly at runtime (" + debugString + " type " + desugaredType + " is a desugared type)."));
    }

    public static DexType vivifiedTypeFor(DexType type, AppView<?> appView) {
        DexType vivifiedType = appView.dexItemFactory().createType(DescriptorUtils.javaTypeToDescriptor(VIVIFIED_PREFIX + type.toString()));
        appView.rewritePrefix.rewriteType(vivifiedType, type);
        return vivifiedType;
    }

    private void rewriteLibraryInvoke(IRCode code, InvokeMethod invokeMethod, InstructionListIterator iterator2, ListIterator<BasicBlock> blockIterator) {
        DexType newReturnType;
        DexMethod invokedMethod = invokeMethod.getInvokedMethod();
        if (this.trackedAPIs != null) {
            this.trackedAPIs.add(invokedMethod);
        }
        Instruction returnConversion = null;
        DexType returnType = invokedMethod.proto.returnType;
        if (this.appView.rewritePrefix.hasRewrittenType(returnType)) {
            if (this.canConvert(returnType)) {
                newReturnType = DesugaredLibraryAPIConverter.vivifiedTypeFor(returnType, this.appView);
                if (invokeMethod.outValue() != null && invokeMethod.outValue().numberOfUsers() + invokeMethod.outValue().numberOfPhiUsers() > 0) {
                    returnConversion = this.createReturnConversionAndReplaceUses(code, invokeMethod, returnType, newReturnType);
                }
            } else {
                this.warnInvalidInvoke(returnType, invokeMethod.getInvokedMethod(), "return");
                newReturnType = returnType;
            }
        } else {
            newReturnType = returnType;
        }
        ArrayList<Instruction> parameterConversions = new ArrayList<Instruction>();
        ArrayList<Value> newInValues = new ArrayList<Value>();
        if (invokeMethod.isInvokeMethodWithReceiver()) {
            assert (!this.appView.rewritePrefix.hasRewrittenType(invokedMethod.holder));
            newInValues.add(invokeMethod.asInvokeMethodWithReceiver().getReceiver());
        }
        int receiverShift = BooleanUtils.intValue(invokeMethod.isInvokeMethodWithReceiver());
        DexType[] parameters = invokedMethod.proto.parameters.values;
        DexType[] newParameters = (DexType[])parameters.clone();
        for (int i = 0; i < parameters.length; ++i) {
            DexType argType = parameters[i];
            if (this.appView.rewritePrefix.hasRewrittenType(argType)) {
                if (this.canConvert(argType)) {
                    DexType argVivifiedType = DesugaredLibraryAPIConverter.vivifiedTypeFor(argType, this.appView);
                    Value inValue = invokeMethod.inValues().get(i + receiverShift);
                    newParameters[i] = argVivifiedType;
                    parameterConversions.add(this.createParameterConversion(code, argType, argVivifiedType, inValue));
                    newInValues.add(((Instruction)parameterConversions.get(parameterConversions.size() - 1)).outValue());
                    continue;
                }
                this.warnInvalidInvoke(argType, invokeMethod.getInvokedMethod(), "parameter");
                newInValues.add(invokeMethod.inValues().get(i + receiverShift));
                continue;
            }
            newInValues.add(invokeMethod.inValues().get(i + receiverShift));
        }
        DexProto newProto = this.factory.createProto(newReturnType, newParameters);
        DexMethod newDexMethod = this.factory.createMethod(invokedMethod.holder, newProto, invokedMethod.name);
        Invoke newInvokeMethod = Invoke.create(invokeMethod.getType(), newDexMethod, newDexMethod.proto, invokeMethod.outValue(), newInValues);
        assert (newDexMethod == DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(invokedMethod, invokedMethod.holder, this.appView));
        iterator2.previous();
        for (Instruction parameterConversion : parameterConversions) {
            parameterConversion.setPosition(invokeMethod.getPosition());
            iterator2.add(parameterConversion);
        }
        assert (iterator2.peekNext() == invokeMethod);
        iterator2.next();
        iterator2.replaceCurrentInstruction(newInvokeMethod);
        if (returnConversion != null) {
            returnConversion.setPosition(invokeMethod.getPosition());
            iterator2.add(returnConversion);
        }
        if (newInvokeMethod.getBlock().hasCatchHandlers()) {
            this.splitIfCatchHandlers(code, newInvokeMethod.getBlock(), blockIterator);
        }
    }

    private void splitIfCatchHandlers(IRCode code, BasicBlock blockWithIncorrectThrowingInstructions, ListIterator<BasicBlock> blockIterator) {
        InstructionListIterator instructionsIterator = blockWithIncorrectThrowingInstructions.listIterator(code);
        BasicBlock currentBlock = blockWithIncorrectThrowingInstructions;
        while (currentBlock != null && instructionsIterator.hasNext()) {
            Instruction throwingInstruction = instructionsIterator.nextUntil(Instruction::instructionTypeCanThrow);
            if (throwingInstruction != null) {
                BasicBlock nextBlock = instructionsIterator.split(code, blockIterator);
                blockIterator.previous();
                nextBlock.copyCatchHandlers(code, blockIterator, currentBlock, this.appView.options());
                BasicBlock b = blockIterator.next();
                assert (b == nextBlock);
                instructionsIterator = nextBlock.listIterator(code);
                currentBlock = nextBlock;
                continue;
            }
            assert (!instructionsIterator.hasNext());
            instructionsIterator = null;
            currentBlock = null;
        }
    }

    private Instruction createParameterConversion(IRCode code, DexType argType, DexType argVivifiedType, Value inValue) {
        DexMethod conversionMethod = this.createConversionMethod(argType, argType, argVivifiedType);
        Value convertedValue = this.createConversionValue(code, inValue.getTypeLattice().nullability(), argVivifiedType);
        return new InvokeStatic(conversionMethod, convertedValue, Collections.singletonList(inValue));
    }

    private Instruction createReturnConversionAndReplaceUses(IRCode code, InvokeMethod invokeMethod, DexType returnType, DexType returnVivifiedType) {
        DexMethod conversionMethod = this.createConversionMethod(returnType, returnVivifiedType, returnType);
        Value convertedValue = this.createConversionValue(code, Nullability.maybeNull(), returnType);
        invokeMethod.outValue().replaceUsers(convertedValue);
        return new InvokeStatic(conversionMethod, convertedValue, Collections.singletonList(invokeMethod.outValue()));
    }

    public DexMethod createConversionMethod(DexType type, DexType srcType, DexType destType) {
        DexType conversionHolder = this.appView.options().desugaredLibraryConfiguration.getCustomConversions().get(type);
        if (conversionHolder == null) {
            DexType dexType = conversionHolder = type == srcType ? this.wrapperSynthesizor.getTypeWrapper(type) : this.wrapperSynthesizor.getVivifiedTypeWrapper(type);
        }
        assert (conversionHolder != null);
        return this.factory.createMethod(conversionHolder, this.factory.createProto(destType, srcType), this.factory.convertMethodName);
    }

    private Value createConversionValue(IRCode code, Nullability nullability, DexType valueType) {
        return code.createValue(TypeLatticeElement.fromDexType(valueType, nullability, this.appView));
    }

    public boolean canConvert(DexType type) {
        return this.appView.options().desugaredLibraryConfiguration.getCustomConversions().containsKey(type) || this.wrapperSynthesizor.canGenerateWrapper(type);
    }
}

