/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CheckCast;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeInterface;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class Devirtualizer {
    private final AppView<AppInfoWithLiveness> appView;

    public Devirtualizer(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public void devirtualizeInvokeInterface(IRCode code, DexType invocationContext) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        IdentityHashMap<InvokeInterface, InvokeVirtual> devirtualizedCall = new IdentityHashMap<InvokeInterface, InvokeVirtual>();
        DominatorTree dominatorTree = new DominatorTree(code);
        IdentityHashMap castedReceiverCache = new IdentityHashMap();
        Set<CheckCast> newCheckCastInstructions = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                TypeLatticeElement castTypeLattice;
                Value receiver;
                TypeLatticeElement receiverTypeLattice;
                Inliner.ConstraintWithTarget visibility;
                DexType holderType;
                DexClass holderClass;
                InvokeInterface invoke;
                DexEncodedMethod target;
                Assume<Assume.NonNullAssumption> nonNull;
                Instruction origin;
                Instruction current = (Instruction)it.next();
                if (current.isAssumeNonNull() && (origin = (nonNull = current.asAssumeNonNull()).origin()).isInvokeInterface() && !origin.asInvokeInterface().getReceiver().hasLocalInfo() && devirtualizedCall.containsKey(origin.asInvokeInterface()) && origin.asInvokeInterface().getReceiver() == nonNull.getAliasForOutValue()) {
                    CheckCast definition;
                    InvokeVirtual devirtualizedInvoke = (InvokeVirtual)devirtualizedCall.get(origin.asInvokeInterface());
                    CheckCast newCheckCast = null;
                    Value newReceiver = devirtualizedInvoke.getReceiver();
                    if (!newReceiver.isPhi() && newReceiver.definition.isCheckCast() && newCheckCastInstructions.contains(definition = newReceiver.definition.asCheckCast())) {
                        newCheckCast = definition;
                    }
                    if (newCheckCast != null) {
                        Value oldReceiver = newCheckCast.object();
                        TypeLatticeElement oldReceiverType = oldReceiver.getTypeLattice();
                        TypeLatticeElement newReceiverType = newReceiver.getTypeLattice();
                        if (newReceiverType.lessThanOrEqual(oldReceiverType, this.appView) && dominatorTree.dominatedBy(block, devirtualizedInvoke.getBlock())) {
                            assert (nonNull.src() == oldReceiver);
                            assert (!oldReceiver.hasLocalInfo());
                            oldReceiver.replaceSelectiveUsers(newReceiver, ImmutableSet.of(nonNull), ImmutableMap.of());
                        }
                    }
                }
                if (!current.isInvokeInterface() || (target = (invoke = current.asInvokeInterface()).lookupSingleTarget(this.appView, invocationContext)) == null || (holderClass = this.appView.definitionFor(holderType = target.method.holder)) == null || holderClass.isInterface() || (visibility = Inliner.ConstraintWithTarget.classIsVisible(invocationContext, holderType, this.appView)) == Inliner.ConstraintWithTarget.NEVER) continue;
                InvokeVirtual devirtualizedInvoke = new InvokeVirtual(target.method, invoke.outValue(), invoke.inValues());
                it.replaceCurrentInstruction(devirtualizedInvoke);
                devirtualizedCall.put(invoke, devirtualizedInvoke);
                if (holderType == invoke.getInvokedMethod().holder || (receiverTypeLattice = (receiver = invoke.getReceiver()).getTypeLattice()).lessThanOrEqual(castTypeLattice = TypeLatticeElement.fromDexType(holderType, receiverTypeLattice.nullability(), this.appView), this.appView)) continue;
                Value newReceiver = null;
                if (castedReceiverCache.containsKey(receiver) && ((Map)castedReceiverCache.get(receiver)).containsKey(holderType)) {
                    Value cachedReceiver = (Value)((Map)castedReceiverCache.get(receiver)).get(holderType);
                    if (dominatorTree.dominatedBy(block, cachedReceiver.definition.getBlock())) {
                        newReceiver = cachedReceiver;
                    }
                }
                if (newReceiver == null) {
                    BasicBlock blockWithDevirtualizedInvoke;
                    newReceiver = code.createValue(castTypeLattice);
                    if (!receiver.hasLocalInfo()) {
                        castedReceiverCache.putIfAbsent(receiver, new IdentityHashMap());
                        ((Map)castedReceiverCache.get(receiver)).put(holderType, newReceiver);
                    }
                    CheckCast checkCast = new CheckCast(newReceiver, receiver, holderType);
                    checkCast.setPosition(invoke.getPosition());
                    newCheckCastInstructions.add(checkCast);
                    assert (it.peekPrevious() == devirtualizedInvoke);
                    it.previous();
                    BasicBlock basicBlock = blockWithDevirtualizedInvoke = block.hasCatchHandlers() ? it.split(code, blocks) : block;
                    if (blockWithDevirtualizedInvoke != block) {
                        it = block.listIterator(code, block.getInstructions().size());
                        it.previous();
                        it.add(checkCast);
                        dominatorTree = new DominatorTree(code);
                        it = blockWithDevirtualizedInvoke.listIterator(code);
                        assert (it.peekNext() == devirtualizedInvoke);
                        it.next();
                    } else {
                        it.add(checkCast);
                        assert (it.peekNext() == devirtualizedInvoke);
                        it.next();
                    }
                }
                affectedValues.addAll(receiver.affectedValues());
                if (!receiver.hasLocalInfo()) {
                    receiver.replaceSelectiveUsers(newReceiver, ImmutableSet.of(devirtualizedInvoke), ImmutableMap.of());
                    continue;
                }
                receiver.removeUser(devirtualizedInvoke);
                devirtualizedInvoke.replaceValue(receiver, newReceiver);
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }
}

