/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class SwitchMapCollector {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexString switchMapPrefix;
    private final DexString kotlinSwitchMapPrefix;
    private final DexType intArrayType;
    private final Map<DexField, Int2ReferenceMap<DexField>> switchMaps = new IdentityHashMap<DexField, Int2ReferenceMap<DexField>>();

    public SwitchMapCollector(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        this.switchMapPrefix = dexItemFactory.createString("$SwitchMap$");
        this.kotlinSwitchMapPrefix = dexItemFactory.createString("$EnumSwitchMapping$");
        this.intArrayType = dexItemFactory.createType("[I");
    }

    public AppInfoWithLiveness run() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            this.processClasses(clazz);
        }
        if (!this.switchMaps.isEmpty()) {
            return this.appView.appInfo().addSwitchMaps(this.switchMaps);
        }
        return this.appView.appInfo();
    }

    private void processClasses(DexProgramClass clazz) {
        if (!clazz.accessFlags.isSynthetic() && !clazz.hasClassInitializer()) {
            return;
        }
        List<DexEncodedField> switchMapFields = clazz.staticFields().stream().filter(this::maybeIsSwitchMap).collect(Collectors.toList());
        if (!switchMapFields.isEmpty()) {
            IRCode initializer = clazz.getClassInitializer().buildIR(this.appView, clazz.origin);
            switchMapFields.forEach(field -> this.extractSwitchMap((DexEncodedField)field, initializer));
        }
    }

    private void extractSwitchMap(DexEncodedField encodedField, IRCode initializer) {
        DexField field = encodedField.field;
        Int2ReferenceArrayMap<DexField> switchMap = new Int2ReferenceArrayMap<DexField>();
        Predicate<Instruction> predicate = i -> (i.isStaticGet() || i.isStaticPut()) && i.asFieldInstruction().getField() == field;
        for (Instruction instruction : initializer.instructions(predicate)) {
            Value valueOfInterest = instruction.isStaticGet() ? instruction.outValue() : instruction.asStaticPut().value();
            for (Instruction use : valueOfInterest.uniqueUsers()) {
                if (use.isArrayPut()) {
                    Instruction index = use.asArrayPut().value().definition;
                    if (index == null || !index.isConstNumber()) {
                        return;
                    }
                    int integerIndex = index.asConstNumber().getIntValue();
                    Instruction value = use.asArrayPut().index().definition;
                    if (value == null || !value.isInvokeVirtual()) {
                        return;
                    }
                    InvokeVirtual invoke = value.asInvokeVirtual();
                    DexClass holder = this.appView.definitionFor(invoke.getInvokedMethod().holder);
                    if (holder == null || !holder.accessFlags.isEnum() && holder.type != this.appView.dexItemFactory().enumType) {
                        return;
                    }
                    Instruction enumGet = invoke.arguments().get((int)0).definition;
                    if (enumGet == null || !enumGet.isStaticGet()) {
                        return;
                    }
                    DexField enumField = enumGet.asStaticGet().getField();
                    if (!this.appView.definitionFor((DexType)enumField.holder).accessFlags.isEnum()) {
                        return;
                    }
                    if (switchMap.put(integerIndex, enumField) == null) continue;
                    return;
                }
                if (use == instruction) continue;
                return;
            }
        }
        this.switchMaps.put(field, switchMap);
    }

    private boolean maybeIsSwitchMap(DexEncodedField dexEncodedField) {
        DexField field = dexEncodedField.field;
        return dexEncodedField.accessFlags.isSynthetic() && (field.name.startsWith(this.switchMapPrefix) || field.name.startsWith(this.kotlinSwitchMapPrefix)) && field.type == this.intArrayType;
    }
}

