/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.InlineCandidateProcessor;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

class ClassInlinerReceiverSet {
    private final Value root;
    private final Set<Value> definiteReceiverAliases;
    private final Set<Value> maybeReceiverAliases = Sets.newIdentityHashSet();
    private final Set<Value> illegalReceiverAliases = Sets.newIdentityHashSet();
    private final Map<Value, List<BooleanSupplier>> deferredAliasValidityChecks = new IdentityHashMap<Value, List<BooleanSupplier>>();

    ClassInlinerReceiverSet(Value root) {
        this.definiteReceiverAliases = SetUtils.newIdentityHashSet(root);
        this.root = root;
    }

    Set<Value> getDefiniteReceiverAliases() {
        return this.definiteReceiverAliases;
    }

    Set<Value> getMaybeReceiverAliases() {
        return this.maybeReceiverAliases;
    }

    boolean addReceiverAlias(Value alias, InlineCandidateProcessor.AliasKind kind) {
        boolean changed;
        if (this.isIllegalReceiverAlias(alias)) {
            return false;
        }
        this.deferredAliasValidityChecks.remove(alias);
        if (kind == InlineCandidateProcessor.AliasKind.DEFINITE) {
            assert (!this.maybeReceiverAliases.contains(alias));
            changed = this.definiteReceiverAliases.add(alias);
        } else {
            assert (!this.definiteReceiverAliases.contains(alias));
            changed = this.maybeReceiverAliases.add(alias);
        }
        assert (changed) : alias.toString() + " already added as an alias";
        return true;
    }

    boolean addIllegalReceiverAlias(Value value) {
        if (this.isReceiverAlias(value)) {
            return false;
        }
        this.illegalReceiverAliases.add(value);
        this.deferredAliasValidityChecks.remove(value);
        return true;
    }

    void addDeferredAliasValidityCheck(Value value, BooleanSupplier deferredValidityCheck) {
        assert (!this.isReceiverAlias(value));
        if (this.illegalReceiverAliases.contains(value)) {
            assert (!this.deferredAliasValidityChecks.containsKey(value));
        } else {
            this.deferredAliasValidityChecks.computeIfAbsent(value, ignore -> new ArrayList()).add(deferredValidityCheck);
        }
    }

    boolean isReceiverAlias(Value value) {
        return this.isDefiniteReceiverAlias(value) || this.isMaybeReceiverAlias(value);
    }

    boolean isDefiniteReceiverAlias(Value value) {
        return this.definiteReceiverAliases.contains(value);
    }

    private boolean isMaybeReceiverAlias(Value value) {
        return this.maybeReceiverAliases.contains(value);
    }

    private boolean isIllegalReceiverAlias(Value value) {
        if (this.illegalReceiverAliases.contains(value)) {
            return true;
        }
        List<BooleanSupplier> deferredValidityChecks = this.deferredAliasValidityChecks.get(value);
        if (deferredValidityChecks != null) {
            for (BooleanSupplier deferredValidityCheck : deferredValidityChecks) {
                if (deferredValidityCheck.getAsBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    void reset() {
        this.deferredAliasValidityChecks.clear();
        this.definiteReceiverAliases.clear();
        this.definiteReceiverAliases.add(this.root);
        this.maybeReceiverAliases.clear();
    }

    boolean verifyReceiverSetsAreDisjoint() {
        assert (Sets.intersection(this.getMaybeReceiverAliases(), this.getDefiniteReceiverAliases()).isEmpty());
        return true;
    }
}

