/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.info;

import java.util.BitSet;
import java.util.Set;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInlinerEligibilityInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.ParameterUsagesInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.DefaultInstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.utils.BooleanUtils;

public class UpdatableMethodOptimizationInfo
implements MethodOptimizationInfo {
    private Set<DexType> initializedClassesOnNormalExit = DefaultMethodOptimizationInfo.UNKNOWN_INITIALIZED_CLASSES_ON_NORMAL_EXIT;
    private int returnedArgument = DefaultMethodOptimizationInfo.UNKNOWN_RETURNED_ARGUMENT;
    private AbstractValue abstractReturnValue = DefaultMethodOptimizationInfo.UNKNOWN_ABSTRACT_RETURN_VALUE;
    private TypeLatticeElement returnsObjectWithUpperBoundType = DefaultMethodOptimizationInfo.UNKNOWN_TYPE;
    private ClassTypeLatticeElement returnsObjectWithLowerBoundType = DefaultMethodOptimizationInfo.UNKNOWN_CLASS_TYPE;
    private MethodOptimizationInfo.InlinePreference inlining = MethodOptimizationInfo.InlinePreference.Default;
    private ClassInlinerEligibilityInfo classInlinerEligibility = DefaultMethodOptimizationInfo.UNKNOWN_CLASS_INLINER_ELIGIBILITY;
    private InstanceInitializerInfo instanceInitializerInfo = DefaultInstanceInitializerInfo.getInstance();
    private ParameterUsagesInfo parametersUsages = DefaultMethodOptimizationInfo.UNKNOWN_PARAMETER_USAGE_INFO;
    private BitSet nonNullParamOrThrow = DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_OR_THROW_FACTS;
    private BitSet nonNullParamOnNormalExits = DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS;
    private static final int CANNOT_BE_KEPT_FLAG = 1;
    private static final int CLASS_INITIALIZER_MAY_BE_POSTPONED_FLAG = 2;
    private static final int HAS_BEEN_INLINED_INTO_SINGLE_CALL_SITE_FLAG = 4;
    private static final int MAY_HAVE_SIDE_EFFECT_FLAG = 8;
    private static final int RETURN_VALUE_ONLY_DEPENDS_ON_ARGUMENTS_FLAG = 16;
    private static final int NEVER_RETURNS_NULL_FLAG = 32;
    private static final int NEVER_RETURNS_NORMALLY_FLAG = 64;
    private static final int USE_IDENTIFIER_NAME_STRING_FLAG = 128;
    private static final int CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT_FLAG = 256;
    private static final int TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT_FLAG = 512;
    private static final int INITIALIZER_ENABLING_JAVA_ASSERTIONS_FLAG = 1024;
    private static final int REACHABILITY_SENSITIVE_FLAG = 2048;
    private static final int RETURN_VALUE_HAS_BEEN_PROPAGATED_FLAG = 4096;
    private static final int DEFAULT_FLAGS;
    private int flags = DEFAULT_FLAGS;

    UpdatableMethodOptimizationInfo() {
    }

    private UpdatableMethodOptimizationInfo(UpdatableMethodOptimizationInfo template) {
        this.flags = template.flags;
        this.initializedClassesOnNormalExit = template.initializedClassesOnNormalExit;
        this.returnedArgument = template.returnedArgument;
        this.abstractReturnValue = template.abstractReturnValue;
        this.returnsObjectWithUpperBoundType = template.returnsObjectWithUpperBoundType;
        this.returnsObjectWithLowerBoundType = template.returnsObjectWithLowerBoundType;
        this.inlining = template.inlining;
        this.classInlinerEligibility = template.classInlinerEligibility;
        this.instanceInitializerInfo = template.instanceInitializerInfo;
        this.parametersUsages = template.parametersUsages;
        this.nonNullParamOrThrow = template.nonNullParamOrThrow;
        this.nonNullParamOnNormalExits = template.nonNullParamOnNormalExits;
    }

    public void fixupClassTypeReferences(Function<DexType, DexType> mapping, AppView<? extends AppInfoWithSubtyping> appView) {
        if (this.returnsObjectWithUpperBoundType != null) {
            this.returnsObjectWithUpperBoundType = this.returnsObjectWithUpperBoundType.fixupClassTypeReferences(mapping, appView);
        }
        if (this.returnsObjectWithLowerBoundType != null) {
            this.returnsObjectWithLowerBoundType = this.returnsObjectWithLowerBoundType.fixupClassTypeReferences((Function)mapping, (AppView)appView);
        }
    }

    private void setFlag(int flag, boolean value) {
        if (value) {
            this.setFlag(flag);
        } else {
            this.clearFlag(flag);
        }
    }

    private void setFlag(int flag) {
        this.flags |= flag;
    }

    private void clearFlag(int flag) {
        this.flags &= ~flag;
    }

    private boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public boolean isDefaultMethodOptimizationInfo() {
        return false;
    }

    @Override
    public boolean isUpdatableMethodOptimizationInfo() {
        return true;
    }

    @Override
    public UpdatableMethodOptimizationInfo asUpdatableMethodOptimizationInfo() {
        return this;
    }

    @Override
    public boolean cannotBeKept() {
        return this.isFlagSet(1);
    }

    public void markCannotBeKept() {
        this.setFlag(1);
    }

    @Override
    public boolean classInitializerMayBePostponed() {
        return this.isFlagSet(2);
    }

    void markClassInitializerMayBePostponed() {
        this.setFlag(2);
    }

    @Override
    public TypeLatticeElement getDynamicUpperBoundType() {
        return this.returnsObjectWithUpperBoundType;
    }

    @Override
    public ClassTypeLatticeElement getDynamicLowerBoundType() {
        return this.returnsObjectWithLowerBoundType;
    }

    @Override
    public Set<DexType> getInitializedClassesOnNormalExit() {
        return this.initializedClassesOnNormalExit;
    }

    @Override
    public InstanceInitializerInfo getInstanceInitializerInfo() {
        return this.instanceInitializerInfo;
    }

    @Override
    public ParameterUsagesInfo.ParameterUsage getParameterUsages(int parameter) {
        return this.parametersUsages == null ? null : this.parametersUsages.getParameterUsage(parameter);
    }

    @Override
    public BitSet getNonNullParamOrThrow() {
        return this.nonNullParamOrThrow;
    }

    @Override
    public BitSet getNonNullParamOnNormalExits() {
        return this.nonNullParamOnNormalExits;
    }

    @Override
    public boolean hasBeenInlinedIntoSingleCallSite() {
        return this.isFlagSet(4);
    }

    void markInlinedIntoSingleCallSite() {
        this.setFlag(4);
    }

    @Override
    public boolean isReachabilitySensitive() {
        return this.isFlagSet(2048);
    }

    @Override
    public boolean returnsArgument() {
        return this.returnedArgument != -1;
    }

    @Override
    public int getReturnedArgument() {
        assert (this.returnsArgument());
        return this.returnedArgument;
    }

    @Override
    public boolean neverReturnsNull() {
        return this.isFlagSet(32);
    }

    @Override
    public boolean neverReturnsNormally() {
        return this.isFlagSet(64);
    }

    @Override
    public ClassInlinerEligibilityInfo getClassInlinerEligibility() {
        return this.classInlinerEligibility;
    }

    @Override
    public AbstractValue getAbstractReturnValue() {
        return this.abstractReturnValue;
    }

    @Override
    public boolean isInitializerEnablingJavaAssertions() {
        return this.isFlagSet(1024);
    }

    @Override
    public boolean useIdentifierNameString() {
        return this.isFlagSet(128);
    }

    @Override
    public boolean forceInline() {
        return this.inlining == MethodOptimizationInfo.InlinePreference.ForceInline;
    }

    @Override
    public boolean neverInline() {
        return this.inlining == MethodOptimizationInfo.InlinePreference.NeverInline;
    }

    @Override
    public boolean checksNullReceiverBeforeAnySideEffect() {
        return this.isFlagSet(256);
    }

    @Override
    public boolean triggersClassInitBeforeAnySideEffect() {
        return this.isFlagSet(512);
    }

    @Override
    public boolean mayHaveSideEffects() {
        return this.isFlagSet(8);
    }

    @Override
    public boolean returnValueOnlyDependsOnArguments() {
        return this.isFlagSet(16);
    }

    void setParameterUsages(ParameterUsagesInfo parametersUsages) {
        this.parametersUsages = parametersUsages;
    }

    void setNonNullParamOrThrow(BitSet facts) {
        this.nonNullParamOrThrow = facts;
    }

    void setNonNullParamOnNormalExits(BitSet facts) {
        this.nonNullParamOnNormalExits = facts;
    }

    public void setReachabilitySensitive(boolean reachabilitySensitive) {
        this.setFlag(2048, reachabilitySensitive);
    }

    void setClassInlinerEligibility(ClassInlinerEligibilityInfo eligibility) {
        this.classInlinerEligibility = eligibility;
    }

    void setInstanceInitializerInfo(InstanceInitializerInfo instanceInitializerInfo) {
        this.instanceInitializerInfo = instanceInitializerInfo;
    }

    void setInitializerEnablingJavaAssertions() {
        this.setFlag(1024);
    }

    void markInitializesClassesOnNormalExit(Set<DexType> initializedClassesOnNormalExit) {
        this.initializedClassesOnNormalExit = initializedClassesOnNormalExit;
    }

    void markReturnsArgument(int argument) {
        assert (argument >= 0);
        assert (this.returnedArgument == -1 || this.returnedArgument == argument);
        this.returnedArgument = argument;
    }

    void markMayNotHaveSideEffects() {
        this.clearFlag(8);
    }

    void markReturnValueOnlyDependsOnArguments() {
        this.setFlag(16);
    }

    void markNeverReturnsNull() {
        this.setFlag(32);
    }

    void markNeverReturnsNormally() {
        this.setFlag(64);
    }

    void markReturnsAbstractValue(AbstractValue value) {
        assert (!this.abstractReturnValue.isSingleValue() || this.abstractReturnValue.asSingleValue() == value) : "return single value changed from " + this.abstractReturnValue + " to " + value;
        this.abstractReturnValue = value;
    }

    void markReturnsObjectWithUpperBoundType(AppView<?> appView, TypeLatticeElement type) {
        assert (type != null);
        assert (this.returnsObjectWithUpperBoundType == DefaultMethodOptimizationInfo.UNKNOWN_TYPE || type.lessThanOrEqualUpToNullability(this.returnsObjectWithUpperBoundType, appView)) : "upper bound type changed from " + this.returnsObjectWithUpperBoundType + " to " + type;
        this.returnsObjectWithUpperBoundType = type;
    }

    void markReturnsObjectWithLowerBoundType(ClassTypeLatticeElement type) {
        assert (type != null);
        assert (this.returnsObjectWithLowerBoundType == DefaultMethodOptimizationInfo.UNKNOWN_CLASS_TYPE || type.equalUpToNullability(this.returnsObjectWithLowerBoundType) && type.nullability().lessThanOrEqual(this.returnsObjectWithLowerBoundType.nullability())) : "lower bound type changed from " + this.returnsObjectWithLowerBoundType + " to " + type;
        this.returnsObjectWithLowerBoundType = type;
    }

    public void markForceInline() {
        assert (this.inlining == MethodOptimizationInfo.InlinePreference.Default || this.inlining == MethodOptimizationInfo.InlinePreference.ForceInline);
        this.inlining = MethodOptimizationInfo.InlinePreference.ForceInline;
    }

    public void unsetForceInline() {
        assert (this.inlining == MethodOptimizationInfo.InlinePreference.Default || this.inlining == MethodOptimizationInfo.InlinePreference.ForceInline);
        this.inlining = MethodOptimizationInfo.InlinePreference.Default;
    }

    public void markNeverInline() {
        assert (this.inlining == MethodOptimizationInfo.InlinePreference.Default || this.inlining == MethodOptimizationInfo.InlinePreference.NeverInline);
        this.inlining = MethodOptimizationInfo.InlinePreference.NeverInline;
    }

    public void markUseIdentifierNameString() {
        this.setFlag(128);
    }

    void markCheckNullReceiverBeforeAnySideEffect(boolean mark) {
        this.setFlag(256, mark);
    }

    void markTriggerClassInitBeforeAnySideEffect(boolean mark) {
        this.setFlag(512, mark);
    }

    public void markAsPropagated() {
        this.setFlag(4096);
    }

    @Override
    public boolean returnValueHasBeenPropagated() {
        return this.isFlagSet(4096);
    }

    @Override
    public UpdatableMethodOptimizationInfo mutableCopy() {
        assert (this != DefaultMethodOptimizationInfo.DEFAULT_INSTANCE);
        return new UpdatableMethodOptimizationInfo(this);
    }

    public void adjustOptimizationInfoAfterRemovingThisParameter() {
        this.clearFlag(2);
        this.clearFlag(4);
        this.initializedClassesOnNormalExit = DefaultMethodOptimizationInfo.UNKNOWN_INITIALIZED_CLASSES_ON_NORMAL_EXIT;
        assert (this.returnedArgument == DefaultMethodOptimizationInfo.UNKNOWN_RETURNED_ARGUMENT || this.returnedArgument > 0);
        this.returnedArgument = this.returnedArgument == DefaultMethodOptimizationInfo.UNKNOWN_RETURNED_ARGUMENT ? DefaultMethodOptimizationInfo.UNKNOWN_RETURNED_ARGUMENT : this.returnedArgument - 1;
        this.inlining = MethodOptimizationInfo.InlinePreference.Default;
        this.markCheckNullReceiverBeforeAnySideEffect(DefaultMethodOptimizationInfo.UNKNOWN_CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT);
        this.markTriggerClassInitBeforeAnySideEffect(DefaultMethodOptimizationInfo.UNKNOWN_TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT);
        this.classInlinerEligibility = DefaultMethodOptimizationInfo.UNKNOWN_CLASS_INLINER_ELIGIBILITY;
        this.instanceInitializerInfo = null;
        this.setFlag(1024, DefaultMethodOptimizationInfo.UNKNOWN_INITIALIZER_ENABLING_JAVA_ASSERTIONS);
        this.parametersUsages = this.parametersUsages == DefaultMethodOptimizationInfo.UNKNOWN_PARAMETER_USAGE_INFO ? DefaultMethodOptimizationInfo.UNKNOWN_PARAMETER_USAGE_INFO : this.parametersUsages.remove(0);
        this.nonNullParamOrThrow = this.nonNullParamOrThrow == DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_OR_THROW_FACTS ? DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_OR_THROW_FACTS : this.nonNullParamOrThrow.get(1, this.nonNullParamOrThrow.length());
        this.nonNullParamOnNormalExits = this.nonNullParamOnNormalExits == DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS ? DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS : this.nonNullParamOnNormalExits.get(1, this.nonNullParamOnNormalExits.length());
    }

    static {
        int defaultFlags = 0;
        MethodOptimizationInfo defaultOptInfo = DefaultMethodOptimizationInfo.DEFAULT_INSTANCE;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.cannotBeKept()) * 1;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.classInitializerMayBePostponed()) * 2;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.hasBeenInlinedIntoSingleCallSite()) * 4;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.mayHaveSideEffects()) * 8;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.returnValueOnlyDependsOnArguments()) * 16;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.neverReturnsNull()) * 32;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.neverReturnsNormally()) * 64;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.useIdentifierNameString()) * 128;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.checksNullReceiverBeforeAnySideEffect()) * 256;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.triggersClassInitBeforeAnySideEffect()) * 512;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.isInitializerEnablingJavaAssertions()) * 1024;
        defaultFlags |= BooleanUtils.intValue(defaultOptInfo.isReachabilitySensitive()) * 2048;
        DEFAULT_FLAGS = defaultFlags |= BooleanUtils.intValue(defaultOptInfo.returnValueHasBeenPropagated()) * 4096;
    }
}

