/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntFunction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntLists;

public final class CaptureSignature {
    private static final IntList EMPTY_LIST = IntLists.EMPTY_LIST;
    private static final IntList SINGLE_LIST = IntLists.singleton(0);

    private CaptureSignature() {
    }

    public static IntList getReverseCaptureMapping(DexType[] types) {
        if (types.length == 0) {
            return EMPTY_LIST;
        }
        if (types.length == 1) {
            return SINGLE_LIST;
        }
        IntArrayList result = new IntArrayList(types.length);
        for (int i2 = 0; i2 < types.length; ++i2) {
            result.add(i2);
        }
        result.sort(Comparator.comparingInt(i -> types[i].toShorty()));
        assert (CaptureSignature.verifyMapping(result));
        return result;
    }

    public static DexType fieldType(DexItemFactory factory, String capture, int index) {
        switch (capture.charAt(index)) {
            case 'L': {
                return factory.objectType;
            }
            case 'Z': {
                return factory.booleanType;
            }
            case 'B': {
                return factory.byteType;
            }
            case 'S': {
                return factory.shortType;
            }
            case 'C': {
                return factory.charType;
            }
            case 'I': {
                return factory.intType;
            }
            case 'F': {
                return factory.floatType;
            }
            case 'J': {
                return factory.longType;
            }
            case 'D': {
                return factory.doubleType;
            }
        }
        throw new Unreachable("Invalid capture character: " + capture.charAt(index));
    }

    private static String getCaptureSignature(int size, IntFunction<DexType> type) {
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return Character.toString(type.apply(0).toShorty());
        }
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = type.apply(i).toShorty();
        }
        Arrays.sort(chars);
        return new String(chars);
    }

    public static String getCaptureSignature(List<DexEncodedField> fields) {
        return CaptureSignature.getCaptureSignature(fields.size(), i -> ((DexEncodedField)fields.get((int)i)).field.type);
    }

    public static String getCaptureSignature(DexTypeList types) {
        return CaptureSignature.getCaptureSignature(types.values.length, i -> types.values[i]);
    }

    public static int mapFieldIntoCaptureIndex(String capture, List<DexEncodedField> lambdaFields, DexField fieldToMap) {
        char fieldKind = fieldToMap.type.toShorty();
        int numberOfSameCaptureKind = 0;
        int result = -1;
        for (DexEncodedField encodedField : lambdaFields) {
            if (encodedField.field == fieldToMap) {
                result = numberOfSameCaptureKind;
                break;
            }
            if (encodedField.field.type.toShorty() != fieldKind) continue;
            ++numberOfSameCaptureKind;
        }
        assert (result >= 0) : "Field was not found in the lambda class.";
        for (int index = 0; index < capture.length(); ++index) {
            if (capture.charAt(index) != fieldKind) continue;
            if (result == 0) {
                return index;
            }
            --result;
        }
        throw new Unreachable("Were not able to map lambda field into capture index");
    }

    private static boolean verifyMapping(IntList mapping) {
        BitSet bits = new BitSet();
        for (Integer i : mapping) {
            assert (i >= 0 && i < mapping.size());
            assert (!bits.get(i));
            bits.set(i);
        }
        return true;
    }
}

