/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda;

import java.util.ListIterator;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CheckCast;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstMethodHandle;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstMethodType;
import shadow.bundletool.com.android.tools.r8.ir.code.DefaultInstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaMerger;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaTypeVisitor;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public abstract class CodeProcessor
extends DefaultInstructionVisitor<Void> {
    static final Strategy NoOp = new Strategy(){

        @Override
        public LambdaGroup group() {
            return null;
        }

        @Override
        public boolean isValidInstanceFieldWrite(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidInstanceFieldRead(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidStaticFieldWrite(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidStaticFieldRead(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidInvoke(CodeProcessor context, InvokeMethod invoke) {
            return false;
        }

        @Override
        public boolean isValidNewInstance(CodeProcessor context, NewInstance invoke) {
            return false;
        }

        @Override
        public void patch(LambdaMerger.ApplyStrategy context, NewInstance newInstance) {
            throw new Unreachable();
        }

        @Override
        public void patch(LambdaMerger.ApplyStrategy context, InvokeMethod invoke) {
            throw new Unreachable();
        }

        @Override
        public void patch(LambdaMerger.ApplyStrategy context, InstanceGet instanceGet) {
            throw new Unreachable();
        }

        @Override
        public void patch(LambdaMerger.ApplyStrategy context, StaticGet staticGet) {
            throw new Unreachable();
        }
    };
    public final AppView<AppInfoWithLiveness> appView;
    public final DexItemFactory factory;
    public final Kotlin kotlin;
    private final Function<DexType, Strategy> strategyProvider;
    private final LambdaTypeVisitor lambdaChecker;
    public final DexEncodedMethod method;
    public final IRCode code;
    public final ListIterator<BasicBlock> blocks;
    private InstructionListIterator instructions;
    private final DexEncodedMethod context;

    CodeProcessor(AppView<AppInfoWithLiveness> appView, Function<DexType, Strategy> strategyProvider, LambdaTypeVisitor lambdaChecker, DexEncodedMethod method, IRCode code) {
        this(appView, strategyProvider, lambdaChecker, method, code, null);
    }

    CodeProcessor(AppView<AppInfoWithLiveness> appView, Function<DexType, Strategy> strategyProvider, LambdaTypeVisitor lambdaChecker, DexEncodedMethod method, IRCode code, DexEncodedMethod context) {
        this.appView = appView;
        this.strategyProvider = strategyProvider;
        this.factory = appView.dexItemFactory();
        this.kotlin = this.factory.kotlin;
        this.lambdaChecker = lambdaChecker;
        this.method = method;
        this.code = code;
        this.blocks = code.listIterator();
        this.context = context;
    }

    public final InstructionListIterator instructions() {
        assert (this.instructions != null);
        return this.instructions;
    }

    void processCode() {
        while (this.blocks.hasNext()) {
            BasicBlock block = this.blocks.next();
            this.instructions = block.listIterator(this.code);
            while (this.instructions.hasNext()) {
                ((Instruction)this.instructions.next()).accept(this);
            }
        }
    }

    private boolean shouldRewrite(DexField field) {
        return this.shouldRewrite(field.holder);
    }

    private boolean shouldRewrite(DexMethod method) {
        return this.shouldRewrite(method.holder);
    }

    private boolean shouldRewrite(DexType type) {
        return type != (this.context != null ? this.context : this.method).method.holder;
    }

    @Override
    public Void handleInvoke(Invoke invoke) {
        if (invoke.isInvokeNewArray()) {
            this.lambdaChecker.accept(invoke.asInvokeNewArray().getReturnType());
            return null;
        }
        if (invoke.isInvokeMultiNewArray()) {
            this.lambdaChecker.accept(invoke.asInvokeMultiNewArray().getReturnType());
            return null;
        }
        if (invoke.isInvokeCustom()) {
            this.lambdaChecker.accept(invoke.asInvokeCustom().getCallSite());
            return null;
        }
        InvokeMethod invokeMethod = invoke.asInvokeMethod();
        Strategy strategy = this.strategyProvider.apply(invokeMethod.getInvokedMethod().holder);
        if (strategy.isValidInvoke(this, invokeMethod)) {
            this.lambdaChecker.accept(invokeMethod.getInvokedMethod().proto);
            if (this.shouldRewrite(invokeMethod.getInvokedMethod())) {
                this.process(strategy, invokeMethod);
            }
            return null;
        }
        if (invoke.isInvokePolymorphic()) {
            this.lambdaChecker.accept(invoke.asInvokePolymorphic().getProto());
        }
        this.lambdaChecker.accept(invokeMethod.getInvokedMethod(), null);
        return null;
    }

    @Override
    public Void visit(NewInstance newInstance) {
        Strategy strategy = this.strategyProvider.apply(newInstance.clazz);
        if (strategy.isValidNewInstance(this, newInstance) && this.shouldRewrite(newInstance.clazz)) {
            this.process(strategy, newInstance);
        }
        return null;
    }

    @Override
    public Void visit(CheckCast checkCast) {
        this.lambdaChecker.accept(checkCast.getType());
        return null;
    }

    @Override
    public Void visit(NewArrayEmpty newArrayEmpty) {
        this.lambdaChecker.accept(newArrayEmpty.type);
        return null;
    }

    @Override
    public Void visit(ConstClass constClass) {
        this.lambdaChecker.accept(constClass.getValue());
        return null;
    }

    @Override
    public Void visit(ConstMethodType constMethodType) {
        this.lambdaChecker.accept(constMethodType.getValue());
        return null;
    }

    @Override
    public Void visit(ConstMethodHandle constMethodHandle) {
        this.lambdaChecker.accept(constMethodHandle.getValue());
        return null;
    }

    @Override
    public Void visit(InstanceGet instanceGet) {
        DexField field = instanceGet.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidInstanceFieldRead(this, field)) {
            if (this.shouldRewrite(field)) {
                this.process(strategy, instanceGet);
            }
        } else {
            this.lambdaChecker.accept(field.type);
        }
        this.lambdaChecker.accept(field.type);
        return null;
    }

    @Override
    public Void visit(InstancePut instancePut) {
        DexField field = instancePut.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidInstanceFieldWrite(this, field)) {
            if (this.shouldRewrite(field)) {
                this.process(strategy, instancePut);
            }
        } else {
            this.lambdaChecker.accept(field.type);
        }
        this.lambdaChecker.accept(field.type);
        return null;
    }

    @Override
    public Void visit(StaticGet staticGet) {
        DexField field = staticGet.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidStaticFieldRead(this, field)) {
            if (this.shouldRewrite(field)) {
                this.process(strategy, staticGet);
            }
        } else {
            this.lambdaChecker.accept(field.type);
            this.lambdaChecker.accept(field.holder);
        }
        return null;
    }

    @Override
    public Void visit(StaticPut staticPut) {
        DexField field = staticPut.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidStaticFieldWrite(this, field)) {
            if (this.shouldRewrite(field)) {
                this.process(strategy, staticPut);
            }
        } else {
            this.lambdaChecker.accept(field.type);
            this.lambdaChecker.accept(field.holder);
        }
        return null;
    }

    abstract void process(Strategy var1, InvokeMethod var2);

    abstract void process(Strategy var1, NewInstance var2);

    abstract void process(Strategy var1, InstancePut var2);

    abstract void process(Strategy var1, InstanceGet var2);

    abstract void process(Strategy var1, StaticPut var2);

    abstract void process(Strategy var1, StaticGet var2);

    public static interface Strategy {
        public LambdaGroup group();

        public boolean isValidStaticFieldWrite(CodeProcessor var1, DexField var2);

        public boolean isValidStaticFieldRead(CodeProcessor var1, DexField var2);

        public boolean isValidInstanceFieldWrite(CodeProcessor var1, DexField var2);

        public boolean isValidInstanceFieldRead(CodeProcessor var1, DexField var2);

        public boolean isValidInvoke(CodeProcessor var1, InvokeMethod var2);

        public boolean isValidNewInstance(CodeProcessor var1, NewInstance var2);

        public void patch(LambdaMerger.ApplyStrategy var1, NewInstance var2);

        public void patch(LambdaMerger.ApplyStrategy var1, InvokeMethod var2);

        public void patch(LambdaMerger.ApplyStrategy var1, InstanceGet var2);

        public void patch(LambdaMerger.ApplyStrategy var1, StaticGet var2);
    }
}

