/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.classmerging.HorizontallyMergedLambdaClasses;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.DestructivePhiTypeUpdater;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.CodeProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaTypeVisitor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupIdFactory;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingConsumer;

public final class LambdaMerger {
    private final Map<DexType, LambdaGroup> lambdas = new IdentityHashMap<DexType, LambdaGroup>();
    private final Map<LambdaGroupId, LambdaGroup> groups = new LinkedHashMap<LambdaGroupId, LambdaGroup>();
    private final Set<DexType> invalidatedLambdas = Sets.newConcurrentHashSet();
    private final Set<DexEncodedMethod> methodsToReprocess = Sets.newIdentityHashSet();
    private final AppView<AppInfoWithLiveness> appView;
    private final Kotlin kotlin;
    private final DiagnosticsHandler reporter;
    private Mode mode;
    private final LambdaTypeVisitor lambdaInvalidator;
    private final LambdaTypeVisitor lambdaChecker;

    public LambdaMerger(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory factory = appView.dexItemFactory();
        this.appView = appView;
        this.kotlin = factory.kotlin;
        this.reporter = appView.options().reporter;
        this.lambdaInvalidator = new LambdaTypeVisitor(factory, this::isMergeableLambda, this::invalidateLambda);
        this.lambdaChecker = new LambdaTypeVisitor(factory, this::isMergeableLambda, type -> {
            throw new Unreachable("Unexpected lambda " + type.toSourceString());
        });
    }

    private void invalidateLambda(DexType lambda2) {
        this.invalidatedLambdas.add(lambda2);
    }

    private synchronized boolean isMergeableLambda(DexType lambda2) {
        return this.lambdas.containsKey(lambda2);
    }

    private synchronized LambdaGroup getLambdaGroup(DexType lambda2) {
        return this.lambdas.get(lambda2);
    }

    private synchronized void queueForProcessing(DexEncodedMethod method) {
        this.methodsToReprocess.add(method);
    }

    public final void collectGroupCandidates(DexApplication app) {
        app.classes().stream().filter(cls -> !this.appView.appInfo().isPinned(cls.type)).filter(cls -> cls.hasKotlinInfo() && cls.getKotlinInfo().isSyntheticClass() && cls.getKotlinInfo().asSyntheticClass().isLambda() && KotlinLambdaGroupIdFactory.hasValidAnnotations(this.kotlin, cls)).sorted((a, b) -> a.type.slowCompareTo(b.type)).forEachOrdered(lambda2 -> {
            block2: {
                try {
                    LambdaGroupId id = KotlinLambdaGroupIdFactory.create(this.kotlin, lambda2, this.appView.options());
                    LambdaGroup group = this.groups.computeIfAbsent(id, LambdaGroupId::createGroup);
                    group.add((DexProgramClass)lambda2);
                    this.lambdas.put(lambda2.type, group);
                }
                catch (LambdaGroup.LambdaStructureError error) {
                    if (!error.reportable) break block2;
                    this.reporter.info(new StringDiagnostic("Unrecognized Kotlin lambda [" + lambda2.type.toSourceString() + "]: " + error.getMessage()));
                }
            }
        });
        this.removeTrivialLambdaGroups();
        assert (this.mode == null);
        this.mode = new AnalyzeMode();
    }

    public final void analyzeCode(DexEncodedMethod method, IRCode code) {
        if (this.mode != null) {
            this.mode.analyzeCode(method, code);
        }
    }

    public final void rewriteCode(DexEncodedMethod method, IRCode code, Inliner inliner) {
        if (this.mode != null) {
            this.mode.rewriteCode(method, code, inliner, null);
        }
    }

    public final void rewriteCodeForInlining(DexEncodedMethod method, IRCode code, DexEncodedMethod context) {
        if (this.mode != null) {
            this.mode.rewriteCode(method, code, null, context);
        }
    }

    public final void applyLambdaClassMapping(DexApplication app, IRConverter converter, OptimizationFeedback feedback, DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.lambdas.isEmpty()) {
            return;
        }
        ThreadUtils.processItems(app.classes(), this::analyzeClass, executorService);
        this.analyzeLambdaClassesStructure(executorService);
        BiMap<LambdaGroup, DexProgramClass> lambdaGroupsClasses = this.finalizeLambdaGroups(feedback);
        LambdaMergerOptimizationInfoFixer optimizationInfoFixer = new LambdaMergerOptimizationInfoFixer(lambdaGroupsClasses);
        feedback.fixupOptimizationInfos(this.appView, executorService, optimizationInfoFixer);
        this.mode = new ApplyMode(lambdaGroupsClasses.inverse(), optimizationInfoFixer);
        for (Map.Entry entry : lambdaGroupsClasses.entrySet()) {
            DexProgramClass synthesizedClass = (DexProgramClass)entry.getValue();
            this.appView.appInfo().addSynthesizedClass(synthesizedClass);
            builder.addSynthesizedClass(synthesizedClass, ((LambdaGroup)entry.getKey()).shouldAddToMainDex(this.appView));
            synthesizedClass.forEachMethod(encodedMethod -> encodedMethod.markProcessed(Inliner.ConstraintWithTarget.NEVER));
        }
        converter.optimizeSynthesizedClasses(lambdaGroupsClasses.values(), executorService);
        this.rewriteLambdaReferences(converter, executorService, feedback);
        this.mode = null;
        this.appView.setHorizontallyMergedLambdaClasses(new HorizontallyMergedLambdaClasses(this.lambdas.keySet()));
    }

    private void analyzeLambdaClassesStructure(ExecutorService service) throws ExecutionException {
        ArrayList futures = new ArrayList();
        for (LambdaGroup group : this.groups.values()) {
            ThrowingConsumer<DexClass, LambdaGroup.LambdaStructureError> validator = group.lambdaClassValidator(this.kotlin, this.appView.appInfo());
            group.forEachLambda(info -> futures.add(service.submit(() -> {
                try {
                    validator.accept(info.clazz);
                }
                catch (LambdaGroup.LambdaStructureError error) {
                    if (error.reportable) {
                        this.reporter.info(new StringDiagnostic("Unexpected Kotlin lambda structure [" + info.clazz.type.toSourceString() + "]: " + error.getMessage()));
                    }
                    this.invalidateLambda(info.clazz.type);
                }
            })));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private BiMap<LambdaGroup, DexProgramClass> finalizeLambdaGroups(OptimizationFeedback feedback) {
        for (DexType lambda2 : this.invalidatedLambdas) {
            LambdaGroup group = this.lambdas.get(lambda2);
            assert (group != null);
            this.lambdas.remove(lambda2);
            group.remove(lambda2);
        }
        this.invalidatedLambdas.clear();
        this.removeTrivialLambdaGroups();
        HashBiMap<LambdaGroup, DexProgramClass> result = HashBiMap.create();
        for (LambdaGroup group : this.groups.values()) {
            assert (!group.isTrivial()) : "No trivial group is expected here.";
            group.compact();
            DexProgramClass lambdaGroupClass = group.synthesizeClass(this.appView, feedback);
            result.put(group, lambdaGroupClass);
        }
        return result;
    }

    private void removeTrivialLambdaGroups() {
        Iterator<Map.Entry<LambdaGroupId, LambdaGroup>> iterator2 = this.groups.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<LambdaGroupId, LambdaGroup> group = iterator2.next();
            if (!group.getValue().isTrivial()) continue;
            iterator2.remove();
            assert (group.getValue().size() < 2);
            group.getValue().forEachLambda(info -> this.lambdas.remove(info.clazz.type));
        }
    }

    private void rewriteLambdaReferences(IRConverter converter, ExecutorService executorService, OptimizationFeedback feedback) throws ExecutionException {
        if (this.methodsToReprocess.isEmpty()) {
            return;
        }
        Set<DexEncodedMethod> methods = this.methodsToReprocess.stream().map(method -> this.appView.graphLense().mapDexEncodedMethod((DexEncodedMethod)method, this.appView)).collect(Collectors.toSet());
        converter.processMethodsConcurrently(methods, executorService);
        assert (methods.stream().allMatch(DexEncodedMethod::isProcessed));
    }

    private void analyzeClass(DexProgramClass clazz) {
        this.lambdaInvalidator.accept(clazz.superType);
        this.lambdaInvalidator.accept(clazz.interfaces);
        this.lambdaInvalidator.accept(clazz.annotations);
        for (DexEncodedField field : clazz.staticFields()) {
            this.lambdaInvalidator.accept(field.annotations);
            if (field.field.type == clazz.type) continue;
            this.lambdaInvalidator.accept(field.field, clazz.type);
        }
        for (DexEncodedField field : clazz.instanceFields()) {
            this.lambdaInvalidator.accept(field.annotations);
            this.lambdaInvalidator.accept(field.field, clazz.type);
        }
        for (DexEncodedMethod method : clazz.directMethods()) {
            this.lambdaInvalidator.accept(method.annotations);
            this.lambdaInvalidator.accept(method.parameterAnnotationsList);
            this.lambdaInvalidator.accept(method.method, clazz.type);
        }
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            this.lambdaInvalidator.accept(method.annotations);
            this.lambdaInvalidator.accept(method.parameterAnnotationsList);
            this.lambdaInvalidator.accept(method.method, clazz.type);
        }
    }

    private CodeProcessor.Strategy strategyProvider(DexType type) {
        LambdaGroup group = this.getLambdaGroup(type);
        return group != null ? group.getCodeStrategy() : CodeProcessor.NoOp;
    }

    private final class LambdaMergerOptimizationInfoFixer
    implements Function<DexType, DexType>,
    OptimizationFeedback.OptimizationInfoFixer {
        private final Map<LambdaGroup, DexProgramClass> lambdaGroupsClasses;

        LambdaMergerOptimizationInfoFixer(Map<LambdaGroup, DexProgramClass> lambdaGroupsClasses) {
            this.lambdaGroupsClasses = lambdaGroupsClasses;
        }

        @Override
        public DexType apply(DexType type) {
            DexProgramClass clazz;
            LambdaGroup group = (LambdaGroup)LambdaMerger.this.lambdas.get(type);
            if (group != null && (clazz = this.lambdaGroupsClasses.get(group)) != null) {
                return clazz.type;
            }
            return type;
        }

        @Override
        public void fixup(DexEncodedField field) {
            FieldOptimizationInfo optimizationInfo = field.getOptimizationInfo();
            if (optimizationInfo.isMutableFieldOptimizationInfo()) {
                optimizationInfo.asMutableFieldOptimizationInfo().fixupClassTypeReferences(this, LambdaMerger.this.appView);
            } else assert (optimizationInfo.isDefaultFieldOptimizationInfo());
        }

        @Override
        public void fixup(DexEncodedMethod method) {
            MethodOptimizationInfo optimizationInfo = method.getOptimizationInfo();
            if (optimizationInfo.isUpdatableMethodOptimizationInfo()) {
                optimizationInfo.asUpdatableMethodOptimizationInfo().fixupClassTypeReferences(this, LambdaMerger.this.appView);
            } else assert (optimizationInfo.isDefaultMethodOptimizationInfo());
        }
    }

    public final class ApplyStrategy
    extends CodeProcessor {
        private final LambdaMergerOptimizationInfoFixer optimizationInfoFixer;
        private final Set<Value> typeAffectedValues;

        private ApplyStrategy(DexEncodedMethod method, IRCode code, DexEncodedMethod context, LambdaMergerOptimizationInfoFixer optimizationInfoFixer) {
            super(LambdaMerger.this.appView, (DexType x$0) -> LambdaMerger.this.strategyProvider(x$0), LambdaMerger.this.lambdaChecker, method, code, context);
            this.typeAffectedValues = Sets.newIdentityHashSet();
            this.optimizationInfoFixer = optimizationInfoFixer;
        }

        public void recordTypeHasChanged(Value value) {
            for (Value affectedValue : value.affectedValues()) {
                if (!this.typeMayHaveChanged(affectedValue)) continue;
                this.typeAffectedValues.add(affectedValue);
            }
        }

        @Override
        void processCode() {
            super.processCode();
            if (this.typeAffectedValues.isEmpty()) {
                return;
            }
            Set<Value> transitivelyTypeAffectedValues = SetUtils.newIdentityHashSet(this.typeAffectedValues);
            ArrayDeque<Value> worklist = new ArrayDeque<Value>(this.typeAffectedValues);
            while (!worklist.isEmpty()) {
                Value value = (Value)worklist.pop();
                assert (this.typeMayHaveChanged(value));
                assert (transitivelyTypeAffectedValues.contains(value));
                for (Value affectedValue : value.affectedValues()) {
                    if (!this.typeMayHaveChanged(affectedValue) || !transitivelyTypeAffectedValues.add(affectedValue)) continue;
                    worklist.add(affectedValue);
                }
            }
            for (Value value : transitivelyTypeAffectedValues) {
                value.setTypeLattice(value.getTypeLattice().fixupClassTypeReferences(this.optimizationInfoFixer, this.appView));
            }
            Set<Phi> typeAffectedPhis = Sets.newIdentityHashSet();
            for (Value typeAffectedValue : transitivelyTypeAffectedValues) {
                if (!typeAffectedValue.isPhi()) continue;
                typeAffectedPhis.add(typeAffectedValue.asPhi());
            }
            if (!typeAffectedPhis.isEmpty()) {
                new DestructivePhiTypeUpdater(this.appView, this.optimizationInfoFixer).recomputeAndPropagateTypes(this.code, typeAffectedPhis);
            }
            assert (this.code.verifyTypes(this.appView));
        }

        private boolean typeMayHaveChanged(Value value) {
            return value.isPhi() || !value.definition.hasInvariantOutType();
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InvokeMethod invokeMethod) {
            strategy.patch(this, invokeMethod);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, NewInstance newInstance) {
            strategy.patch(this, newInstance);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstancePut instancePut) {
            throw new Unreachable();
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstanceGet instanceGet) {
            strategy.patch(this, instanceGet);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticPut staticPut) {
            throw new Unreachable();
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticGet staticGet) {
            strategy.patch(this, staticGet);
        }
    }

    private final class AnalysisStrategy
    extends CodeProcessor {
        private AnalysisStrategy(DexEncodedMethod method, IRCode code) {
            super(LambdaMerger.this.appView, x$0 -> LambdaMerger.this.strategyProvider(x$0), LambdaMerger.this.lambdaInvalidator, method, code);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InvokeMethod invokeMethod) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, NewInstance newInstance) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstancePut instancePut) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstanceGet instanceGet) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticPut staticPut) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticGet staticGet) {
            LambdaMerger.this.queueForProcessing(this.method);
        }
    }

    private class ApplyMode
    extends Mode {
        private final Map<DexProgramClass, LambdaGroup> lambdaGroups;
        private final LambdaMergerOptimizationInfoFixer optimizationInfoFixer;

        ApplyMode(Map<DexProgramClass, LambdaGroup> lambdaGroups, LambdaMergerOptimizationInfoFixer optimizationInfoFixer) {
            this.lambdaGroups = lambdaGroups;
            this.optimizationInfoFixer = optimizationInfoFixer;
        }

        @Override
        void rewriteCode(DexEncodedMethod method, IRCode code, Inliner inliner, DexEncodedMethod context) {
            DexProgramClass clazz = LambdaMerger.this.appView.definitionFor(method.method.holder).asProgramClass();
            assert (clazz != null);
            LambdaGroup lambdaGroup = this.lambdaGroups.get(clazz);
            if (lambdaGroup == null) {
                new ApplyStrategy(method, code, context, this.optimizationInfoFixer).processCode();
                return;
            }
            if (method.isInitializer()) {
                return;
            }
            assert (method.isNonPrivateVirtualMethod());
            assert (context == null);
            IdentityHashMap<InvokeVirtual, Inliner.InliningInfo> invokesToInline = new IdentityHashMap<InvokeVirtual, Inliner.InliningInfo>();
            for (InvokeVirtual invoke : code.instructions(Instruction::isInvokeVirtual)) {
                DexType holder = invoke.getInvokedMethod().holder;
                if (!lambdaGroup.containsLambda(holder)) continue;
                DexEncodedMethod singleTarget = invoke.lookupSingleTarget(LambdaMerger.this.appView, method.method.holder);
                assert (singleTarget != null);
                invokesToInline.put(invoke, new Inliner.InliningInfo(singleTarget, singleTarget.method.holder));
            }
            assert (invokesToInline.size() > 1);
            inliner.performForcedInlining(method, code, invokesToInline);
        }
    }

    private class AnalyzeMode
    extends Mode {
        private AnalyzeMode() {
        }

        @Override
        void analyzeCode(DexEncodedMethod method, IRCode code) {
            new AnalysisStrategy(method, code).processCode();
        }
    }

    private static abstract class Mode {
        private Mode() {
        }

        void rewriteCode(DexEncodedMethod method, IRCode code, Inliner inliner, DexEncodedMethod context) {
        }

        void analyzeCode(DexEncodedMethod method, IRCode code) {
        }
    }
}

