/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.AccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.CaptureSignature;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin.JStyleLambdaGroupIdFactory;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin.KStyleLambdaGroupIdFactory;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaConstants;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public abstract class KotlinLambdaGroupIdFactory
implements KotlinLambdaConstants {
    KotlinLambdaGroupIdFactory() {
    }

    public static LambdaGroupId create(Kotlin kotlin, DexClass lambda2, InternalOptions options) throws LambdaGroup.LambdaStructureError {
        assert (lambda2.hasKotlinInfo() && lambda2.getKotlinInfo().isSyntheticClass());
        if (lambda2.getKotlinInfo().asSyntheticClass().isKotlinStyleLambda()) {
            return KStyleLambdaGroupIdFactory.INSTANCE.validateAndCreate(kotlin, lambda2, options);
        }
        assert (lambda2.getKotlinInfo().asSyntheticClass().isJavaStyleLambda());
        return JStyleLambdaGroupIdFactory.INSTANCE.validateAndCreate(kotlin, lambda2, options);
    }

    abstract LambdaGroupId validateAndCreate(Kotlin var1, DexClass var2, InternalOptions var3) throws LambdaGroup.LambdaStructureError;

    abstract void validateSuperclass(Kotlin var1, DexClass var2) throws LambdaGroup.LambdaStructureError;

    abstract DexType validateInterfaces(Kotlin var1, DexClass var2) throws LambdaGroup.LambdaStructureError;

    DexEncodedMethod validateVirtualMethods(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        DexEncodedMethod mainMethod = null;
        for (DexEncodedMethod method : lambda2.virtualMethods()) {
            if (method.accessFlags.materialize() == MAIN_METHOD_FLAGS.materialize()) {
                if (mainMethod != null) {
                    throw new LambdaGroup.LambdaStructureError("more than one main method found");
                }
                mainMethod = method;
                continue;
            }
            KotlinLambdaGroupIdFactory.checkAccessFlags((String)"unexpected virtual method access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{BRIDGE_METHOD_FLAGS, BRIDGE_METHOD_FLAGS_FIXED});
            this.checkDirectMethodAnnotations(method);
        }
        if (mainMethod == null) {
            throw new LambdaGroup.LambdaStructureError("no main method found", false);
        }
        return mainMethod;
    }

    InnerClassAttribute validateInnerClasses(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        List<InnerClassAttribute> innerClasses = lambda2.getInnerClasses();
        if (innerClasses != null) {
            for (InnerClassAttribute inner : innerClasses) {
                if (inner.getInner() != lambda2.type) continue;
                if (!inner.isAnonymous()) {
                    throw new LambdaGroup.LambdaStructureError("is not anonymous");
                }
                return inner;
            }
        }
        return null;
    }

    public static boolean hasValidAnnotations(Kotlin kotlin, DexClass lambda2) {
        if (!lambda2.annotations.isEmpty()) {
            for (DexAnnotation annotation : lambda2.annotations.annotations) {
                if (DexAnnotation.isSignatureAnnotation(annotation, kotlin.factory) || annotation.annotation.type == kotlin.metadata.kotlinMetadataType) continue;
                return false;
            }
        }
        return true;
    }

    String validateAnnotations(Kotlin kotlin, DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        String signature = null;
        if (!lambda2.annotations.isEmpty()) {
            for (DexAnnotation annotation : lambda2.annotations.annotations) {
                if (DexAnnotation.isSignatureAnnotation(annotation, kotlin.factory)) {
                    signature = DexAnnotation.getSignature(annotation);
                    continue;
                }
                if (annotation.annotation.type == kotlin.metadata.kotlinMetadataType) continue;
                assert (!KotlinLambdaGroupIdFactory.hasValidAnnotations(kotlin, lambda2));
                throw new LambdaGroup.LambdaStructureError("unexpected annotation: " + annotation.annotation.type.toSourceString());
            }
        }
        assert (KotlinLambdaGroupIdFactory.hasValidAnnotations(kotlin, lambda2));
        return signature;
    }

    void validateStaticFields(Kotlin kotlin, DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        List<DexEncodedField> staticFields = lambda2.staticFields();
        if (staticFields.size() == 1) {
            DexEncodedField field = staticFields.get(0);
            if (!(field.field.name == kotlin.functional.kotlinStyleLambdaInstanceName && field.field.type == lambda2.type && field.accessFlags.isPublic() && field.accessFlags.isFinal() && field.accessFlags.isStatic())) {
                throw new LambdaGroup.LambdaStructureError("unexpected static field " + field.toSourceString());
            }
            if (lambda2.instanceFields().size() > 0) {
                throw new LambdaGroup.LambdaStructureError("has instance fields along with INSTANCE");
            }
            KotlinLambdaGroupIdFactory.checkAccessFlags((String)"static field access flags", (AccessFlags)field.accessFlags, (AccessFlags[])new FieldAccessFlags[]{SINGLETON_FIELD_FLAGS});
            KotlinLambdaGroupIdFactory.checkFieldAnnotations(field);
        } else if (staticFields.size() > 1) {
            throw new LambdaGroup.LambdaStructureError("only one static field max expected, found " + staticFields.size());
        }
    }

    String validateInstanceFields(DexClass lambda2, boolean accessRelaxed) throws LambdaGroup.LambdaStructureError {
        List<DexEncodedField> instanceFields = lambda2.instanceFields();
        for (DexEncodedField field : instanceFields) {
            KotlinLambdaGroupIdFactory.checkAccessFlags((String)"capture field access flags", (AccessFlags)field.accessFlags, (AccessFlags[])new FieldAccessFlags[]{accessRelaxed ? CAPTURE_FIELD_FLAGS_RELAXED : CAPTURE_FIELD_FLAGS});
            KotlinLambdaGroupIdFactory.checkFieldAnnotations(field);
        }
        return CaptureSignature.getCaptureSignature(instanceFields);
    }

    void validateDirectMethods(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        for (DexEncodedMethod method : lambda2.directMethods()) {
            if (method.isClassInitializer()) {
                if (lambda2.staticFields().size() != 1) {
                    throw new LambdaGroup.LambdaStructureError("has static initializer, but no singleton field");
                }
                KotlinLambdaGroupIdFactory.checkAccessFlags((String)"unexpected static initializer access flags", (int)method.accessFlags.getOriginalAccessFlags(), (AccessFlags[])new MethodAccessFlags[]{CLASS_INITIALIZER_FLAGS});
                this.checkDirectMethodAnnotations(method);
                continue;
            }
            if (method.isStatic()) {
                throw new LambdaGroup.LambdaStructureError("unexpected static method: " + method.method.toSourceString());
            }
            if (method.isInstanceInitializer()) {
                DexType[] parameters = method.method.proto.parameters.values;
                List<DexEncodedField> instanceFields = lambda2.instanceFields();
                if (parameters.length != instanceFields.size()) {
                    throw new LambdaGroup.LambdaStructureError("constructor parameters don't match captured values.");
                }
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i] == instanceFields.get((int)i).field.type) continue;
                    throw new LambdaGroup.LambdaStructureError("constructor parameters don't match captured values.", false);
                }
                KotlinLambdaGroupIdFactory.checkAccessFlags((String)"unexpected constructor access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{CONSTRUCTOR_FLAGS, CONSTRUCTOR_FLAGS_RELAXED});
                this.checkDirectMethodAnnotations(method);
                continue;
            }
            if (method.isPrivateMethod()) {
                throw new LambdaGroup.LambdaStructureError("private method: " + method.method.toSourceString());
            }
            assert (false);
            throw new LambdaGroup.LambdaStructureError("unexpected method encountered: " + method.method.toSourceString());
        }
    }

    void checkDirectMethodAnnotations(DexEncodedMethod method) throws LambdaGroup.LambdaStructureError {
        if (!method.annotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected method annotations [" + method.annotations.toSmaliString() + "] on " + method.method.toSourceString());
        }
        if (!method.parameterAnnotationsList.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected method parameters annotations [" + method.annotations.toSmaliString() + "] on " + method.method.toSourceString());
        }
    }

    private static void checkFieldAnnotations(DexEncodedField field) throws LambdaGroup.LambdaStructureError {
        if (!field.annotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected field annotations [" + field.annotations.toSmaliString() + "] on " + field.field.toSourceString());
        }
    }

    @SafeVarargs
    static <T extends AccessFlags> void checkAccessFlags(String message, T actual, T ... expected) throws LambdaGroup.LambdaStructureError {
        KotlinLambdaGroupIdFactory.checkAccessFlags((String)message, (int)actual.materialize(), expected);
    }

    @SafeVarargs
    static <T extends AccessFlags> void checkAccessFlags(String message, int actual, T ... expected) throws LambdaGroup.LambdaStructureError {
        for (T flag : expected) {
            if (actual != ((AccessFlags)flag).materialize()) continue;
            return;
        }
        throw new LambdaGroup.LambdaStructureError(message);
    }
}

