/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Match;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.PeepholeExpression;

public class PeepholeLayout {
    private List<List<Instruction>> instructions;
    private final PeepholeExpression[] expressions;
    private final boolean backwards;

    private PeepholeLayout(boolean backwards, PeepholeExpression ... expressions) {
        this.instructions = new ArrayList<List<Instruction>>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            this.instructions.add(new ArrayList());
            expressions[i].setIndex(i);
        }
        this.backwards = backwards;
        this.expressions = expressions;
    }

    public static PeepholeLayout lookForward(PeepholeExpression ... expressions) {
        return new PeepholeLayout(false, expressions);
    }

    public static PeepholeLayout lookBackward(PeepholeExpression ... expressions) {
        return new PeepholeLayout(true, expressions);
    }

    public Match test(InstructionListIterator it) {
        if (this.backwards) {
            return this.testDirection(() -> it.hasPrevious(), () -> (Instruction)it.previous(), () -> {
                Instruction cfr_ignored_0 = (Instruction)it.next();
            });
        }
        return this.testDirection(() -> it.hasNext(), () -> (Instruction)it.next(), () -> {
            Instruction cfr_ignored_0 = (Instruction)it.previous();
        });
    }

    private Match testDirection(Supplier<Boolean> hasNextInstruction, Supplier<Instruction> nextInstruction, Runnable resetOne) {
        int index;
        if (!hasNextInstruction.get().booleanValue()) {
            return null;
        }
        boolean success = true;
        Instruction current = nextInstruction.get();
        for (index = 0; index < this.expressions.length; ++index) {
            PeepholeExpression e = this.expressions[index];
            List<Instruction> expInstructions = this.instructions.get(index);
            expInstructions.clear();
            if (current != null) {
                for (int i = 0; i < e.getMax() && e.getPredicate().test(current); ++i) {
                    expInstructions.add(current);
                    if (!hasNextInstruction.get().booleanValue()) {
                        current = null;
                        break;
                    }
                    current = nextInstruction.get();
                }
            }
            if (!(success &= expInstructions.size() >= e.getMin() && expInstructions.size() <= e.getMax())) break;
        }
        for (int i = 0; i < index; ++i) {
            for (int j = 0; j < this.instructions.get(i).size(); ++j) {
                resetOne.run();
            }
        }
        if (current != null) {
            resetOne.run();
        }
        return success ? new Match(this.expressions, this.instructions) : null;
    }
}

