/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.staticizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.CodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.staticizer.ClassStaticizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.staticizer.ClassStaticizerGraphLense;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

final class StaticizingProcessor {
    private final AppView<AppInfoWithLiveness> appView;
    private final ClassStaticizer classStaticizer;
    private final IRConverter converter;
    private final Map<DexEncodedMethod, ImmutableList.Builder<Consumer<IRCode>>> processingQueue = new IdentityHashMap<DexEncodedMethod, ImmutableList.Builder<Consumer<IRCode>>>();
    private final Set<DexEncodedMethod> referencingExtraMethods = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, ClassStaticizer.CandidateInfo> hostClassInits = new IdentityHashMap<DexEncodedMethod, ClassStaticizer.CandidateInfo>();
    private final Set<DexEncodedMethod> methodsToBeStaticized = Sets.newIdentityHashSet();
    private final Map<DexField, ClassStaticizer.CandidateInfo> singletonFields = new IdentityHashMap<DexField, ClassStaticizer.CandidateInfo>();
    private final Map<DexType, DexType> candidateToHostMapping = new IdentityHashMap<DexType, DexType>();

    StaticizingProcessor(AppView<AppInfoWithLiveness> appView, ClassStaticizer classStaticizer, IRConverter converter) {
        this.appView = appView;
        this.classStaticizer = classStaticizer;
        this.converter = converter;
    }

    final void run(OptimizationFeedback feedback, ExecutorService executorService) throws ExecutionException {
        this.finalEligibilityCheck();
        this.prepareCandidates();
        this.enqueueMethodsWithCodeOptimizations(this.hostClassInits.keySet(), optimizations -> ((ImmutableList.Builder)((ImmutableList.Builder)optimizations.add(this::removeCandidateInstantiation)).add(this::insertAssumeInstructions)).add(this.collectOptimizationInfo(feedback)));
        this.enqueueMethodsWithCodeOptimizations(this.methodsToBeStaticized, optimizations -> optimizations.add(this::removeReferencesToThis));
        this.processMethodsConcurrently(feedback, executorService);
        Set<DexEncodedMethod> methods = this.staticizeMethodSymbols();
        methods.addAll(this.referencingExtraMethods);
        methods.addAll(this.hostClassInits.keySet());
        this.enqueueMethodsWithCodeOptimizations(methods, optimizations -> ((ImmutableList.Builder)((ImmutableList.Builder)optimizations.add(this::rewriteReferences)).add(this::insertAssumeInstructions)).add(this.collectOptimizationInfo(feedback)));
        this.processMethodsConcurrently(feedback, executorService);
    }

    private void finalEligibilityCheck() {
        Set<Phi> visited = Sets.newIdentityHashSet();
        Set<Phi> trivialPhis = Sets.newIdentityHashSet();
        Iterator<Map.Entry<DexType, ClassStaticizer.CandidateInfo>> it = this.classStaticizer.candidates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<DexType, ClassStaticizer.CandidateInfo> entry = it.next();
            DexType candidateType = entry.getKey();
            ClassStaticizer.CandidateInfo info = entry.getValue();
            DexProgramClass candidateClass = info.candidate;
            DexType candidateHostType = info.hostType();
            DexEncodedMethod constructorUsed = info.constructor.get();
            int instancesCreated = info.instancesCreated.get();
            assert (instancesCreated == info.fieldWrites.get());
            assert (instancesCreated <= 1);
            assert (instancesCreated == 0 == (constructorUsed == null));
            if (instancesCreated == 0) {
                it.remove();
                continue;
            }
            assert (candidateClass.instanceFields().size() == 0);
            assert (constructorUsed.isProcessed());
            if (constructorUsed.getOptimizationInfo().mayHaveSideEffects()) {
                it.remove();
                continue;
            }
            DexEncodedMethod classInitializer = candidateClass.getClassInitializer();
            assert (classInitializer != null || candidateType != candidateHostType);
            if (classInitializer != null && candidateType != candidateHostType) {
                it.remove();
                continue;
            }
            if (Streams.stream(candidateClass.methods()).anyMatch(method -> !method.isStatic() && method.shouldNotHaveCode())) {
                it.remove();
                continue;
            }
            boolean fixableThisPointer = true;
            for (DexEncodedMethod method2 : candidateClass.methods()) {
                if (method2.isStatic() || this.factory().isConstructor(method2.method)) continue;
                IRCode code = method2.buildIR(this.appView, this.appView.appInfo().originFor(method2.method.holder));
                assert (code != null);
                Value thisValue = code.getThis();
                assert (thisValue != null);
                visited.clear();
                trivialPhis.clear();
                boolean onlyHasTrivialPhis = this.testAndCollectPhisComposedOfThis(visited, thisValue.uniquePhiUsers(), thisValue, trivialPhis);
                if (!thisValue.hasPhiUsers() || onlyHasTrivialPhis) continue;
                fixableThisPointer = false;
                break;
            }
            if (!fixableThisPointer) {
                it.remove();
                continue;
            }
            boolean fixableFieldReads = true;
            for (DexEncodedMethod method3 : info.referencedFrom) {
                IRCode code = method3.buildIR(this.appView, this.appView.appInfo().originFor(method3.method.holder));
                assert (code != null);
                List singletonFieldReads = Streams.stream(code.instructionIterator()).filter(Instruction::isStaticGet).map(Instruction::asStaticGet).filter(get -> get.getField() == info.singletonField.field).collect(Collectors.toList());
                boolean fixableFieldReadsPerUsage = true;
                for (StaticGet read : singletonFieldReads) {
                    Value dest = read.dest();
                    visited.clear();
                    trivialPhis.clear();
                    boolean onlyHasTrivialPhis = this.testAndCollectPhisComposedOfSameFieldRead(visited, dest.uniquePhiUsers(), read.getField(), trivialPhis);
                    if (!dest.hasPhiUsers() || onlyHasTrivialPhis) continue;
                    fixableFieldReadsPerUsage = false;
                    break;
                }
                if (fixableFieldReadsPerUsage) continue;
                fixableFieldReads = false;
                break;
            }
            if (fixableFieldReads) continue;
            it.remove();
        }
    }

    private void prepareCandidates() {
        Set<DexEncodedMethod> removedInstanceMethods = Sets.newIdentityHashSet();
        for (ClassStaticizer.CandidateInfo candidate : this.classStaticizer.candidates.values()) {
            DexProgramClass candidateClass = candidate.candidate;
            DexClass hostClass = candidate.hostClass();
            DexEncodedMethod hostClassInitializer = hostClass.getClassInitializer();
            assert (hostClassInitializer != null);
            ClassStaticizer.CandidateInfo previous = this.hostClassInits.put(hostClassInitializer, candidate);
            assert (previous == null);
            for (DexEncodedMethod method : candidateClass.methods()) {
                if (method.isStatic()) continue;
                removedInstanceMethods.add(method);
                if (this.factory().isConstructor(method.method)) continue;
                this.methodsToBeStaticized.add(method);
            }
            this.singletonFields.put(candidate.singletonField.field, candidate);
            this.referencingExtraMethods.addAll(candidate.referencedFrom);
        }
        this.referencingExtraMethods.removeAll(removedInstanceMethods);
    }

    private void enqueueMethodsWithCodeOptimizations(Iterable<DexEncodedMethod> methods, Consumer<ImmutableList.Builder<Consumer<IRCode>>> extension) {
        for (DexEncodedMethod method : methods) {
            extension.accept(this.processingQueue.computeIfAbsent(method, ignore -> ImmutableList.builder()));
        }
    }

    private void processMethodsConcurrently(OptimizationFeedback feedback, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.processingQueue.keySet(), method -> this.forEachMethod((DexEncodedMethod)method, this.processingQueue.get(method).build(), feedback), executorService);
        this.processingQueue.clear();
    }

    private void forEachMethod(DexEncodedMethod method, Collection<Consumer<IRCode>> codeOptimizations, OptimizationFeedback feedback) {
        Origin origin = this.appView.appInfo().originFor(method.method.holder);
        IRCode code = method.buildIR(this.appView, origin);
        codeOptimizations.forEach(codeOptimization -> codeOptimization.accept(code));
        CodeRewriter.removeAssumeInstructions(this.appView, code);
        this.converter.finalizeIR(method, code, feedback);
    }

    private void insertAssumeInstructions(IRCode code) {
        CodeRewriter.insertAssumeInstructions(code, this.converter.assumers);
    }

    private Consumer<IRCode> collectOptimizationInfo(OptimizationFeedback feedback) {
        return code -> this.converter.collectOptimizationInfo((IRCode)code, feedback);
    }

    private void removeCandidateInstantiation(IRCode code) {
        ClassStaticizer.CandidateInfo candidateInfo = this.hostClassInits.get(code.method);
        assert (candidateInfo != null);
        for (Instruction instruction : code.instructions()) {
            if (!instruction.isNewInstance() || instruction.asNewInstance().clazz != candidateInfo.candidate.type) continue;
            assert (candidateInfo.candidate.superType == this.factory().objectType);
            assert (candidateInfo.candidate.instanceFields().size() == 0);
            Value singletonValue = instruction.outValue();
            assert (singletonValue != null);
            singletonValue.uniqueUsers().forEach(user -> user.removeOrReplaceByDebugLocalRead(code));
            instruction.removeOrReplaceByDebugLocalRead(code);
            return;
        }
        assert (false) : "Must always be able to find and remove the instantiation";
    }

    private void removeReferencesToThis(IRCode code) {
        this.fixupStaticizedThisUsers(code, code.getThis());
    }

    private void rewriteReferences(IRCode code) {
        List<StaticGet> singletonFieldReads = Streams.stream(code.instructionIterator()).filter(Instruction::isStaticGet).map(Instruction::asStaticGet).filter(get -> this.singletonFields.containsKey(get.getField())).collect(Collectors.toList());
        singletonFieldReads.forEach(read -> {
            DexField field = read.getField();
            ClassStaticizer.CandidateInfo candidateInfo = this.singletonFields.get(field);
            assert (candidateInfo != null);
            Value value = read.dest();
            if (value != null) {
                this.fixupStaticizedFieldReadUsers(code, value, field);
            }
            if (!candidateInfo.preserveRead.get()) {
                read.removeOrReplaceByDebugLocalRead(code);
            }
        });
        if (!this.candidateToHostMapping.isEmpty()) {
            this.remapMovedCandidates(code);
        }
    }

    private boolean testAndCollectPhisComposedOfThis(Set<Phi> visited, Set<Phi> phisToCheck, Value thisValue, Set<Phi> trivialPhis) {
        for (Phi phi : phisToCheck) {
            if (!visited.add(phi)) continue;
            Set<Phi> chainedPhis = Sets.newIdentityHashSet();
            for (Value operand : phi.getOperands()) {
                Value v = operand.getAliasedValue();
                if (v.isPhi()) {
                    chainedPhis.add(operand.asPhi());
                    continue;
                }
                if (v == thisValue) continue;
                return false;
            }
            if (!chainedPhis.isEmpty() && !this.testAndCollectPhisComposedOfThis(visited, chainedPhis, thisValue, trivialPhis)) {
                return false;
            }
            trivialPhis.add(phi);
        }
        return true;
    }

    private void fixupStaticizedThisUsers(IRCode code, Value thisValue) {
        assert (thisValue != null && thisValue == thisValue.getAliasedValue());
        Set<Phi> trivialPhis = Sets.newIdentityHashSet();
        boolean onlyHasTrivialPhis = this.testAndCollectPhisComposedOfThis(Sets.newIdentityHashSet(), thisValue.uniquePhiUsers(), thisValue, trivialPhis);
        assert (!thisValue.hasPhiUsers() || onlyHasTrivialPhis);
        assert (trivialPhis.isEmpty() || onlyHasTrivialPhis);
        Set<Instruction> users = SetUtils.newIdentityHashSet(thisValue.aliasedUsers());
        for (Phi phi : trivialPhis) {
            users.addAll(phi.aliasedUsers());
        }
        this.fixupStaticizedValueUsers(code, users);
        trivialPhis.forEach(Phi::removeDeadPhi);
        assert (!thisValue.hasUsers() && !thisValue.hasPhiUsers());
    }

    private boolean testAndCollectPhisComposedOfSameFieldRead(Set<Phi> visited, Set<Phi> phisToCheck, DexField field, Set<Phi> trivialPhis) {
        for (Phi phi : phisToCheck) {
            if (!visited.add(phi)) continue;
            Set<Phi> chainedPhis = Sets.newIdentityHashSet();
            for (Value operand : phi.getOperands()) {
                Value v = operand.getAliasedValue();
                if (v.isPhi()) {
                    chainedPhis.add(operand.asPhi());
                    continue;
                }
                if (!v.definition.isStaticGet()) {
                    return false;
                }
                if (v.definition.asStaticGet().getField() == field) continue;
                return false;
            }
            if (!chainedPhis.isEmpty() && !this.testAndCollectPhisComposedOfSameFieldRead(visited, chainedPhis, field, trivialPhis)) {
                return false;
            }
            trivialPhis.add(phi);
        }
        return true;
    }

    private void fixupStaticizedFieldReadUsers(IRCode code, Value dest, DexField field) {
        assert (dest != null);
        Set<Phi> trivialPhis = Sets.newIdentityHashSet();
        boolean onlyHasTrivialPhis = this.testAndCollectPhisComposedOfSameFieldRead(Sets.newIdentityHashSet(), dest.uniquePhiUsers(), field, trivialPhis);
        assert (!dest.hasPhiUsers() || onlyHasTrivialPhis);
        assert (trivialPhis.isEmpty() || onlyHasTrivialPhis);
        Set<Instruction> users = SetUtils.newIdentityHashSet(dest.aliasedUsers());
        for (Phi phi : trivialPhis) {
            users.addAll(phi.aliasedUsers());
        }
        this.fixupStaticizedValueUsers(code, users);
        trivialPhis.forEach(Phi::removeDeadPhi);
        assert (!dest.hasUsers() && !dest.hasPhiUsers());
    }

    private void fixupStaticizedValueUsers(IRCode code, Set<Instruction> users) {
        for (Instruction user : users) {
            if (user.isAssume()) continue;
            assert (user.isInvokeVirtual() || user.isInvokeDirect());
            InvokeMethodWithReceiver invoke = user.asInvokeMethodWithReceiver();
            Value newValue = null;
            Value outValue = invoke.outValue();
            if (outValue != null) {
                newValue = code.createValue(outValue.getTypeLattice());
                DebugLocalInfo localInfo = outValue.getLocalInfo();
                if (localInfo != null) {
                    newValue.setLocalInfo(localInfo);
                }
            }
            List<Value> args = invoke.inValues();
            invoke.replace(new InvokeStatic(invoke.getInvokedMethod(), newValue, args.subList(1, args.size())), code);
        }
    }

    private void remapMovedCandidates(IRCode code) {
        InstructionListIterator it = code.instructionListIterator();
        while (it.hasNext()) {
            DexField field;
            Instruction instruction = (Instruction)it.next();
            if (instruction.isStaticGet()) {
                StaticGet staticGet = instruction.asStaticGet();
                field = this.mapFieldIfMoved(staticGet.getField());
                if (field == staticGet.getField()) continue;
                Value outValue = staticGet.dest();
                assert (outValue != null);
                it.replaceCurrentInstruction(new StaticGet(code.createValue(TypeLatticeElement.fromDexType(field.type, outValue.getTypeLattice().nullability(), this.appView), outValue.getLocalInfo()), field));
                continue;
            }
            if (instruction.isStaticPut()) {
                StaticPut staticPut = instruction.asStaticPut();
                field = this.mapFieldIfMoved(staticPut.getField());
                if (field == staticPut.getField()) continue;
                it.replaceCurrentInstruction(new StaticPut(staticPut.value(), field));
                continue;
            }
            if (!instruction.isInvokeStatic()) continue;
            InvokeStatic invoke = instruction.asInvokeStatic();
            DexMethod method = invoke.getInvokedMethod();
            DexType hostType = this.candidateToHostMapping.get(method.holder);
            if (hostType == null) continue;
            DexMethod newMethod = this.factory().createMethod(hostType, method.proto, method.name);
            Value outValue = invoke.outValue();
            DexType returnType = method.proto.returnType;
            Value newOutValue = returnType.isVoidType() || outValue == null ? null : code.createValue(TypeLatticeElement.fromDexType(returnType, outValue.getTypeLattice().nullability(), this.appView), outValue.getLocalInfo());
            it.replaceCurrentInstruction(new InvokeStatic(newMethod, newOutValue, invoke.inValues()));
        }
    }

    private DexField mapFieldIfMoved(DexField field) {
        DexType hostType = this.candidateToHostMapping.get(field.holder);
        if (hostType != null) {
            field = this.factory().createField(hostType, field.type, field.name);
        }
        if ((hostType = this.candidateToHostMapping.get(field.type)) != null) {
            field = this.factory().createField(field.holder, hostType, field.name);
        }
        return field;
    }

    private Set<DexEncodedMethod> staticizeMethodSymbols() {
        HashBiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
        HashBiMap<DexField, DexField> fieldMapping = HashBiMap.create();
        Set<DexEncodedMethod> staticizedMethods = Sets.newIdentityHashSet();
        for (ClassStaticizer.CandidateInfo candidate : this.classStaticizer.candidates.values()) {
            DexProgramClass candidateClass = candidate.candidate;
            ArrayList<DexEncodedMethod> newDirectMethods = new ArrayList<DexEncodedMethod>();
            for (DexEncodedMethod method : candidateClass.methods()) {
                if (method.isStatic()) {
                    newDirectMethods.add(method);
                    continue;
                }
                if (this.factory().isConstructor(method.method)) continue;
                DexEncodedMethod staticizedMethod = method.toStaticMethodWithoutThis();
                newDirectMethods.add(staticizedMethod);
                staticizedMethods.add(staticizedMethod);
                methodMapping.put(method.method, staticizedMethod.method);
            }
            candidateClass.setVirtualMethods(DexEncodedMethod.EMPTY_ARRAY);
            candidateClass.setDirectMethods(newDirectMethods.toArray(DexEncodedMethod.EMPTY_ARRAY));
            DexType hostType = candidate.hostType();
            if (candidateClass.type == hostType) continue;
            DexClass hostClass = this.appView.definitionFor(hostType);
            assert (hostClass != null);
            if (this.classMembersConflict(candidateClass, hostClass)) continue;
            this.moveMembersIntoHost(staticizedMethods, candidateClass, hostType, hostClass, methodMapping, fieldMapping);
        }
        if (!methodMapping.isEmpty() || !fieldMapping.isEmpty()) {
            this.appView.setGraphLense(new ClassStaticizerGraphLense(this.appView, fieldMapping, methodMapping));
        }
        return staticizedMethods;
    }

    private boolean classMembersConflict(DexClass a, DexClass b) {
        assert (Streams.stream(a.methods()).allMatch(DexEncodedMethod::isStatic));
        assert (a.instanceFields().size() == 0);
        return a.staticFields().stream().anyMatch(fld -> b.lookupField(fld.field) != null) || Streams.stream(a.methods()).anyMatch(method -> b.lookupMethod(method.method) != null);
    }

    private void moveMembersIntoHost(Set<DexEncodedMethod> staticizedMethods, DexProgramClass candidateClass, DexType hostType, DexClass hostClass, BiMap<DexMethod, DexMethod> methodMapping, BiMap<DexField, DexField> fieldMapping) {
        this.candidateToHostMapping.put(candidateClass.type, hostType);
        int numOfHostStaticFields = hostClass.staticFields().size();
        DexEncodedField[] newFields = candidateClass.staticFields().size() > 0 ? new DexEncodedField[numOfHostStaticFields + candidateClass.staticFields().size()] : new DexEncodedField[numOfHostStaticFields];
        List<DexEncodedField> oldFields = hostClass.staticFields();
        for (int i = 0; i < oldFields.size(); ++i) {
            DexEncodedField field = oldFields.get(i);
            DexField newField = this.mapCandidateField(field.field, candidateClass.type, hostType);
            if (newField != field.field) {
                newFields[i] = field.toTypeSubstitutedField(newField);
                fieldMapping.put(field.field, newField);
                continue;
            }
            newFields[i] = field;
        }
        if (candidateClass.staticFields().size() > 0) {
            List<DexEncodedField> extraFields = candidateClass.staticFields();
            for (int i = 0; i < extraFields.size(); ++i) {
                DexEncodedField field = extraFields.get(i);
                DexField newField = this.mapCandidateField(field.field, candidateClass.type, hostType);
                if (newField != field.field) {
                    newFields[numOfHostStaticFields + i] = field.toTypeSubstitutedField(newField);
                    fieldMapping.put(field.field, newField);
                    continue;
                }
                newFields[numOfHostStaticFields + i] = field;
            }
        }
        hostClass.setStaticFields(newFields);
        List<DexEncodedMethod> extraMethods = candidateClass.directMethods();
        if (!extraMethods.isEmpty()) {
            ArrayList<DexEncodedMethod> newMethods = new ArrayList<DexEncodedMethod>(extraMethods.size());
            for (DexEncodedMethod method : extraMethods) {
                DexMethod originalMethod;
                DexEncodedMethod newMethod = method.toTypeSubstitutedMethod(this.factory().createMethod(hostType, method.method.proto, method.method.name));
                newMethods.add(newMethod);
                if (staticizedMethods.remove(method)) {
                    staticizedMethods.add(newMethod);
                }
                if ((originalMethod = (DexMethod)methodMapping.inverse().get(method.method)) == null) {
                    methodMapping.put(method.method, newMethod.method);
                    continue;
                }
                methodMapping.put(originalMethod, newMethod.method);
            }
            hostClass.appendDirectMethods(newMethods);
        }
    }

    private DexField mapCandidateField(DexField field, DexType candidateType, DexType hostType) {
        return field.holder != candidateType && field.type != candidateType ? field : this.factory().createField(field.holder == candidateType ? hostType : field.holder, field.type == candidateType ? hostType : field.type, field.name);
    }

    private DexItemFactory factory() {
        return this.appView.dexItemFactory();
    }
}

