/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.kotlin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmPackage;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinInfo;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinMetadataSynthesizer;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public final class KotlinClassPart
extends KotlinInfo<KotlinClassMetadata.MultiFileClassPart> {
    private KmPackage kmPackage;

    static KotlinClassPart fromKotlinClassMetadata(KotlinClassMetadata kotlinClassMetadata, DexClass clazz) {
        assert (kotlinClassMetadata instanceof KotlinClassMetadata.MultiFileClassPart);
        KotlinClassMetadata.MultiFileClassPart multiFileClassPart = (KotlinClassMetadata.MultiFileClassPart)kotlinClassMetadata;
        return new KotlinClassPart(multiFileClassPart, clazz);
    }

    private KotlinClassPart(KotlinClassMetadata.MultiFileClassPart metadata, DexClass clazz) {
        super(metadata, clazz);
    }

    @Override
    void processMetadata() {
        assert (!this.isProcessed);
        this.isProcessed = true;
        this.kmPackage = ((KotlinClassMetadata.MultiFileClassPart)this.metadata).toKmPackage();
    }

    @Override
    void rewrite(AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        if (!appView.options().enableKotlinMetadataRewriting) {
            return;
        }
        List<KmFunction> functions = this.kmPackage.getFunctions();
        List<KmFunction> originalExtensions = functions.stream().filter(KotlinMetadataSynthesizer::isExtension).collect(Collectors.toList());
        functions.clear();
        for (Map.Entry<DexEncodedMethod, KmFunction> entry : this.clazz.kotlinExtensions(originalExtensions, appView).entrySet()) {
            KmFunction extension = KotlinMetadataSynthesizer.toRenamedKmFunctionAsExtension(entry.getKey(), entry.getValue(), appView, lens);
            if (extension == null) continue;
            functions.add(extension);
        }
    }

    @Override
    KotlinClassHeader createHeader() {
        KotlinClassMetadata.MultiFileClassPart.Writer writer = new KotlinClassMetadata.MultiFileClassPart.Writer();
        this.kmPackage.accept(writer);
        return writer.write(((KotlinClassMetadata.MultiFileClassPart)this.metadata).getFacadeClassName()).getHeader();
    }

    @Override
    public KotlinInfo.Kind getKind() {
        return KotlinInfo.Kind.Part;
    }

    @Override
    public boolean isClassPart() {
        return true;
    }

    @Override
    public KotlinClassPart asClassPart() {
        return this;
    }
}

