/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryAPIConverter;
import shadow.bundletool.com.android.tools.r8.naming.InterfaceMethodNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.MemberNamingStrategy;
import shadow.bundletool.com.android.tools.r8.naming.MethodNamingState;
import shadow.bundletool.com.android.tools.r8.naming.MethodReservationState;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

class MethodNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final MemberNamingStrategy strategy;
    private final Map<DexMethod, DexString> renaming = new IdentityHashMap<DexMethod, DexString>();
    private final State minifierState = new State();
    private final BiMap<DexType, MethodReservationState<?>> reservationStates = HashBiMap.create();
    private final Map<DexType, MethodNamingState<?>> namingStates = new HashMap();
    private final Map<DexType, DexType> frontiers = new IdentityHashMap<DexType, DexType>();
    private final MethodNamingState<?> rootNamingState;
    private final MethodReservationState<?> rootReservationState;

    MethodNameMinifier(AppView<AppInfoWithLiveness> appView, MemberNamingStrategy strategy) {
        this.appView = appView;
        this.strategy = strategy;
        this.rootReservationState = MethodReservationState.createRoot(this.getReservationKeyTransform());
        this.rootNamingState = MethodNamingState.createRoot(this.getNamingKeyTransform(), strategy, this.rootReservationState);
        this.namingStates.put(null, this.rootNamingState);
    }

    private Function<DexMethod, ?> getReservationKeyTransform() {
        if (this.appView.options().getProguardConfiguration().isOverloadAggressively() && this.appView.options().isGeneratingClassFiles()) {
            return method -> method.proto;
        }
        return method -> method.proto.parameters;
    }

    private Function<DexMethod, ?> getNamingKeyTransform() {
        return this.appView.options().isGeneratingClassFiles() ? this.getReservationKeyTransform() : method -> null;
    }

    MethodRenaming computeRenaming(Collection<DexClass> interfaces, Set<DexCallSite> desugaredCallSites, Timing timing) {
        timing.begin("Phase 1");
        this.reserveNamesInClasses();
        timing.end();
        timing.begin("Phase 2");
        InterfaceMethodNameMinifier interfaceMethodNameMinifier = new InterfaceMethodNameMinifier(this.appView, desugaredCallSites, this.minifierState);
        timing.end();
        timing.begin("Phase 3");
        interfaceMethodNameMinifier.assignNamesToInterfaceMethods(timing, interfaces);
        timing.end();
        timing.begin("Phase 4");
        this.assignNamesToClassesMethods(this.appView.dexItemFactory().objectType, this.rootNamingState);
        timing.end();
        return new MethodRenaming(this.renaming, interfaceMethodNameMinifier.getCallSiteRenamings());
    }

    private void assignNamesToClassesMethods(DexType type, MethodNamingState<?> parentNamingState) {
        MethodReservationState reservationState = (MethodReservationState)this.reservationStates.get(this.frontiers.getOrDefault(type, type));
        assert (reservationState != null) : "Could not find reservation state for " + type.toString();
        MethodNamingState namingState = this.namingStates.computeIfAbsent(type, ignore -> parentNamingState.createChild(reservationState));
        DexClass holder = this.appView.definitionFor(type);
        if (holder != null && this.strategy.allowMemberRenaming(holder)) {
            for (DexEncodedMethod method : holder.allMethodsSorted()) {
                this.assignNameToMethod(holder, method, namingState);
            }
        }
        for (DexType subType : this.appView.appInfo().allImmediateExtendsSubtypes(type)) {
            this.assignNamesToClassesMethods(subType, namingState);
        }
    }

    private void assignNameToMethod(DexClass holder, DexEncodedMethod encodedMethod, MethodNamingState<?> state) {
        if (encodedMethod.accessFlags.isConstructor()) {
            return;
        }
        DexString newName = this.strategy.getReservedName(encodedMethod, holder);
        if (newName == null || newName == encodedMethod.method.name) {
            newName = state.newOrReservedNameFor(encodedMethod.method);
        }
        if (encodedMethod.method.name != newName) {
            this.renaming.put(encodedMethod.method, newName);
        }
        state.addRenaming(newName, encodedMethod.method);
    }

    private void reserveNamesInClasses() {
        this.reserveNamesInClasses(this.appView.dexItemFactory().objectType, this.appView.dexItemFactory().objectType, this.rootReservationState);
    }

    private void reserveNamesInClasses(DexType type, DexType libraryFrontier, MethodReservationState<?> parentReservationState) {
        assert (this.appView.isInterface(type).isFalse());
        MethodReservationState<?> reservationState = this.allocateReservationStateAndReserve(type, libraryFrontier, parentReservationState);
        DexClass holder = this.appView.definitionFor(type);
        for (DexType subtype : this.appView.appInfo().allImmediateExtendsSubtypes(type)) {
            this.reserveNamesInClasses(subtype, holder == null || holder.isNotProgramClass() ? subtype : libraryFrontier, reservationState);
        }
    }

    private MethodReservationState<?> allocateReservationStateAndReserve(DexType type, DexType frontier, MethodReservationState<?> parent) {
        assert (parent != null);
        if (frontier != type) {
            this.frontiers.put(type, frontier);
        }
        MethodReservationState state = this.reservationStates.computeIfAbsent(frontier, ignore -> parent.createChild());
        DexClass holder = this.appView.definitionFor(type);
        if (holder != null) {
            for (DexEncodedMethod method : MethodNameMinifier.shuffleMethods(holder.methods(), this.appView.options())) {
                DexString reservedName = this.strategy.getReservedName(method, holder);
                if (reservedName == null) continue;
                state.reserveName(reservedName, method.method);
                if (!this.appView.rewritePrefix.hasRewrittenTypeInSignature(method.method.proto)) continue;
                state.reserveName(reservedName, DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(method.method, method.method.holder, this.appView));
            }
        }
        return state;
    }

    private MethodNamingState<?> getOrAllocateMethodNamingStates(DexType type) {
        MethodNamingState<?> namingState = this.namingStates.get(type);
        if (namingState == null) {
            DexClass holder;
            MethodNamingState<?> parentState = type == this.appView.dexItemFactory().objectType ? this.rootNamingState : ((holder = this.appView.definitionFor(type)) == null ? this.getOrAllocateMethodNamingStates(this.appView.dexItemFactory().objectType) : this.getOrAllocateMethodNamingStates(holder.superType));
            MethodReservationState reservationState = (MethodReservationState)this.reservationStates.get(type);
            assert (reservationState != null) : "Could not find reservation state for " + type.toString();
            namingState = parentState.createChild(reservationState);
            this.namingStates.put(type, namingState);
        }
        return namingState;
    }

    private static Iterable<DexEncodedMethod> shuffleMethods(Iterable<DexEncodedMethod> methods, InternalOptions options) {
        return options.testing.irOrdering.order(methods);
    }

    static class MethodRenaming {
        final Map<DexMethod, DexString> renaming;
        final Map<DexCallSite, DexString> callSiteRenaming;

        private MethodRenaming(Map<DexMethod, DexString> renaming, Map<DexCallSite, DexString> callSiteRenaming) {
            this.renaming = renaming;
            this.callSiteRenaming = callSiteRenaming;
        }

        public static MethodRenaming empty() {
            return new MethodRenaming(ImmutableMap.of(), ImmutableMap.of());
        }
    }

    class State {
        State() {
        }

        void putRenaming(DexMethod key, DexString value) {
            MethodNameMinifier.this.renaming.put(key, value);
        }

        MethodReservationState<?> getReservationState(DexType type) {
            return (MethodReservationState)MethodNameMinifier.this.reservationStates.get(type);
        }

        MethodNamingState<?> getNamingState(DexType type) {
            return MethodNameMinifier.this.getOrAllocateMethodNamingStates(type);
        }

        void allocateReservationStateAndReserve(DexType type, DexType frontier) {
            MethodNameMinifier.this.allocateReservationStateAndReserve(type, frontier, MethodNameMinifier.this.rootReservationState);
        }

        DexType getFrontier(DexType type) {
            return MethodNameMinifier.this.frontiers.getOrDefault(type, type);
        }

        DexString getReservedName(DexEncodedMethod method, DexClass holder) {
            return MethodNameMinifier.this.strategy.getReservedName(method, holder);
        }
    }
}

