/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.ir.desugar.PrefixRewritingMapper;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class PrefixRewritingNamingLens
extends NamingLens {
    final Map<DexType, DexString> classRenaming = new IdentityHashMap<DexType, DexString>();
    final NamingLens namingLens;
    final InternalOptions options;

    public static NamingLens createPrefixRewritingNamingLens(InternalOptions options, PrefixRewritingMapper rewritePrefix) {
        return PrefixRewritingNamingLens.createPrefixRewritingNamingLens(options, rewritePrefix, NamingLens.getIdentityLens());
    }

    public static NamingLens createPrefixRewritingNamingLens(InternalOptions options, PrefixRewritingMapper rewritePrefix, NamingLens namingLens) {
        if (!rewritePrefix.isRewriting()) {
            return namingLens;
        }
        return new PrefixRewritingNamingLens(namingLens, options, rewritePrefix);
    }

    public PrefixRewritingNamingLens(NamingLens namingLens, InternalOptions options, PrefixRewritingMapper rewritePrefix) {
        this.namingLens = namingLens;
        this.options = options;
        DexItemFactory itemFactory = options.itemFactory;
        itemFactory.forAllTypes(type -> {
            if (rewritePrefix.hasRewrittenType((DexType)type)) {
                this.classRenaming.put((DexType)type, rewritePrefix.rewrittenType((DexType)type).descriptor);
            }
        });
        assert (namingLens.verifyNoOverlap(this.classRenaming));
    }

    @Override
    public boolean hasPrefixRewritingLogic() {
        return true;
    }

    @Override
    public DexString prefixRewrittenType(DexType type) {
        return this.classRenaming.get(type);
    }

    @Override
    public DexString lookupDescriptor(DexType type) {
        return this.classRenaming.getOrDefault(type, this.namingLens.lookupDescriptor(type));
    }

    @Override
    public DexString lookupInnerName(InnerClassAttribute attribute, InternalOptions options) {
        if (this.classRenaming.containsKey(attribute.getInner())) {
            return attribute.getInnerName();
        }
        return this.namingLens.lookupInnerName(attribute, options);
    }

    @Override
    public DexString lookupName(DexMethod method) {
        if (this.classRenaming.containsKey(method.holder)) {
            return method.name;
        }
        return this.namingLens.lookupName(method);
    }

    @Override
    public DexString lookupMethodName(DexCallSite callSite) {
        if (this.classRenaming.containsKey(callSite.bootstrapMethod.rewrittenTarget.holder)) {
            return callSite.methodName;
        }
        return this.namingLens.lookupMethodName(callSite);
    }

    @Override
    public DexString lookupName(DexField field) {
        if (this.classRenaming.containsKey(field.holder)) {
            return field.name;
        }
        return this.namingLens.lookupName(field);
    }

    @Override
    public boolean verifyNoOverlap(Map<DexType, DexString> map2) {
        throw new Unreachable("Multiple prefix rewriting lens not supported.");
    }

    @Override
    public String lookupPackageName(String packageName) {
        assert (this.verifyNotPrefixRewrittenPackage(packageName));
        return this.namingLens.lookupPackageName(packageName);
    }

    private boolean verifyNotPrefixRewrittenPackage(String packageName) {
        for (DexType dexType : this.classRenaming.keySet()) {
            assert (!dexType.getPackageDescriptor().equals(packageName));
        }
        return true;
    }

    @Override
    public void forAllRenamedTypes(Consumer<DexType> consumer) {
        if (this.options.isDesugaredLibraryCompilation()) {
            this.classRenaming.keySet().forEach(consumer);
        }
        this.namingLens.forAllRenamedTypes(consumer);
    }

    @Override
    public <T extends DexItem> Map<String, T> getRenamedItems(Class<T> clazz, Predicate<T> predicate, Function<T, String> namer) {
        Map renamedItemsPrefixRewritting = clazz == DexType.class ? (Map)this.classRenaming.keySet().stream().filter(item -> predicate.test((DexItem)clazz.cast(item))).map(clazz::cast).collect(ImmutableMap.toImmutableMap(namer, i -> i)) : ImmutableMap.of();
        Map<String, T> renamedItemsMinifier = this.namingLens.getRenamedItems(clazz, predicate, namer);
        return Stream.concat(renamedItemsPrefixRewritting.entrySet().stream(), renamedItemsMinifier.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public boolean checkTargetCanBeTranslated(DexMethod item) {
        return this.namingLens.checkTargetCanBeTranslated(item);
    }
}

