/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming.signature;

import java.lang.reflect.GenericSignatureFormatError;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.signature.GenericSignatureAction;
import shadow.bundletool.com.android.tools.r8.naming.signature.GenericSignatureParser;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class GenericSignatureRewriter {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexType, DexString> renaming;
    private final Reporter reporter;

    public GenericSignatureRewriter(AppView<AppInfoWithLiveness> appView) {
        this(appView, Maps.newIdentityHashMap());
    }

    public GenericSignatureRewriter(AppView<AppInfoWithLiveness> appView, Map<DexType, DexString> renaming) {
        this.appView = appView;
        this.renaming = renaming;
        this.reporter = appView.options().reporter;
    }

    public void run(Iterable<? extends DexProgramClass> classes) {
        GenericSignatureCollector genericSignatureCollector = new GenericSignatureCollector();
        GenericSignatureParser<DexType> genericSignatureParser = new GenericSignatureParser<DexType>(genericSignatureCollector);
        for (DexProgramClass dexProgramClass : classes) {
            genericSignatureCollector.setCurrentClassContext(dexProgramClass);
            dexProgramClass.annotations = this.rewriteGenericSignatures(dexProgramClass.annotations, genericSignatureParser::parseClassSignature, genericSignatureCollector::getRenamedSignature, (signature, e) -> this.parseError(clazz, clazz.getOrigin(), (String)signature, (GenericSignatureFormatError)e));
            dexProgramClass.forEachField(field -> {
                field.annotations = this.rewriteGenericSignatures(field.annotations, genericSignatureParser::parseFieldSignature, genericSignatureCollector::getRenamedSignature, (signature, e) -> this.parseError((DexDefinition)field, clazz.getOrigin(), (String)signature, (GenericSignatureFormatError)e));
            });
            dexProgramClass.forEachMethod(method -> {
                method.annotations = this.rewriteGenericSignatures(method.annotations, genericSignatureParser::parseMethodSignature, genericSignatureCollector::getRenamedSignature, (signature, e) -> this.parseError((DexDefinition)method, clazz.getOrigin(), (String)signature, (GenericSignatureFormatError)e));
            });
        }
    }

    private DexAnnotationSet rewriteGenericSignatures(DexAnnotationSet annotations, Consumer<String> parser, Supplier<String> collector, BiConsumer<String, GenericSignatureFormatError> parseError) {
        int VALID = -1;
        int invalid = -1;
        DexAnnotation[] rewrittenAnnotations = null;
        for (int i = 0; i < annotations.annotations.length && invalid == -1; ++i) {
            DexAnnotation annotation = annotations.annotations[i];
            if (DexAnnotation.isSignatureAnnotation(annotation, this.appView.dexItemFactory())) {
                if (rewrittenAnnotations == null) {
                    rewrittenAnnotations = new DexAnnotation[annotations.annotations.length];
                    System.arraycopy(annotations.annotations, 0, rewrittenAnnotations, 0, i);
                }
                String signature = DexAnnotation.getSignature(annotation);
                try {
                    DexAnnotation signatureAnnotation;
                    parser.accept(signature);
                    rewrittenAnnotations[i] = signatureAnnotation = DexAnnotation.createSignatureAnnotation(collector.get(), this.appView.dexItemFactory());
                }
                catch (GenericSignatureFormatError e) {
                    parseError.accept(signature, e);
                    invalid = i;
                }
                continue;
            }
            if (rewrittenAnnotations == null) continue;
            rewrittenAnnotations[i] = annotation;
        }
        if (invalid == -1) {
            return rewrittenAnnotations != null ? new DexAnnotationSet(rewrittenAnnotations) : annotations;
        }
        DexAnnotation[] prunedAnnotations = new DexAnnotation[annotations.annotations.length - 1];
        int dest = 0;
        for (int i = 0; i < annotations.annotations.length; ++i) {
            if (i == invalid) continue;
            prunedAnnotations[dest++] = annotations.annotations[i];
        }
        assert (dest == prunedAnnotations.length);
        return new DexAnnotationSet(prunedAnnotations);
    }

    private void parseError(DexDefinition item, Origin origin, String signature, GenericSignatureFormatError e) {
        StringBuilder message = new StringBuilder("Invalid signature '");
        message.append(signature);
        message.append("' for ");
        if (item.isDexClass()) {
            message.append("class ");
            message.append(item.asDexClass().getType().toSourceString());
        } else if (item.isDexEncodedField()) {
            message.append("field ");
            message.append(item.toSourceString());
        } else {
            assert (item.isDexEncodedMethod());
            message.append("method ");
            message.append(item.toSourceString());
        }
        message.append(".\n");
        message.append("Signature is ignored and will not be present in the output.\n");
        message.append("Parser error: ");
        message.append(e.getMessage());
        this.reporter.warning(new StringDiagnostic(message.toString(), origin));
    }

    private class GenericSignatureCollector
    implements GenericSignatureAction<DexType> {
        private StringBuilder renamedSignature;
        private DexProgramClass currentClassContext;
        private DexType lastWrittenType = null;

        private GenericSignatureCollector() {
        }

        String getRenamedSignature() {
            return this.renamedSignature.toString();
        }

        void setCurrentClassContext(DexProgramClass clazz) {
            this.currentClassContext = clazz;
        }

        @Override
        public void parsedSymbol(char symbol) {
            if (symbol == ';' && this.lastWrittenType == null) {
                return;
            }
            if (symbol == '>' && this.removeWrittenCharacter(c -> c.charValue() == '<')) {
                return;
            }
            this.renamedSignature.append(symbol);
        }

        @Override
        public void parsedIdentifier(String identifier) {
            this.renamedSignature.append(identifier);
        }

        @Override
        public DexType parsedTypeName(String name, GenericSignatureAction.ParserPosition parserPosition) {
            DexString classDescriptor;
            if (parserPosition == GenericSignatureAction.ParserPosition.ENCLOSING_INNER_OR_TYPE_ANNOTATION && this.lastWrittenType == null) {
                this.removeWrittenClassCharacter();
                return null;
            }
            String originalDescriptor = DescriptorUtils.getDescriptorFromClassBinaryName(name);
            DexType type = GenericSignatureRewriter.this.appView.graphLense().lookupType(GenericSignatureRewriter.this.appView.dexItemFactory().createType(originalDescriptor));
            if (((AppInfoWithLiveness)GenericSignatureRewriter.this.appView.appInfo()).wasPruned(type)) {
                type = ((GenericSignatureRewriter)GenericSignatureRewriter.this).appView.dexItemFactory().objectType;
            }
            DexString renamedDescriptor = GenericSignatureRewriter.this.renaming.getOrDefault(type, type.descriptor);
            if (parserPosition == GenericSignatureAction.ParserPosition.CLASS_SUPER_OR_INTERFACE_ANNOTATION && this.currentClassContext != null && !originalDescriptor.equals((classDescriptor = this.currentClassContext.type.descriptor).toString()) && renamedDescriptor.equals(classDescriptor)) {
                this.lastWrittenType = null;
                this.removeWrittenClassCharacter();
                return type;
            }
            this.renamedSignature.append(DescriptorUtils.getClassBinaryNameFromDescriptor(renamedDescriptor.toString()));
            this.lastWrittenType = type;
            return type;
        }

        private boolean removeWrittenCharacter(Predicate<Character> removeIf) {
            int index = this.renamedSignature.length() - 1;
            if (index < 0 || !removeIf.test(Character.valueOf(this.renamedSignature.charAt(index)))) {
                return false;
            }
            this.renamedSignature.deleteCharAt(index);
            return true;
        }

        private void removeWrittenClassCharacter() {
            this.removeWrittenCharacter(c -> c.charValue() == 'L');
        }

        @Override
        public DexType parsedInnerTypeName(DexType enclosingType, String name) {
            if (enclosingType == null) {
                this.removeWrittenClassCharacter();
                return null;
            }
            assert (enclosingType.isClassType());
            String enclosingDescriptor = enclosingType.toDescriptorString();
            DexType type = GenericSignatureRewriter.this.appView.dexItemFactory().createType(DescriptorUtils.getDescriptorFromClassBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(enclosingDescriptor) + '$' + name));
            String enclosingRenamedBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(GenericSignatureRewriter.this.renaming.getOrDefault(enclosingType, enclosingType.descriptor).toString());
            type = GenericSignatureRewriter.this.appView.graphLense().lookupType(type);
            DexString renamedDescriptor = (DexString)GenericSignatureRewriter.this.renaming.get(type);
            if (renamedDescriptor != null) {
                String fullRenamedBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(renamedDescriptor.toString());
                int innerClassPos = enclosingRenamedBinaryName.length() + 1;
                if (innerClassPos < fullRenamedBinaryName.length()) {
                    this.renamedSignature.append(fullRenamedBinaryName.substring(innerClassPos));
                } else {
                    GenericSignatureRewriter.this.reporter.warning(new StringDiagnostic("Should have retained InnerClasses attribute of " + type + ".", ((AppInfoWithLiveness)GenericSignatureRewriter.this.appView.appInfo()).originFor(type)));
                    this.renamedSignature.append(name);
                }
            } else {
                this.renamedSignature.append(name);
            }
            return type;
        }

        @Override
        public void start() {
            this.renamedSignature = new StringBuilder();
        }

        @Override
        public void stop() {
        }
    }
}

