/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.optimize;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.optimize.InvokeSingleTargetExtractor;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class VisibilityBridgeRemover {
    private final AppView<AppInfoWithLiveness> appView;
    private final Consumer<DexEncodedMethod> unneededVisibilityBridgeConsumer;

    public VisibilityBridgeRemover(AppView<AppInfoWithLiveness> appView) {
        this(appView, null);
    }

    public VisibilityBridgeRemover(AppView<AppInfoWithLiveness> appView, Consumer<DexEncodedMethod> unneededVisibilityBridgeConsumer) {
        this.appView = appView;
        this.unneededVisibilityBridgeConsumer = unneededVisibilityBridgeConsumer;
    }

    private void removeUnneededVisibilityBridgesFromClass(DexProgramClass clazz) {
        DexEncodedMethod[] newVirtualMethods;
        DexEncodedMethod[] newDirectMethods = this.removeUnneededVisibilityBridges(clazz.directMethods());
        if (newDirectMethods != null) {
            clazz.setDirectMethods(newDirectMethods);
        }
        if ((newVirtualMethods = this.removeUnneededVisibilityBridges(clazz.virtualMethods())) != null) {
            clazz.setVirtualMethods(newVirtualMethods);
        }
    }

    private DexEncodedMethod[] removeUnneededVisibilityBridges(List<DexEncodedMethod> methods) {
        Set<DexEncodedMethod> methodsToBeRemoved = null;
        for (DexEncodedMethod method2 : methods) {
            if (!this.isUnneededVisibilityBridge(method2)) continue;
            if (methodsToBeRemoved == null) {
                methodsToBeRemoved = Sets.newIdentityHashSet();
            }
            methodsToBeRemoved.add(method2);
            if (this.unneededVisibilityBridgeConsumer == null) continue;
            this.unneededVisibilityBridgeConsumer.accept(method2);
        }
        if (methodsToBeRemoved != null) {
            Set<DexEncodedMethod> finalMethodsToBeRemoved = methodsToBeRemoved;
            return (DexEncodedMethod[])methods.stream().filter(method -> !finalMethodsToBeRemoved.contains(method)).toArray(DexEncodedMethod[]::new);
        }
        return null;
    }

    private boolean isUnneededVisibilityBridge(DexEncodedMethod method) {
        if (this.appView.appInfo().isPinned(method.method)) {
            return false;
        }
        MethodAccessFlags accessFlags = method.accessFlags;
        if (!accessFlags.isBridge() || accessFlags.isAbstract()) {
            return false;
        }
        InvokeSingleTargetExtractor targetExtractor = new InvokeSingleTargetExtractor(this.appView.dexItemFactory());
        method.getCode().registerCodeReferences(method, targetExtractor);
        DexMethod target = targetExtractor.getTarget();
        InvokeSingleTargetExtractor.InvokeKind kind = targetExtractor.getKind();
        if (target != null && target.hasSameProtoAndName(method.method)) {
            DexEncodedMethod targetMethod;
            assert (!accessFlags.isPrivate() && !accessFlags.isConstructor());
            if (kind == InvokeSingleTargetExtractor.InvokeKind.SUPER && (targetMethod = this.appView.appInfo().resolveMethod(target.holder, target).getSingleTarget()) != null && targetMethod.accessFlags.isPublic()) {
                if (Log.ENABLED) {
                    Log.info(this.getClass(), "Removing visibility forwarding %s -> %s", method.method, targetMethod.method);
                }
                return true;
            }
        }
        return false;
    }

    public void run() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            this.removeUnneededVisibilityBridgesFromClass(clazz);
        }
    }
}

