/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.references.ClassReference;
import shadow.bundletool.com.android.tools.r8.references.FieldReference;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.retrace.Result;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceClassResult;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

@Keep
public class RetraceFieldResult
extends Result<Element, RetraceFieldResult> {
    private final RetraceClassResult.Element classElement;
    private final List<MemberNaming> memberNamings;
    private final String obfuscatedName;

    RetraceFieldResult(RetraceClassResult.Element classElement, List<MemberNaming> memberNamings, String obfuscatedName) {
        this.classElement = classElement;
        this.memberNamings = memberNamings;
        this.obfuscatedName = obfuscatedName;
        assert (classElement != null);
        assert (memberNamings == null || !memberNamings.isEmpty() && memberNamings.stream().allMatch(Objects::nonNull));
    }

    private boolean hasRetraceResult() {
        return this.memberNamings != null;
    }

    private boolean isAmbiguous() {
        if (!this.hasRetraceResult()) {
            return false;
        }
        assert (this.memberNamings != null);
        return this.memberNamings.size() > 1;
    }

    @Override
    public Stream<Element> stream() {
        if (!this.hasRetraceResult()) {
            return Stream.of(new Element(this, this.classElement, new FieldReference.UnknownFieldReference(this.classElement.getClassReference(), this.obfuscatedName)));
        }
        assert (!this.memberNamings.isEmpty());
        return this.memberNamings.stream().map(memberNaming -> {
            assert (memberNaming.isFieldNaming());
            MemberNaming.FieldSignature fieldSignature = memberNaming.getOriginalSignature().asFieldSignature();
            ClassReference holder = fieldSignature.isQualified() ? Reference.classFromDescriptor(DescriptorUtils.javaTypeToDescriptor(fieldSignature.toHolderFromQualified())) : this.classElement.getClassReference();
            return new Element(this, this.classElement, Reference.field(holder, fieldSignature.isQualified() ? fieldSignature.toUnqualifiedName() : fieldSignature.name, Reference.typeFromTypeName(fieldSignature.type)));
        });
    }

    @Override
    public RetraceFieldResult forEach(Consumer<Element> resultConsumer) {
        this.stream().forEach(resultConsumer);
        return this;
    }

    public static class Element {
        private final FieldReference fieldReference;
        private final RetraceFieldResult retraceFieldResult;
        private final RetraceClassResult.Element classElement;

        private Element(RetraceFieldResult retraceFieldResult, RetraceClassResult.Element classElement, FieldReference fieldReference) {
            this.classElement = classElement;
            this.fieldReference = fieldReference;
            this.retraceFieldResult = retraceFieldResult;
        }

        public FieldReference getFieldReference() {
            return this.fieldReference;
        }

        public RetraceFieldResult getRetraceFieldResult() {
            return this.getRetraceFieldResult();
        }

        public RetraceClassResult.Element getClassElement() {
            return this.classElement;
        }
    }
}

