/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationElement;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.utils.ArrayUtils;

public class AnnotationFixer {
    private final GraphLense lense;

    public AnnotationFixer(GraphLense lense) {
        this.lense = lense;
    }

    public void run(Iterable<DexProgramClass> classes) {
        for (DexProgramClass clazz : classes) {
            clazz.annotations = clazz.annotations.rewrite(this::rewriteAnnotation);
            clazz.forEachMethod(this::processMethod);
            clazz.forEachField(this::processField);
        }
    }

    private void processMethod(DexEncodedMethod method) {
        method.annotations = method.annotations.rewrite(this::rewriteAnnotation);
        method.parameterAnnotationsList = method.parameterAnnotationsList.rewrite(dexAnnotationSet -> dexAnnotationSet.rewrite(this::rewriteAnnotation));
    }

    private void processField(DexEncodedField field) {
        field.annotations = field.annotations.rewrite(this::rewriteAnnotation);
    }

    private DexAnnotation rewriteAnnotation(DexAnnotation original) {
        return original.rewrite(this::rewriteEncodedAnnotation);
    }

    private DexEncodedAnnotation rewriteEncodedAnnotation(DexEncodedAnnotation original) {
        DexEncodedAnnotation rewritten = original.rewrite(this.lense::lookupType, this::rewriteAnnotationElement);
        assert (rewritten != null);
        return rewritten;
    }

    private DexAnnotationElement rewriteAnnotationElement(DexAnnotationElement original) {
        DexValue rewrittenValue = this.rewriteValue(original.value);
        if (rewrittenValue != original.value) {
            return new DexAnnotationElement(original.name, rewrittenValue);
        }
        return original;
    }

    private DexValue rewriteValue(DexValue value) {
        DexValue[] originalValues;
        DexValue[] rewrittenValues;
        if (value.isDexValueType()) {
            DexType originalType = (DexType)value.asDexValueType().value;
            DexType rewrittenType = this.lense.lookupType(originalType);
            if (rewrittenType != originalType) {
                return new DexValue.DexValueType(rewrittenType);
            }
        } else if (value.isDexValueArray() && (rewrittenValues = ArrayUtils.map(DexValue[].class, originalValues = value.asDexValueArray().getValues(), this::rewriteValue)) != originalValues) {
            return new DexValue.DexValueArray(rewrittenValues);
        }
        return value;
    }
}

