/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.ArrayDeque;
import java.util.Queue;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.ProgramMethod;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.GraphReporter;
import shadow.bundletool.com.android.tools.r8.shaking.KeepReason;

public class EnqueuerWorklist {
    private final AppView<?> appView;
    private final Queue<EnqueuerAction> queue = new ArrayDeque<EnqueuerAction>();

    private EnqueuerWorklist(AppView<?> appView) {
        this.appView = appView;
    }

    public static EnqueuerWorklist createWorklist(AppView<?> appView) {
        return new EnqueuerWorklist(appView);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public EnqueuerAction poll() {
        return this.queue.poll();
    }

    void enqueueMarkReachableDirectAction(DexMethod method, KeepReason reason) {
        this.queue.add(new MarkReachableDirectAction(method, reason));
    }

    void enqueueMarkReachableSuperAction(DexMethod method, DexEncodedMethod from) {
        this.queue.add(new MarkReachableSuperAction(method, from));
    }

    public void enqueueMarkReachableFieldAction(DexProgramClass clazz, DexEncodedField field, KeepReason reason) {
        assert (field.field.holder == clazz.type);
        this.queue.add(new MarkReachableFieldAction(field, reason));
    }

    void enqueueMarkInstantiatedAction(DexProgramClass clazz, DexEncodedMethod context, KeepReason reason) {
        assert (!clazz.isInterface() || clazz.accessFlags.isAnnotation());
        this.queue.add(new MarkInstantiatedAction(clazz, context, reason));
    }

    void enqueueMarkMethodLiveAction(DexProgramClass clazz, DexEncodedMethod method, KeepReason reason) {
        assert (method.method.holder == clazz.type);
        this.queue.add(new MarkMethodLiveAction(method, reason));
    }

    void enqueueMarkMethodKeptAction(DexProgramClass clazz, DexEncodedMethod method, KeepReason reason) {
        assert (method.method.holder == clazz.type);
        this.queue.add(new MarkMethodKeptAction(clazz, method, reason));
    }

    void enqueueMarkFieldKeptAction(DexProgramClass holder, DexEncodedField field, GraphReporter.KeepReasonWitness witness) {
        assert (field.isProgramField(this.appView));
        this.queue.add(new MarkFieldKeptAction(holder, field, witness));
    }

    public void enqueueTraceConstClassAction(DexType type, DexEncodedMethod currentMethod) {
        assert (currentMethod.isProgramMethod(this.appView));
        this.queue.add(new TraceConstClassAction(type, currentMethod));
    }

    public void enqueueTraceInvokeDirectAction(DexMethod invokedMethod, DexProgramClass currentHolder, DexEncodedMethod currentMethod) {
        assert (currentMethod.method.holder == currentHolder.type);
        this.queue.add(new TraceInvokeDirectAction(invokedMethod, currentHolder, currentMethod));
    }

    public void enqueueTraceNewInstanceAction(DexType type, ProgramMethod context) {
        this.queue.add(new TraceNewInstanceAction(type, context));
    }

    public void enqueueTraceStaticFieldRead(DexField field, DexEncodedMethod currentMethod) {
        assert (currentMethod.isProgramMethod(this.appView));
        this.queue.add(new TraceStaticFieldReadAction(field, currentMethod));
    }

    static class TraceStaticFieldReadAction
    extends EnqueuerAction {
        final DexField field;
        final DexEncodedMethod currentMethod;

        TraceStaticFieldReadAction(DexField field, DexEncodedMethod currentMethod) {
            this.field = field;
            this.currentMethod = currentMethod;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceStaticFieldRead(this.field, this.currentMethod);
        }
    }

    static class TraceNewInstanceAction
    extends EnqueuerAction {
        final DexType type;
        final ProgramMethod context;

        TraceNewInstanceAction(DexType type, ProgramMethod context) {
            this.type = type;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceNewInstance(this.type, this.context);
        }
    }

    static class TraceInvokeDirectAction
    extends EnqueuerAction {
        final DexMethod invokedMethod;
        final DexProgramClass currentHolder;
        final DexEncodedMethod currentMethod;

        TraceInvokeDirectAction(DexMethod invokedMethod, DexProgramClass currentHolder, DexEncodedMethod currentMethod) {
            this.invokedMethod = invokedMethod;
            this.currentHolder = currentHolder;
            this.currentMethod = currentMethod;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceInvokeDirect(this.invokedMethod, new ProgramMethod(this.currentHolder, this.currentMethod));
        }
    }

    static class TraceConstClassAction
    extends EnqueuerAction {
        final DexType type;
        final DexEncodedMethod currentMethod;

        TraceConstClassAction(DexType type, DexEncodedMethod currentMethod) {
            this.type = type;
            this.currentMethod = currentMethod;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.traceConstClass(this.type, this.currentMethod);
        }
    }

    static class MarkFieldKeptAction
    extends EnqueuerAction {
        final DexProgramClass holder;
        final DexEncodedField target;
        final GraphReporter.KeepReasonWitness witness;

        public MarkFieldKeptAction(DexProgramClass holder, DexEncodedField target, GraphReporter.KeepReasonWitness witness) {
            this.holder = holder;
            this.target = target;
            this.witness = witness;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markFieldAsKept(this.holder, this.target, this.witness);
        }
    }

    static class MarkMethodKeptAction
    extends EnqueuerAction {
        final DexProgramClass holder;
        final DexEncodedMethod target;
        final KeepReason reason;

        public MarkMethodKeptAction(DexProgramClass holder, DexEncodedMethod target, KeepReason reason) {
            this.holder = holder;
            this.target = target;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markMethodAsKept(this.holder, this.target, this.reason);
        }
    }

    static class MarkMethodLiveAction
    extends EnqueuerAction {
        final DexEncodedMethod target;
        final KeepReason reason;

        public MarkMethodLiveAction(DexEncodedMethod target, KeepReason reason) {
            this.target = target;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markMethodAsLive(this.target, this.reason);
        }
    }

    static class MarkInstantiatedAction
    extends EnqueuerAction {
        final DexProgramClass target;
        final DexEncodedMethod context;
        final KeepReason reason;

        public MarkInstantiatedAction(DexProgramClass target, DexEncodedMethod context, KeepReason reason) {
            this.target = target;
            this.context = context;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.processNewlyInstantiatedClass(this.target, this.context, this.reason);
        }
    }

    static class MarkReachableFieldAction
    extends EnqueuerAction {
        final DexEncodedField target;
        final KeepReason reason;

        public MarkReachableFieldAction(DexEncodedField target, KeepReason reason) {
            this.target = target;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markInstanceFieldAsReachable(this.target, this.reason);
        }
    }

    static class MarkReachableSuperAction
    extends EnqueuerAction {
        final DexMethod target;
        final DexEncodedMethod context;

        public MarkReachableSuperAction(DexMethod target, DexEncodedMethod context) {
            this.target = target;
            this.context = context;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markSuperMethodAsReachable(this.target, this.context);
        }
    }

    static class MarkReachableDirectAction
    extends EnqueuerAction {
        final DexMethod target;
        final KeepReason reason;

        MarkReachableDirectAction(DexMethod target, KeepReason reason) {
            this.target = target;
            this.reason = reason;
        }

        @Override
        public void run(Enqueuer enqueuer) {
            enqueuer.markNonStaticDirectMethodAsReachable(this.target, this.reason);
        }
    }

    public static abstract class EnqueuerAction {
        public abstract void run(Enqueuer var1);
    }
}

