/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Collections;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.EscapeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.EscapeAnalysisConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class LibraryMethodOverrideAnalysis {
    private final AppView<AppInfoWithLiveness> appView;
    private final Set<DexType> nonEscapingClassesWithLibraryMethodOverrides;
    private final Object2IntMap<Class<?>> escapeDebuggingCounters = Log.ENABLED ? new Object2IntLinkedOpenHashMap() : null;

    public LibraryMethodOverrideAnalysis(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.nonEscapingClassesWithLibraryMethodOverrides = Collections.synchronizedSet(LibraryMethodOverrideAnalysis.getInitialNonEscapingClassesWithLibraryMethodOverrides(appView));
    }

    private static Set<DexType> getInitialNonEscapingClassesWithLibraryMethodOverrides(AppView<AppInfoWithLiveness> appView) {
        Set<DexType> initialNonEscapingClassesWithLibraryMethodOverrides = LibraryMethodOverrideAnalysis.getClassesWithLibraryMethodOverrides(appView);
        DexReference.filterDexType(appView.appInfo().pinnedItems.stream()).forEach(initialNonEscapingClassesWithLibraryMethodOverrides::remove);
        return initialNonEscapingClassesWithLibraryMethodOverrides;
    }

    private static Set<DexType> getClassesWithLibraryMethodOverrides(AppView<AppInfoWithLiveness> appView) {
        Set<DexType> classesWithLibraryMethodOverrides = Sets.newIdentityHashSet();
        TopDownClassHierarchyTraversal.forProgramClasses(appView).visit((Iterable)appView.appInfo().classes(), clazz -> {
            if (LibraryMethodOverrideAnalysis.hasLibraryMethodOverrideDirectlyOrIndirectly(clazz, classesWithLibraryMethodOverrides)) {
                classesWithLibraryMethodOverrides.add(clazz.type);
            }
        });
        return classesWithLibraryMethodOverrides;
    }

    private static boolean hasLibraryMethodOverrideDirectlyOrIndirectly(DexProgramClass clazz, Set<DexType> classesWithLibraryMethodOverrides) {
        return LibraryMethodOverrideAnalysis.hasLibraryMethodOverrideDirectly(clazz) || LibraryMethodOverrideAnalysis.hasLibraryMethodOverrideIndirectly(clazz, classesWithLibraryMethodOverrides);
    }

    private static boolean hasLibraryMethodOverrideDirectly(DexProgramClass clazz) {
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            if (method.accessFlags.isAbstract() || !method.isLibraryMethodOverride().isPossiblyTrue()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLibraryMethodOverrideIndirectly(DexProgramClass clazz, Set<DexType> classesWithLibraryMethodOverrides) {
        if (classesWithLibraryMethodOverrides.contains(clazz.superType)) {
            return true;
        }
        for (DexType interfaceType : clazz.interfaces.values) {
            if (!classesWithLibraryMethodOverrides.contains(interfaceType)) continue;
            return true;
        }
        return false;
    }

    public void analyze(IRCode code) {
        if (this.nonEscapingClassesWithLibraryMethodOverrides.isEmpty()) {
            return;
        }
        EscapeAnalysis escapeAnalysis = new EscapeAnalysis(this.appView, LibraryEscapeAnalysisConfiguration.getInstance());
        for (Instruction instruction : code.instructions()) {
            DexType type;
            DexClass clazz;
            if (!instruction.isNewInstance() || (clazz = this.appView.definitionFor(type = instruction.asNewInstance().clazz)) == null || !clazz.isProgramClass() || !this.nonEscapingClassesWithLibraryMethodOverrides.contains(type) || !escapeAnalysis.isEscaping(code, instruction.outValue())) continue;
            this.nonEscapingClassesWithLibraryMethodOverrides.remove(type);
            if (!Log.ENABLED) continue;
            Set<Instruction> escapeRoutes = escapeAnalysis.computeEscapeRoutes(code, instruction.outValue());
            for (Instruction escapeRoute : escapeRoutes) {
                Class<?> instructionClass = escapeRoute.getClass();
                this.escapeDebuggingCounters.put(instructionClass, this.escapeDebuggingCounters.getInt(instructionClass) + 1);
            }
        }
    }

    public void finish() {
        assert (this.verifyNoUninstantiatedTypesEscapeIntoLibrary());
        this.appView.setClassesEscapingIntoLibrary(type -> !this.nonEscapingClassesWithLibraryMethodOverrides.contains(type));
    }

    private boolean verifyNoUninstantiatedTypesEscapeIntoLibrary() {
        Set<DexType> classesWithLibraryMethodOverrides = LibraryMethodOverrideAnalysis.getClassesWithLibraryMethodOverrides(this.appView);
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            assert (this.appView.appInfo().isInstantiatedDirectlyOrIndirectly(clazz) || !classesWithLibraryMethodOverrides.contains(clazz.type) || this.nonEscapingClassesWithLibraryMethodOverrides.contains(clazz.type));
        }
        return true;
    }

    public void logResults() {
        assert (Log.ENABLED);
        Log.info(this.getClass(), "# classes with library method overrides: %s", LibraryMethodOverrideAnalysis.getClassesWithLibraryMethodOverrides(this.appView).size());
        Log.info(this.getClass(), "# non-escaping classes with library method overrides: %s", this.nonEscapingClassesWithLibraryMethodOverrides.size());
        this.escapeDebuggingCounters.keySet().forEach(instructionClass -> Log.info(this.getClass(), "# classes that escaped via %s: %s", instructionClass.getSimpleName(), this.escapeDebuggingCounters.getInt(instructionClass)));
    }

    static class LibraryEscapeAnalysisConfiguration
    implements EscapeAnalysisConfiguration {
        private static final LibraryEscapeAnalysisConfiguration INSTANCE = new LibraryEscapeAnalysisConfiguration();

        private LibraryEscapeAnalysisConfiguration() {
        }

        public static LibraryEscapeAnalysisConfiguration getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isLegitimateEscapeRoute(AppView<?> appView, EscapeAnalysis escapeAnalysis, Instruction escapeRoute, DexMethod context) {
            if (((AppInfo)appView.appInfo()).hasLiveness()) {
                return this.isLegitimateConstructorInvocation(appView.withLiveness(), escapeAnalysis, escapeRoute, context);
            }
            return false;
        }

        private boolean isLegitimateConstructorInvocation(AppView<AppInfoWithLiveness> appView, EscapeAnalysis escapeAnalysis, Instruction instruction, DexMethod context) {
            if (!instruction.isInvokeDirect()) {
                return false;
            }
            InvokeDirect invoke = instruction.asInvokeDirect();
            if (!appView.dexItemFactory().isConstructor(invoke.getInvokedMethod())) {
                return false;
            }
            for (int i = 1; i < invoke.arguments().size(); ++i) {
                if (!escapeAnalysis.isValueOfInterestOrAlias(invoke.arguments().get(i))) continue;
                return false;
            }
            DexEncodedMethod singleTarget = invoke.lookupSingleTarget(appView, context.holder);
            if (singleTarget == null) {
                return false;
            }
            InstanceInitializerInfo initializerInfo = singleTarget.getOptimizationInfo().getInstanceInitializerInfo();
            return initializerInfo.receiverNeverEscapesOutsideConstructorChain();
        }
    }
}

