/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationParser;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardWildcard;

public abstract class ProguardNameMatcher {
    private static final ProguardNameMatcher MATCH_ALL_NAMES = new MatchAllNames();

    private ProguardNameMatcher() {
    }

    public static ProguardNameMatcher create(ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithWildcards) {
        if (identifierPatternWithWildcards.isMatchAllNames()) {
            return MATCH_ALL_NAMES;
        }
        if (identifierPatternWithWildcards.wildcards.isEmpty()) {
            return new MatchSpecificName(identifierPatternWithWildcards.pattern);
        }
        return new MatchNamePattern(identifierPatternWithWildcards);
    }

    private static boolean matchFieldOrMethodNameImpl(String pattern, int patternIndex, String name, int nameIndex, List<ProguardWildcard> wildcards, int wildcardIndex) {
        block5: for (int i = patternIndex; i < pattern.length(); ++i) {
            char patternChar = pattern.charAt(i);
            switch (patternChar) {
                case '*': {
                    ProguardWildcard wildcard = wildcards.get(wildcardIndex);
                    assert (wildcard.isPattern());
                    ProguardWildcard.Pattern wildcardPattern = wildcard.asPattern();
                    for (int nextNameIndex = nameIndex; nextNameIndex <= name.length(); ++nextNameIndex) {
                        wildcardPattern.setCaptured(name.substring(nameIndex, nextNameIndex));
                        if (!ProguardNameMatcher.matchFieldOrMethodNameImpl(pattern, i + 1, name, nextNameIndex, wildcards, wildcardIndex + 1)) continue;
                        return true;
                    }
                    return false;
                }
                case '?': {
                    ProguardWildcard wildcard = wildcards.get(wildcardIndex);
                    assert (wildcard.isPattern());
                    if (nameIndex == name.length()) {
                        return false;
                    }
                    ProguardWildcard.Pattern wildcardPattern = wildcard.asPattern();
                    wildcardPattern.setCaptured(name.substring(nameIndex, nameIndex + 1));
                    ++nameIndex;
                    ++wildcardIndex;
                    continue block5;
                }
                case '<': {
                    ProguardWildcard wildcard = wildcards.get(wildcardIndex);
                    assert (wildcard.isBackReference());
                    ProguardWildcard.BackReference backReference = wildcard.asBackReference();
                    String captured = backReference.getCaptured();
                    if (captured == null || name.length() < nameIndex + captured.length() || !captured.equals(name.substring(nameIndex, nameIndex + captured.length()))) {
                        return false;
                    }
                    nameIndex += captured.length();
                    ++wildcardIndex;
                    i = pattern.indexOf(">", i);
                    continue block5;
                }
                default: {
                    if (nameIndex != name.length() && patternChar == name.charAt(nameIndex++)) continue block5;
                    return false;
                }
            }
        }
        return nameIndex == name.length();
    }

    public abstract boolean matches(String var1);

    protected Iterable<ProguardWildcard> getWildcards() {
        return Collections::emptyIterator;
    }

    static Iterable<ProguardWildcard> getWildcardsOrEmpty(ProguardNameMatcher nameMatcher) {
        return nameMatcher == null ? Collections::emptyIterator : nameMatcher.getWildcards();
    }

    protected ProguardNameMatcher materialize() {
        return this;
    }

    private static class MatchSpecificName
    extends ProguardNameMatcher {
        private final String name;

        MatchSpecificName(String name) {
            this.name = name;
        }

        @Override
        public boolean matches(String name) {
            return this.name.equals(name);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o instanceof MatchSpecificName && this.name.equals(((MatchSpecificName)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class MatchNamePattern
    extends ProguardNameMatcher {
        private final String pattern;
        private final List<ProguardWildcard> wildcards;

        MatchNamePattern(ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithWildcards) {
            this.pattern = identifierPatternWithWildcards.pattern;
            this.wildcards = identifierPatternWithWildcards.wildcards;
        }

        @Override
        public boolean matches(String name) {
            boolean matched = ProguardNameMatcher.matchFieldOrMethodNameImpl(this.pattern, 0, name, 0, this.wildcards, 0);
            if (!matched) {
                this.wildcards.forEach(ProguardWildcard::clearCaptured);
            }
            return matched;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.wildcards;
        }

        @Override
        protected MatchNamePattern materialize() {
            List<ProguardWildcard> materializedWildcards = this.wildcards.stream().map(ProguardWildcard::materialize).collect(Collectors.toList());
            ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithMaterializedWildcards = new ProguardConfigurationParser.IdentifierPatternWithWildcards(this.pattern, materializedWildcards);
            return new MatchNamePattern(identifierPatternWithMaterializedWildcards);
        }

        public String toString() {
            return this.pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof MatchNamePattern && this.pattern.equals(((MatchNamePattern)o).pattern);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }
    }

    private static class MatchAllNames
    extends ProguardNameMatcher {
        private final ProguardWildcard wildcard;

        MatchAllNames() {
            this(new ProguardWildcard.Pattern("*"));
        }

        private MatchAllNames(ProguardWildcard wildcard) {
            this.wildcard = wildcard;
        }

        @Override
        public boolean matches(String name) {
            this.wildcard.setCaptured(name);
            return true;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return ImmutableList.of(this.wildcard);
        }

        @Override
        protected MatchAllNames materialize() {
            return new MatchAllNames(this.wildcard.materialize());
        }

        public String toString() {
            return "*";
        }
    }
}

