/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.HashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;

class ScopedDexMethodSet {
    private static final Equivalence<DexMethod> METHOD_EQUIVALENCE = MethodSignatureEquivalence.get();
    private ScopedDexMethodSet parent;
    private final Map<Equivalence.Wrapper<DexMethod>, DexEncodedMethod> items = new HashMap<Equivalence.Wrapper<DexMethod>, DexEncodedMethod>();

    public ScopedDexMethodSet() {
        this(null);
    }

    private ScopedDexMethodSet(ScopedDexMethodSet parent) {
        this.parent = parent;
    }

    public ScopedDexMethodSet newNestedScope() {
        return new ScopedDexMethodSet(this);
    }

    private DexEncodedMethod lookup(Equivalence.Wrapper<DexMethod> item) {
        DexEncodedMethod ownMethod = this.items.get(item);
        return ownMethod != null ? ownMethod : (this.parent != null ? this.parent.lookup(item) : null);
    }

    private boolean contains(Equivalence.Wrapper<DexMethod> item) {
        return this.lookup(item) != null;
    }

    public boolean addMethod(DexEncodedMethod method) {
        Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap(method.method);
        if (this.contains(wrapped)) {
            return false;
        }
        this.items.put(wrapped, method);
        return true;
    }

    public AddMethodIfMoreVisibleResult addMethodIfMoreVisible(DexEncodedMethod method) {
        Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap(method.method);
        DexEncodedMethod existing = this.lookup(wrapped);
        if (existing == null) {
            this.items.put(wrapped, method);
            return AddMethodIfMoreVisibleResult.ADDED_NOT_EXISTING;
        }
        if (method.accessFlags.isMoreVisibleThan(existing.accessFlags, method.method.holder.getPackageName(), existing.method.holder.getPackageName())) {
            this.items.put(wrapped, method);
            return AddMethodIfMoreVisibleResult.ADDED_MORE_VISIBLE;
        }
        return AddMethodIfMoreVisibleResult.NOT_ADDED;
    }

    public ScopedDexMethodSet getParent() {
        return this.parent;
    }

    public void setParent(ScopedDexMethodSet parent) {
        this.parent = parent;
    }

    public static enum AddMethodIfMoreVisibleResult {
        NOT_ADDED,
        ADDED_NOT_EXISTING,
        ADDED_MORE_VISIBLE;

    }
}

