/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class ListUtils {
    public static <T> T first(List<T> list) {
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> int lastIndexMatching(List<T> list, Predicate<T> tester) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!tester.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <S, T> List<T> map(Collection<S> list, Function<S, T> fn) {
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (S element : list) {
            result.add(fn.apply(element));
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean verifyListIsOrdered(List<T> list) {
        for (int i = list.size() - 1; i > 0; --i) {
            if (((Comparable)list.get(i)).compareTo((Comparable)list.get(i - 1)) >= 0) continue;
            return false;
        }
        return true;
    }
}

