/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.model.exceptions.ParseException;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Optional;

class SessionIdParser {
    SessionIdParser() {
    }

    int parse(ImmutableList<String> installCreateOutput) {
        Optional<String> successLine = installCreateOutput.stream().filter(s4 -> s4.startsWith("Success")).findFirst();
        if (!successLine.isPresent()) {
            throw new ParseException(String.format("adb: failed to parse session id from output\nDetails:%s", installCreateOutput));
        }
        return SessionIdParser.parseSessionIdFromOutput(successLine.get());
    }

    private static int parseSessionIdFromOutput(String output) {
        int startIndex = output.indexOf("[");
        int endIndex = output.indexOf("]", startIndex);
        if (startIndex == -1 || endIndex == -1) {
            throw new ParseException(String.format("adb: failed to parse session id from output\nDetails:%s", output));
        }
        Integer sessionId = Ints.tryParse((String)output.substring(startIndex + 1, endIndex));
        if (sessionId == null) {
            throw new ParseException(String.format("adb: session id should be integer\nDetails:%s", output));
        }
        return sessionId;
    }
}

