/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.base.Predicates;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.WillNotClose;

public final class ZipUtils {
    public static Stream<ZipPath> allFileEntriesPaths(ZipFile zipFile) {
        return ZipUtils.allFileEntries(zipFile).map(zipEntry -> ZipPath.create(zipEntry.getName()));
    }

    public static Stream<? extends ZipEntry> allFileEntries(ZipFile zipFile) {
        return zipFile.stream().filter((Predicate<? extends ZipEntry>)Predicates.not(ZipEntry::isDirectory));
    }

    public static ZipFile openZipFile(Path path) {
        FilePreconditions.checkFileExistsAndReadable(path);
        try {
            return new ZipFile(path.toFile());
        }
        catch (IOException e4) {
            throw new UncheckedIOException(String.format("Error reading zip file '%s'.", path), e4);
        }
    }

    public static long calculateGzipCompressedSize(@WillNotClose InputStream stream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(ByteStreams.nullOutputStream());
        try (GZIPOutputStream compressedStream = new GZIPOutputStream((OutputStream)countingOutputStream);){
            ByteStreams.copy((InputStream)stream, (OutputStream)compressedStream);
        }
        return countingOutputStream.getCount();
    }

    public static ZipPath convertBundleToModulePath(ZipPath bundlePath) {
        return bundlePath.subpath(1, bundlePath.getNameCount());
    }

    private ZipUtils() {
    }
}

