/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;

public class SplitApkSerializer {
    private final ApkSerializerHelper apkSerializerHelper;

    public SplitApkSerializer(Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfig, Config.Compression compression) {
        this.apkSerializerHelper = new ApkSerializerHelper(aapt2Command, signingConfig, compression);
    }

    public ImmutableList<Commands.ApkDescription> writeSplitsToDisk(ImmutableList<ModuleSplit> splitApks, Path outputDirectory) {
        return (ImmutableList)splitApks.stream().map(split -> this.writeSplitToDisk((ModuleSplit)split, outputDirectory)).collect(ImmutableList.toImmutableList());
    }

    public Commands.ApkDescription writeSplitToDisk(ModuleSplit split, Path outputDirectory) {
        Preconditions.checkState((boolean)Files.isDirectory(outputDirectory, new LinkOption[0]));
        String apkFileName = SplitApkSerializer.getApkFileName(split, split.getModuleName());
        this.apkSerializerHelper.writeToZipFile(split, outputDirectory.resolve(Paths.get(apkFileName, new String[0])));
        return Commands.ApkDescription.newBuilder().setPath(apkFileName).setTargeting(split.getTargeting()).setSplitApkMetadata(Commands.SplitApkMetadata.newBuilder().setSplitId(split.getAndroidManifest().get().getSplitId().orElse("")).setIsMasterSplit(split.isMasterSplit())).build();
    }

    private static String getApkFileName(ModuleSplit apk, BundleModuleName moduleName) {
        String splitId = apk.getAndroidManifest().get().getSplitId().orElse("");
        String fileSuffix = apk.isMasterSplit() ? "master" : (String)Iterables.getLast(Arrays.asList(splitId.split("\\.")));
        return String.format("%s-%s.apk", moduleName.getName(), fileSuffix);
    }
}

