/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class ZipPath
implements Path {
    private static final String SEPARATOR = "/";
    private static final Splitter SPLITTER = Splitter.on((String)"/").omitEmptyStrings();
    private static final Joiner JOINER = Joiner.on((String)"/");
    private static final ImmutableSet<String> FORBIDDEN_NAMES = ImmutableSet.of((Object)".", (Object)"..");
    public static final ZipPath ROOT = ZipPath.create("");
    protected final String[] names;
    private transient int hashCode;

    private ZipPath(List<String> names) {
        this(names.toArray(new String[0]));
    }

    private ZipPath(String[] names) {
        Arrays.stream(names).forEach(name -> Preconditions.checkArgument((!FORBIDDEN_NAMES.contains(name) ? 1 : 0) != 0, (String)"Name '%s' is not supported inside path.", (Object)name));
        this.names = names;
    }

    public static ZipPath create(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null.");
        return new ZipPath(SPLITTER.splitToList((CharSequence)path));
    }

    @Override
    @CheckReturnValue
    public ZipPath resolve(Path p) {
        Preconditions.checkNotNull((Object)p, (Object)"Path cannot be null.");
        ZipPath path = (ZipPath)p;
        return new ZipPath((String[])ObjectArrays.concat((Object[])this.names, (Object[])path.names, String.class));
    }

    @Override
    @CheckReturnValue
    public ZipPath resolve(String path) {
        return this.resolve(ZipPath.create(path));
    }

    @Override
    @CheckReturnValue
    public ZipPath resolveSibling(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null.");
        Preconditions.checkState((this.names.length > 0 ? 1 : 0) != 0, (Object)"Root has not sibling.");
        return this.getParent().resolve(path);
    }

    @Override
    @CheckReturnValue
    public ZipPath resolveSibling(String path) {
        return this.resolveSibling(ZipPath.create(path));
    }

    @Override
    @CheckReturnValue
    public ZipPath subpath(int from, int to) {
        Preconditions.checkArgument((from >= 0 && from < this.names.length ? 1 : 0) != 0);
        Preconditions.checkArgument((to >= 0 && to <= this.names.length ? 1 : 0) != 0);
        Preconditions.checkArgument((from < to ? 1 : 0) != 0);
        return new ZipPath(Arrays.copyOfRange(this.names, from, to));
    }

    @Override
    @Nullable
    @CheckReturnValue
    public ZipPath getParent() {
        if (this.names.length == 0) {
            return null;
        }
        return new ZipPath(Arrays.copyOf(this.names, this.names.length - 1));
    }

    @Override
    public int getNameCount() {
        return this.names.length;
    }

    @Override
    public ZipPath getRoot() {
        return ROOT;
    }

    @Override
    public ZipPath getName(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.names.length ? 1 : 0) != 0);
        return ZipPath.create(this.names[index]);
    }

    @Override
    public boolean startsWith(Path p) {
        ZipPath path = (ZipPath)p;
        if (path.getNameCount() > this.getNameCount()) {
            return false;
        }
        for (int i = 0; i < path.getNameCount(); ++i) {
            if (path.names[i].equals(this.names[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String p) {
        return this.startsWith(ZipPath.create(p));
    }

    @Override
    public boolean endsWith(Path p) {
        ZipPath path = (ZipPath)p;
        if (path.getNameCount() > this.getNameCount()) {
            return false;
        }
        for (int i = 0; i < path.getNameCount(); ++i) {
            if (path.names[path.names.length - i - 1].equals(this.names[this.names.length - i - 1])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String p) {
        return this.endsWith(ZipPath.create(p));
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.names);
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object path) {
        if (!(path instanceof ZipPath)) {
            return false;
        }
        return Arrays.equals(this.names, ((ZipPath)path).names);
    }

    @Override
    public int compareTo(Path other) {
        ZipPath path = (ZipPath)other;
        ComparisonChain chain = ComparisonChain.start();
        for (int i = 0; i < Math.max(this.getNameCount(), path.getNameCount()); ++i) {
            chain = chain.compare((Object)(i < this.names.length ? this.names[i] : null), (Object)(i < path.names.length ? path.names[i] : null), (Comparator)Ordering.natural().nullsFirst());
        }
        return chain.result();
    }

    @Override
    public String toString() {
        return JOINER.join((Object[])this.names);
    }

    @Override
    public ZipPath getFileName() {
        Preconditions.checkArgument((this.getNameCount() > 0 ? 1 : 0) != 0, (Object)"Root does not have a file name.");
        return this.getName(this.getNameCount() - 1);
    }

    @Override
    public Iterator<Path> iterator() {
        return Arrays.stream(this.names).map(name -> ZipPath.create(name)).iterator();
    }

    @Override
    @CheckReturnValue
    public ZipPath normalize() {
        return this;
    }

    @Override
    public ZipPath toRealPath(LinkOption ... options) {
        return this;
    }

    @Override
    public ZipPath toAbsolutePath() {
        return this;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    @CheckReturnValue
    public ZipPath relativize(Path p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("Zip entries don't match to a file on disk.");
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }
}

