/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.manifest.AutoValue_AndroidManifest;
import com.android.tools.build.bundletool.manifest.ManifestEditor;
import com.android.tools.build.bundletool.manifest.ProtoXmlHelper;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Optional;

@AutoValue
public abstract class AndroidManifest {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    public static final String ANDROID_NAMESPACE = "http://schemas.android.com/apk/res/android";
    public static final String DISTRIBUTION_NAMESPACE = "http://schemas.android.com/apk/distribution";
    public static final String APPLICATION_ELEMENT_NAME = "application";
    public static final String META_DATA_ELEMENT_NAME = "meta-data";
    public static final String SUPPORTS_GL_TEXTURE_ELEMENT_NAME = "supports-gl-texture";
    public static final String USES_FEATURE_ELEMENT_NAME = "uses-feature";
    public static final String USES_SDK_ELEMENT_NAME = "uses-sdk";
    public static final String EXTRACT_NATIVE_LIBS_ATTRIBUTE_NAME = "extractNativeLibs";
    public static final String GL_VERSION_ATTRIBUTE_NAME = "glEsVersion";
    public static final String MAX_SDK_VERSION_ATTRIBUTE_NAME = "maxSdkVersion";
    public static final String MIN_SDK_VERSION_ATTRIBUTE_NAME = "minSdkVersion";
    public static final int EXTRACT_NATIVE_LIBS_RESOURCE_ID = 16844010;
    public static final int HAS_CODE_RESOURCE_ID = 0x101000C;
    public static final int MAX_SDK_VERSION_RESOURCE_ID = 16843377;
    public static final int MIN_SDK_VERSION_RESOURCE_ID = 16843276;
    public static final int NAME_RESOURCE_ID = 0x1010003;
    public static final int VALUE_RESOURCE_ID = 16842788;
    public static final int VERSION_CODE_RESOURCE_ID = 16843291;
    public static final String META_DATA_KEY_FUSED_MODULE_NAMES = "shadow.bundletool.com.android.dynamic.apk.fused.modules";

    public abstract Resources.XmlNode getManifestRoot();

    public static AndroidManifest create(Resources.XmlNode manifestRoot) {
        return new AutoValue_AndroidManifest(manifestRoot);
    }

    public static AndroidManifest createForConfigSplit(String packageName, int versionCode, String splitId, String featureSplitId, Optional<Boolean> extractNativeLibs) {
        Preconditions.checkNotNull((Object)splitId);
        Preconditions.checkArgument((!splitId.isEmpty() ? 1 : 0) != 0, (Object)"Split Id cannot be empty for config split.");
        Preconditions.checkNotNull((Object)featureSplitId);
        Preconditions.checkNotNull((Object)packageName);
        ManifestEditor editor = new ManifestEditor(AndroidManifest.createMinimalManifestTag()).setPackage(packageName).setVersionCode(versionCode).setSplitId(splitId).setConfigForSplit(featureSplitId).setHasCode(false);
        extractNativeLibs.ifPresent(editor::setExtractNativeLibsValue);
        return editor.save();
    }

    private static Resources.XmlNode createMinimalManifestTag() {
        return Resources.XmlNode.newBuilder().setElement(Resources.XmlElement.newBuilder().setName("manifest").addNamespaceDeclaration(Resources.XmlNamespace.newBuilder().setPrefix("android").setUri(ANDROID_NAMESPACE))).build();
    }

    public Optional<Integer> getMinSdkVersion() {
        return this.getUsesSdkAttribute(MIN_SDK_VERSION_ATTRIBUTE_NAME);
    }

    public int getEffectiveMinSdkVersion() {
        return this.getMinSdkVersion().orElse(1);
    }

    public Optional<Integer> getMaxSdkVersion() {
        return this.getUsesSdkAttribute(MAX_SDK_VERSION_ATTRIBUTE_NAME);
    }

    private Optional<Integer> getUsesSdkAttribute(String attributeName) {
        return ProtoXmlHelper.getFirstElement(this.getManifestRoot(), USES_SDK_ELEMENT_NAME).flatMap(usesSdk -> ProtoXmlHelper.findAttribute(usesSdk, ANDROID_NAMESPACE, attributeName)).map(ProtoXmlHelper::getAttributeValueAsDecimalInteger);
    }

    public Optional<Boolean> getHasCode() {
        return ProtoXmlHelper.getFirstElement(this.getManifestRoot(), APPLICATION_ELEMENT_NAME).flatMap(el -> ProtoXmlHelper.findAttributeWithResourceId(el, 0x101000C)).map(ProtoXmlHelper::getAttributeValueAsBoolean);
    }

    public Optional<Boolean> getIsFeatureSplit() {
        return ProtoXmlHelper.findAttribute(this.getManifestRoot().getElement(), ANDROID_NAMESPACE, "isFeatureSplit").map(ProtoXmlHelper::getAttributeValueAsBoolean);
    }

    public Optional<Boolean> getIsModuleIncludedInFusing() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        return ProtoXmlHelper.findElementFromDirectChildren(manifest, "module", DISTRIBUTION_NAMESPACE).flatMap(module -> ProtoXmlHelper.findElementFromDirectChildren(module, "fusing", DISTRIBUTION_NAMESPACE)).map(fusing -> ProtoXmlHelper.findAttribute(fusing, "", "include").orElseThrow(() -> new ValidationException("<fusing> element is missing the 'include' attribute."))).map(ProtoXmlHelper::getAttributeValueAsBoolean);
    }

    public Optional<String> getConfigForSplit() {
        return ProtoXmlHelper.findAttributeWithName(this.getManifestRoot().getElement(), "configForSplit").map(Resources.XmlAttribute::getValue);
    }

    public String getPackageName() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        return ProtoXmlHelper.findAttributeWithName(manifest, "package").get().getValue();
    }

    public int getVersionCode() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        Optional<Resources.XmlAttribute> maybeVersionCode = ProtoXmlHelper.findAttributeWithResourceId(manifest, 16843291);
        return ProtoXmlHelper.getAttributeValueAsDecimalInteger(maybeVersionCode.orElseThrow(() -> new ValidationException("Version code not found in manifest.")));
    }

    public Optional<String> getSplitId() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        return ProtoXmlHelper.findAttributeWithName(manifest, "split").map(Resources.XmlAttribute::getValue);
    }

    public Collection<String> getUsesSplits() {
        return (Collection)ProtoXmlHelper.findElements(this.getManifestRoot(), "uses-split").map(elem -> ProtoXmlHelper.findAttribute(elem, ANDROID_NAMESPACE, "name").orElseThrow(() -> new ValidationException("<uses-split> element is missing the 'android:name' attribute."))).map(Resources.XmlAttribute::getValue).collect(ImmutableList.toImmutableList());
    }

    public boolean isDynamicModule() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        Optional<Resources.XmlElement> moduleElement = ProtoXmlHelper.findElementFromDirectChildren(manifest, "module", DISTRIBUTION_NAMESPACE);
        return moduleElement.flatMap(el -> ProtoXmlHelper.findAttribute(el, DISTRIBUTION_NAMESPACE, "onDemand")).map(ProtoXmlHelper::getAttributeValueAsBoolean).orElse(false);
    }

    public Optional<Boolean> getExtractNativeLibsValue() {
        return ProtoXmlHelper.getFirstElement(this.getManifestRoot(), APPLICATION_ELEMENT_NAME).flatMap(el -> ProtoXmlHelper.findAttributeWithResourceId(el, 16844010)).map(ProtoXmlHelper::getAttributeValueAsBoolean);
    }

    public ImmutableList<String> getFusedModuleNames() {
        Optional<Resources.XmlElement> application = ProtoXmlHelper.findElementFromDirectChildren(this.getManifestRoot().getElement(), APPLICATION_ELEMENT_NAME, "");
        if (!application.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList values = (ImmutableList)ProtoXmlHelper.findElementsFromDirectChildren(application.get(), META_DATA_ELEMENT_NAME, "").filter(metadataElem -> {
            String attrName = ProtoXmlHelper.findAttributeWithResourceId(metadataElem, 0x1010003).map(Resources.XmlAttribute::getValue).orElse("");
            return attrName.equals(META_DATA_KEY_FUSED_MODULE_NAMES);
        }).map(metadataElem -> ProtoXmlHelper.findAttributeWithResourceId(metadataElem, 16842788).orElseThrow(() -> new ValidationException("<meta-data> element is missing the 'android:value' attribute:\n" + metadataElem))).map(Resources.XmlAttribute::getValue).collect(ImmutableList.toImmutableList());
        switch (values.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                String rawValue = (String)Iterables.getOnlyElement((Iterable)values);
                return ImmutableList.copyOf((Iterable)COMMA_SPLITTER.split((CharSequence)rawValue));
            }
        }
        throw ValidationException.builder().withMessage("Found multiple <meta-data> elements for key '%s', expected at most one.", META_DATA_KEY_FUSED_MODULE_NAMES).build();
    }

    public ManifestEditor toEditor() {
        return new ManifestEditor(this.getManifestRoot());
    }
}

