/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.version.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public interface Aapt2Command {
    public void convertApkProtoToBinary(Path var1, Path var2);

    public static Aapt2Command createFromExecutablePath(final Path aapt2Path) {
        return new Aapt2Command(){

            @Override
            public void convertApkProtoToBinary(Path protoApk, Path binaryApk) {
                new CommandExecutor().execute(aapt2Path.toString(), "convert", "--output-format", "binary", "-o", binaryApk.toString(), protoApk.toString());
            }
        };
    }

    public static class Aapt2Locator {
        private static final PathMatcher AAPT2_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/build-tools/*.*.*/aapt2");
        private static final Pattern VERSION_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+");

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Optional<Path> locateAapt2(Path sdkDir) {
            Path buildToolsDir = sdkDir.resolve("build-tools");
            if (!Files.isDirectory(buildToolsDir, new LinkOption[0])) {
                return Optional.empty();
            }
            try (Stream<Path> paths = Files.find(buildToolsDir, 2, (path, attributes) -> AAPT2_PATH_MATCHER.matches((Path)path) && VERSION_PATTERN.matcher(path.getParent().getFileName().toString()).matches() && Files.isExecutable(path), new FileVisitOption[0]);){
                Optional<Path> optional = paths.max(Comparator.comparing(path -> Version.of(path.getParent().getFileName().toString())));
                return optional;
            }
            catch (IOException e) {
                throw CommandExecutionException.builder().withCause(e).withMessage("Error while trying to locate aapt2 in SDK dir '%s'.", sdkDir).build();
            }
        }
    }

    public static class CommandExecutor {
        private static final int TIMEOUT_AAPT2_COMMANDS_SECONDS = 300;

        void execute(String ... command) {
            try {
                Process process = new ProcessBuilder(command).redirectErrorStream(true).start();
                if (!process.waitFor(300L, TimeUnit.SECONDS)) {
                    CommandExecutor.printOutput(process);
                    throw new CommandExecutionException("Command timed out: " + Arrays.toString(command));
                }
                if (process.exitValue() != 0) {
                    CommandExecutor.printOutput(process);
                    throw new CommandExecutionException(String.format("Command '%s' didn't terminate successfully (exit code: %d). Check the logs.", Arrays.toString(command), process.exitValue()));
                }
            }
            catch (IOException | InterruptedException e) {
                throw CommandExecutionException.builder().withCause(e).withMessage("Error when executing 'aapt2 convert' command.").build();
            }
        }

        private static void printOutput(Process process) {
            try (BufferedReader outputReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = outputReader.readLine()) != null) {
                    System.err.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

