/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.model.AutoValue_FileSystemModuleEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@AutoValue
public abstract class FileSystemModuleEntry
implements ModuleEntry {
    @Override
    public abstract ZipPath getPath();

    @Override
    public abstract boolean isDirectory();

    abstract Path getFileSystemPath();

    @Override
    public InputStream getContent() {
        try {
            return Files.newInputStream(this.getFileSystemPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Error while reading file '%s'.", this.getFileSystemPath()).build();
        }
    }

    public static FileSystemModuleEntry ofFile(ZipPath entryPath, Path fileSystemPath) {
        Preconditions.checkArgument((boolean)Files.isRegularFile(fileSystemPath, new LinkOption[0]), (String)"Expecting '%s' to be an existing regular file.", (Object)fileSystemPath);
        return FileSystemModuleEntry.create(entryPath, false, fileSystemPath);
    }

    private static FileSystemModuleEntry create(ZipPath entryPath, boolean isDirectory, Path fileSystemPath) {
        return new AutoValue_FileSystemModuleEntry(entryPath, isDirectory, fileSystemPath);
    }
}

