/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.PackageTypeEntry;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.targeting.BestScreenDensitySelector;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ScreenDensityResourcesSplitter
implements ModuleSplitSplitter {
    static final ImmutableSet<Targeting.ScreenDensity.DensityAlias> DEFAULT_DENSITY_SPLIT_CONFIG = ImmutableSet.of((Object)((Object)Targeting.ScreenDensity.DensityAlias.LDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.MDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.HDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXXHDPI), (Object[])new Targeting.ScreenDensity.DensityAlias[]{Targeting.ScreenDensity.DensityAlias.TVDPI});

    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit split) {
        Optional<Resources.ResourceTable> resourceTable = split.getResourceTable();
        if (!resourceTable.isPresent()) {
            return ImmutableList.of((Object)split);
        }
        ImmutableList.Builder splitsBuilder = new ImmutableList.Builder();
        for (Targeting.ScreenDensity.DensityAlias density : DEFAULT_DENSITY_SPLIT_CONFIG) {
            Resources.ResourceTable optimizedTable = ScreenDensityResourcesSplitter.filterResourceTableForDensity(resourceTable.get(), density);
            ModuleSplit.Builder moduleSplitBuilder = split.toBuilder().setTargeting(split.getTargeting().toBuilder().setScreenDensityTargeting(Targeting.ScreenDensityTargeting.newBuilder().addValue(ScreenDensityResourcesSplitter.toScreenDensity(density)).addAllAlternatives((Iterable)Sets.difference(DEFAULT_DENSITY_SPLIT_CONFIG, (Set)ImmutableSet.of((Object)((Object)density))).stream().map(ScreenDensityResourcesSplitter::toScreenDensity).collect(ImmutableList.toImmutableList()))).build()).setMasterSplit(false).setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(split.getEntries(), optimizedTable)).setResourceTable(optimizedTable);
            splitsBuilder.add((Object)moduleSplitBuilder.build());
        }
        ModuleSplit defaultResourcesSplit = this.getDefaultResourcesSplit(split, (ImmutableCollection<ModuleSplit>)splitsBuilder.build());
        return splitsBuilder.add((Object)defaultResourcesSplit).build();
    }

    private static Targeting.ScreenDensity toScreenDensity(Targeting.ScreenDensity.DensityAlias alias) {
        return Targeting.ScreenDensity.newBuilder().setDensityAlias(alias).build();
    }

    private ModuleSplit getDefaultResourcesSplit(ModuleSplit inputSplit, ImmutableCollection<ModuleSplit> densitySplits) {
        Resources.ResourceTable defaultSplitTable = this.getResourceTableForDefaultSplit(inputSplit, this.getClaimedConfigs((Iterable<ModuleSplit>)densitySplits));
        return inputSplit.toBuilder().setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(inputSplit.getEntries(), defaultSplitTable)).setResourceTable(defaultSplitTable).build();
    }

    private ImmutableMultimap<PackageTypeEntry, Resources.ConfigValue> getClaimedConfigs(Iterable<ModuleSplit> moduleSplits) {
        ImmutableMultimap.Builder result = new ImmutableMultimap.Builder();
        for (ModuleSplit moduleSplit : moduleSplits) {
            Preconditions.checkState((boolean)moduleSplit.getResourceTable().isPresent(), (Object)"Resource table not found in the density split.");
            for (Resources.Package pkg : moduleSplit.getResourceTable().get().getPackageList()) {
                for (Resources.Type type : pkg.getTypeList()) {
                    for (Resources.Entry entry : type.getEntryList()) {
                        for (Resources.ConfigValue configValue : entry.getConfigValueList()) {
                            result.put((Object)PackageTypeEntry.create((Resources.PackageOrBuilder)pkg, (Resources.TypeOrBuilder)type, (Resources.EntryOrBuilder)entry), (Object)configValue);
                        }
                    }
                }
            }
        }
        return result.build();
    }

    private Resources.ResourceTable getResourceTableForDefaultSplit(ModuleSplit split, ImmutableMultimap<PackageTypeEntry, Resources.ConfigValue> claimedConfigs) {
        Preconditions.checkArgument((boolean)split.getResourceTable().isPresent(), (Object)"Expected the split to contain Resource Table.");
        Resources.ResourceTable.Builder prunedTable = split.getResourceTable().get().toBuilder();
        for (Resources.Package.Builder packageBuilder : prunedTable.getPackageBuilderList()) {
            for (Resources.Type.Builder typeBuilder : packageBuilder.getTypeBuilderList()) {
                ArrayList<Resources.Entry> newEntries = new ArrayList<Resources.Entry>();
                for (Resources.Entry entry : typeBuilder.getEntryList()) {
                    ImmutableList allConfigsExceptClaimed = (ImmutableList)entry.getConfigValueList().stream().filter(configValue -> !claimedConfigs.containsEntry((Object)PackageTypeEntry.create((Resources.PackageOrBuilder)packageBuilder, (Resources.TypeOrBuilder)typeBuilder, (Resources.EntryOrBuilder)entry), configValue)).collect(ImmutableList.toImmutableList());
                    Resources.Entry.Builder newEntry = entry.toBuilder().clearConfigValue().addAllConfigValue((Iterable)allConfigsExceptClaimed);
                    if (newEntry.getConfigValueCount() <= 0) continue;
                    newEntries.add(newEntry.build());
                }
                typeBuilder.clearEntry().addAllEntry(newEntries);
            }
        }
        return prunedTable.build();
    }

    private static Resources.ResourceTable filterResourceTableForDensity(Resources.ResourceTable input, Targeting.ScreenDensity.DensityAlias density) {
        return ResourcesUtils.filterResourceTable(input, type -> type.getName().equals("mipmap"), entry -> ScreenDensityResourcesSplitter.filterEntryForDensity(entry, density));
    }

    private static Resources.Entry filterEntryForDensity(Resources.Entry initialEntry, Targeting.ScreenDensity.DensityAlias targetDensity) {
        Collection<List<Resources.ConfigValue>> densityGroups = initialEntry.getConfigValueList().stream().filter(configValue -> configValue.getConfig().getDensity() != 0).collect(Collectors.groupingBy(configValue -> ScreenDensityResourcesSplitter.clearDensity(configValue.getConfig()))).values();
        ImmutableList<Resources.ConfigValue> valuesToKeep = ScreenDensityResourcesSplitter.pickBestDensityForEachGroup(densityGroups, targetDensity);
        return initialEntry.toBuilder().clearConfigValue().addAllConfigValue(valuesToKeep).build();
    }

    private static ImmutableList<Resources.ConfigValue> pickBestDensityForEachGroup(Collection<List<Resources.ConfigValue>> densityGroups, Targeting.ScreenDensity.DensityAlias densityAlias) {
        return (ImmutableList)densityGroups.stream().map(group -> new BestScreenDensitySelector().selectBestConfigValue((Iterable<Resources.ConfigValue>)group, densityAlias)).collect(ImmutableList.toImmutableList());
    }

    private static ConfigurationOuterClass.Configuration clearDensity(ConfigurationOuterClass.Configuration source) {
        return source.toBuilder().clearDensity().build();
    }
}

