/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.targeting.AutoValue_TargetedDirectory;
import com.android.tools.build.bundletool.targeting.TargetedDirectorySegment;
import com.android.tools.build.bundletool.targeting.TargetingDimension;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.HashSet;

@AutoValue
public abstract class TargetedDirectory {
    public abstract ImmutableList<TargetedDirectorySegment> getPathSegments();

    public abstract ZipPath originalPath();

    public TargetedDirectorySegment getLastSegment() {
        return (TargetedDirectorySegment)Iterables.getLast(this.getPathSegments());
    }

    public String getPathBaseName() {
        return this.getSubPathBaseName(this.getPathSegments().size() - 1);
    }

    public String getSubPathBaseName(int maxIndex) {
        return this.originalPath().subpath(0, maxIndex + 1).resolveSibling(((TargetedDirectorySegment)this.getPathSegments().get(maxIndex)).getName()).toString();
    }

    public static TargetedDirectory parse(ZipPath directoryPath) {
        Preconditions.checkArgument((directoryPath.getNameCount() > 0 ? 1 : 0) != 0, (Object)"Empty paths are not supported.");
        ImmutableList segments = (ImmutableList)Streams.stream((Iterable)directoryPath).map(path -> TargetedDirectorySegment.parse((ZipPath)path)).collect(ImmutableList.toImmutableList());
        TargetedDirectory.checkNoDuplicateDimensions((ImmutableList<TargetedDirectorySegment>)segments, directoryPath);
        return TargetedDirectory.create((ImmutableList<TargetedDirectorySegment>)segments, directoryPath);
    }

    private static void checkNoDuplicateDimensions(ImmutableList<TargetedDirectorySegment> directorySegments, ZipPath directoryPath) {
        HashSet<TargetingDimension> coveredDimensions = new HashSet<TargetingDimension>();
        for (TargetedDirectorySegment targetedDirectorySegment : directorySegments) {
            if (!targetedDirectorySegment.getTargetingDimension().isPresent()) continue;
            TargetingDimension lastSegmentDimension = targetedDirectorySegment.getTargetingDimension().get();
            if (coveredDimensions.contains((Object)lastSegmentDimension)) {
                throw ValidationException.builder().withMessage("Duplicate targeting dimension '%s' on path '%s'.", new Object[]{lastSegmentDimension, directoryPath}).build();
            }
            coveredDimensions.add(lastSegmentDimension);
        }
    }

    private static TargetedDirectory create(ImmutableList<TargetedDirectorySegment> segments, ZipPath originalPath) {
        return new AutoValue_TargetedDirectory(segments, originalPath);
    }
}

