/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;

public final class BundleConfigValidator
extends SubValidator {
    private static final ImmutableSet<String> FORBIDDEN_CHARS_IN_GLOB = ImmutableSet.of((Object)"\n", (Object)"\\\\");

    @Override
    public void validateBundle(AppBundle bundle) {
        Config.BundleConfig bundleConfig = bundle.getBundleConfig();
        this.validateCompression(bundleConfig.getCompression());
    }

    private void validateCompression(Config.Compression compression) {
        FileSystem fileSystem = FileSystems.getDefault();
        for (String pattern : compression.getUncompressedGlobList()) {
            if (FORBIDDEN_CHARS_IN_GLOB.stream().anyMatch(pattern::contains)) {
                throw ValidationException.builder().withMessage("Invalid uncompressed glob: '%s'.", pattern).build();
            }
            try {
                fileSystem.getPathMatcher("glob:" + pattern);
            }
            catch (IllegalArgumentException e) {
                throw ValidationException.builder().withCause(e).withMessage("Invalid uncompressed glob: '%s'.", pattern).build();
            }
        }
    }
}

