/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class ValidatorRunner {
    private final ImmutableList<SubValidator> subValidators;

    public ValidatorRunner(ImmutableList<SubValidator> subValidators) {
        this.subValidators = subValidators;
    }

    public void validate(AppBundle bundle) {
        this.subValidators.forEach(subValidator -> subValidator.validateBundle(bundle));
        this.validate((ImmutableList<BundleModule>)ImmutableList.copyOf((Collection)bundle.getModules().values()));
    }

    public void validate(ImmutableList<BundleModule> modules) {
        this.subValidators.forEach(subValidator -> subValidator.validateAllModules(modules));
        for (BundleModule module : modules) {
            try {
                this.subValidators.forEach(subValidator -> subValidator.validateModule(module));
                for (ZipPath moduleFile : ValidatorRunner.getModuleFiles(module)) {
                    this.subValidators.forEach(subValidator -> subValidator.validateModuleFile(moduleFile));
                }
            }
            catch (ValidationException e) {
                throw ValidationException.builder().withCause(e).withMessage("Error validating module '%s'.", module.getName()).build();
            }
        }
    }

    private static ImmutableList<ZipPath> getModuleFiles(BundleModule module) {
        return (ImmutableList)module.getEntries().stream().map(ModuleEntry::getPath).collect(ImmutableList.toImmutableList());
    }
}

