/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.CompilationException;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.R8;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationWriter;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class DexFileMergerHelper {
    private final Map<String, Integer> inputOrdering;

    private DexFileMergerHelper(Map<String, Integer> inputOrdering) {
        this.inputOrdering = inputOrdering;
    }

    private DexProgramClass keepFirstProgramClassConflictResolver(DexProgramClass a, DexProgramClass b) {
        String aPath = a.getOrigin().parent().part();
        String bPath = b.getOrigin().parent().part();
        Integer aIndex = this.inputOrdering.get(aPath);
        Integer bIndex = this.inputOrdering.get(bPath);
        if (aIndex == null || bIndex == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Class parent paths not found among input paths: ");
            if (aIndex == null) {
                builder.append(aPath);
            }
            if (bIndex == null) {
                if (aIndex == null) {
                    builder.append(", ");
                }
                builder.append(bPath);
            }
            throw new RuntimeException(builder.toString());
        }
        return aIndex <= bIndex ? a.get() : b.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(D8Command command, Boolean minimalMainDex, Map<String, Integer> inputOrdering) throws IOException, CompilationException, ExecutionException {
        InternalOptions options = command.getInternalOptions();
        options.enableDesugaring = false;
        options.enableMainDexListCheck = false;
        options.minimalMainDex = minimalMainDex;
        options.enableMinification = false;
        options.enableInlining = false;
        options.outline.enabled = false;
        ExecutorService executor = ThreadUtils.getExecutorService(-1);
        try {
            try {
                Timing timing = new Timing("DexFileMerger");
                DexApplication app = new ApplicationReader(command.getInputApp(), options, timing).read(null, executor, new DexFileMergerHelper(inputOrdering)::keepFirstProgramClassConflictResolver);
                AppInfo appInfo = new AppInfo(app);
                app = D8.optimize(app, appInfo, options, timing, executor);
                assert (!options.hasMethodsFilter());
                new ApplicationWriter(app, options, D8.getMarker(options), null, NamingLens.getIdentityLens(), null, null).write(executor);
                options.printWarnings();
            }
            catch (ExecutionException e) {
                R8.unwrapExecutionException(e);
                throw new AssertionError((Object)e);
            }
            finally {
                options.signalFinishedToProgramConsumer();
            }
        }
        finally {
            executor.shutdown();
        }
    }
}

