/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.tools.build.bundletool.commands.AutoValue_BuildBundleCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.io.ZipUtils;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.targeting.TargetingGenerator;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.validation.BundleModulesValidator;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.io.MoreFiles;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildBundleCommand {
    public static final String COMMAND_NAME = "build-bundle";
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<Path> BUNDLE_CONFIG_FLAG = Flag.path("config");
    private static final Flag<ImmutableList<Path>> MODULES_FLAG = Flag.paths("modules");

    public abstract Path getOutputPath();

    public abstract ImmutableList<Path> getModulesPaths();

    public abstract Optional<Config.BundleConfig> getBundleConfig();

    public abstract ImmutableMultimap<String, Path> getMetadataFiles();

    public static Builder builder() {
        return new AutoValue_BuildBundleCommand.Builder();
    }

    public static BuildBundleCommand fromFlags(ParsedFlags flags) {
        Builder builder = BuildBundleCommand.builder().setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setModulesPaths(MODULES_FLAG.getRequiredValue(flags));
        BUNDLE_CONFIG_FLAG.getValue(flags).ifPresent(path -> builder.setBundleConfig(BuildBundleCommand.parseBundleConfigJson(path)));
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.validateInput();
        ZipBuilder bundleBuilder = new ZipBuilder();
        ArrayList<ZipFile> openedZipFiles = new ArrayList<ZipFile>();
        try {
            for (Path module : this.getModulesPaths()) {
                Optional<Files.Assets> assetsTargeting;
                ZipFile moduleZipFile;
                ZipPath moduleDir = ZipPath.create(MoreFiles.getNameWithoutExtension((Path)module));
                try {
                    moduleZipFile = new ZipFile(module.toFile());
                    openedZipFiles.add(moduleZipFile);
                }
                catch (ZipException e) {
                    throw CommandExecutionException.builder().withCause(e).withMessage("File '%s' does not seem to be a valid ZIP file.", module).build();
                }
                catch (IOException e) {
                    throw CommandExecutionException.builder().withCause(e).withMessage("Unable to read file '%s'.", module).build();
                }
                bundleBuilder.copyAllContentsFromZip(moduleDir, moduleZipFile);
                Optional<Files.NativeLibraries> nativeLibrariesTargeting = this.generateNativeLibrariesTargeting(moduleZipFile);
                if (nativeLibrariesTargeting.isPresent()) {
                    bundleBuilder.addFileWithProtoContent(moduleDir.resolve("native.pb"), (MessageLite)nativeLibrariesTargeting.get(), new ZipBuilder.EntryOption[0]);
                }
                if (!(assetsTargeting = this.generateAssetsTargeting(moduleZipFile)).isPresent()) continue;
                bundleBuilder.addFileWithProtoContent(moduleDir.resolve("assets.pb"), (MessageLite)assetsTargeting.get(), new ZipBuilder.EntryOption[0]);
            }
            Config.BundleConfig bundleConfig = this.getBundleConfig().orElse(Config.BundleConfig.getDefaultInstance()).toBuilder().setBundletool(Config.Bundletool.newBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString())).build();
            bundleBuilder.addFileWithContent(ZipPath.create("BundleConfig.pb"), bundleConfig.toByteArray(), new ZipBuilder.EntryOption[0]);
            for (Map.Entry entry : this.getMetadataFiles().entries()) {
                String namespace = (String)entry.getKey();
                Path file = (Path)entry.getValue();
                ZipPath metadataPath = AppBundle.METADATA_DIRECTORY.resolve(namespace).resolve(file.getFileName().toString());
                bundleBuilder.addFileFromDisk(metadataPath, file.toFile(), new ZipBuilder.EntryOption[0]);
            }
            try {
                bundleBuilder.writeTo(this.getOutputPath());
            }
            catch (IOException e) {
                throw CommandExecutionException.builder().withCause(e).withMessage("Unable to write file to location '%s'.").build();
            }
        }
        finally {
            ZipUtils.closeZipFiles(openedZipFiles);
        }
    }

    private void validateInput() {
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        new BundleModulesValidator().validate(this.getModulesPaths());
    }

    private Optional<Files.Assets> generateAssetsTargeting(ZipFile module) {
        ImmutableList assetDirectories = (ImmutableList)ZipUtils.getFilesWithPathPrefix(module, BundleModule.ASSETS_DIRECTORY).filter(path -> path.getNameCount() > 1).map(ZipPath::getParent).distinct().collect(ImmutableList.toImmutableList());
        if (assetDirectories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator().generateTargetingForAssets((Collection<ZipPath>)assetDirectories));
    }

    private Optional<Files.NativeLibraries> generateNativeLibrariesTargeting(ZipFile module) {
        ImmutableList libAbiDirs = (ImmutableList)ZipUtils.getFilesWithPathPrefix(module, BundleModule.LIB_DIRECTORY).filter(path -> path.getNameCount() > 2).map(path -> path.subpath(0, 2)).map(ZipPath::toString).distinct().collect(ImmutableList.toImmutableList());
        if (libAbiDirs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator().generateTargetingForNativeLibraries((Collection<String>)libAbiDirs));
    }

    private static Config.BundleConfig parseBundleConfigJson(Path bundleConfigJsonPath) {
        Config.BundleConfig.Builder bundleConfig = Config.BundleConfig.newBuilder();
        try (BufferedReader bundleConfigReader = Files.newBufferedReader(bundleConfigJsonPath, StandardCharsets.UTF_8);){
            JsonFormat.parser().merge((Reader)bundleConfigReader, (Message.Builder)bundleConfig);
        }
        catch (InvalidProtocolBufferException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("The file '%s' is not a valid BundleConfig JSON file.", bundleConfigJsonPath).build();
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("An error occurred while trying to read the file '%s'.", bundleConfigJsonPath).build();
        }
        return bundleConfig.build();
    }

    public static void help() {
        CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription("Builds an Android App Bundle from a set of Bundle modules provided as zip files. Note that the resource table, the AndroidManifest.xml and the resources must already have been compiled with aapt2 in the proto format.").addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FLAG.getName()).setExampleValue("bundle.aab").setDescription("Path to the where the Android App Bundle should be built.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("path/to/module1.zip,path/to/module2.zip,...").setDescription("The list of module files to build the final Android App Bundle from.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(BUNDLE_CONFIG_FLAG.getName()).setExampleValue("BundleConfig.pb.json").setDescription("Path to a JSON file that describes the configuration of the App Bundle. This configuration will be merged with BundleTool defaults.").setOptional(true).build()).build().print(System.out);
    }

    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setModulesPaths(ImmutableList<Path> var1);

        public abstract Builder setBundleConfig(Config.BundleConfig var1);

        abstract ImmutableMultimap.Builder<String, Path> metadataFilesBuilder();

        public Builder addMetadataFile(String namespaceKey, Path file) {
            if (!Files.exists(file, new LinkOption[0])) {
                throw ValidationException.builder().withMessage("Metadata file '%s' does not exist.", file).build();
            }
            if (ZipPath.create(namespaceKey).getNameCount() != 1) {
                throw ValidationException.builder().withMessage("The namespace should be representable by a single directory, got '%s'.", namespaceKey).build();
            }
            this.metadataFilesBuilder().put((Object)namespaceKey, (Object)file);
            return this;
        }

        public abstract BuildBundleCommand build();
    }
}

