/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public class AppBundleSerializer {
    public void writeToDisk(AppBundle bundle, Path pathOnDisk) throws IOException {
        ZipBuilder zipBuilder = new ZipBuilder();
        zipBuilder.addFileWithProtoContent(ZipPath.create("BundleConfig.pb"), (MessageLite)bundle.getBundleConfig(), new ZipBuilder.EntryOption[0]);
        for (BundleModule module : bundle.getModules().values()) {
            for (ModuleEntry entry : module.getEntries()) {
                ZipPath entryPath = ZipPath.create(module.getName().toString()).resolve(entry.getPath());
                if (entry.isDirectory()) {
                    zipBuilder.addDirectory(entryPath);
                    continue;
                }
                InputStream content = entry.getContent();
                Throwable throwable = null;
                try {
                    zipBuilder.addFile(entryPath, () -> content, new ZipBuilder.EntryOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (content == null) continue;
                    if (throwable != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    content.close();
                }
            }
        }
        zipBuilder.writeTo(pathOnDisk);
    }
}

