/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipUtils {
    public static Stream<ZipPath> getFilesWithPathPrefix(ZipFile zipFile, ZipPath prefix) {
        return ZipUtils.getStreamOfEntriesWithPathPrefix(zipFile, prefix).map(ZipEntry::getName).map(ZipPath::create);
    }

    public static ImmutableList<ZipEntry> getEntriesWithPathPrefix(ZipFile zipFile, ZipPath prefix) {
        return (ImmutableList)ZipUtils.getStreamOfEntriesWithPathPrefix(zipFile, prefix).collect(ImmutableList.toImmutableList());
    }

    private static Stream<? extends ZipEntry> getStreamOfEntriesWithPathPrefix(ZipFile zipFile, ZipPath prefix) {
        return zipFile.stream().filter(entry -> !entry.isDirectory() && ZipPath.create(entry.getName()).startsWith(prefix));
    }

    public static ZipFile openZipFile(Path path) {
        FilePreconditions.checkFileExistsAndReadable(path);
        try {
            return new ZipFile(path.toFile());
        }
        catch (IOException e) {
            throw ValidationException.builder().withCause(e).withMessage("Error reading zip file '%s'.", path).build();
        }
    }

    public static void closeZipFiles(Collection<ZipFile> zipFiles) {
        IOException thrown = null;
        for (ZipFile zipFile : zipFiles) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                thrown = e;
            }
        }
        if (thrown != null) {
            throw new ValidationException("Error closing zip files.", thrown);
        }
    }

    private ZipUtils() {
    }
}

