/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class LanguageResourcesSplitter
implements ModuleSplitSplitter {
    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit split) {
        if (!split.getResourceTable().isPresent()) {
            return ImmutableList.of((Object)split);
        }
        Resources.ResourceTable resourceTable = split.getResourceTable().get();
        ImmutableMap<String, Resources.ResourceTable> byLanguage = LanguageResourcesSplitter.groupByLanguage(resourceTable, LanguageResourcesSplitter.hasNonResourceEntries(split));
        Sets.SetView allLanguages = Sets.difference((Set)byLanguage.keySet(), (Set)ImmutableSet.of((Object)""));
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (String language : byLanguage.keySet()) {
            ModuleSplit moduleSplit = split.toBuilder().setEntries((List<ModuleEntry>)LanguageResourcesSplitter.getEntriesForSplit(split.getEntries(), language, (Resources.ResourceTable)byLanguage.get((Object)language))).setResourceTable((Resources.ResourceTable)byLanguage.get((Object)language)).setTargeting(language.isEmpty() ? split.getTargeting() : split.getTargeting().toBuilder().setLanguageTargeting(Targeting.LanguageTargeting.newBuilder().addValue(language).addAllAlternatives((Iterable<String>)Sets.difference((Set)allLanguages, (Set)ImmutableSet.of((Object)language)))).build()).setMasterSplit(split.isMasterSplit() && language.isEmpty()).build();
            result.add((Object)moduleSplit);
        }
        return result.build();
    }

    private static boolean hasNonResourceEntries(ModuleSplit split) {
        return split.getEntries().stream().anyMatch(entry -> !entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY));
    }

    private static ImmutableList<ModuleEntry> getEntriesForSplit(ImmutableList<ModuleEntry> inputEntries, String language, Resources.ResourceTable resourceTable) {
        ImmutableList<ModuleEntry> entriesFromResourceTable = ModuleSplit.filterResourceEntries(inputEntries, resourceTable);
        if (language.isEmpty()) {
            ImmutableList.Builder result = new ImmutableList.Builder();
            result.addAll(entriesFromResourceTable);
            result.addAll((Iterable)inputEntries.stream().filter(entry -> !entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)).collect(ImmutableList.toImmutableList()));
            return result.build();
        }
        return entriesFromResourceTable;
    }

    private static ImmutableMap<String, Resources.ResourceTable> groupByLanguage(Resources.ResourceTable table, boolean hasNonResourceEntries) {
        Set languages = (Set)ResourcesUtils.configValues(table).map(configValue -> configValue.getConfig().getLocale()).map(ResourcesUtils::convertLocaleToLanguage).collect(ImmutableSet.toImmutableSet());
        ImmutableMap.Builder resourceTableByLanguage = new ImmutableMap.Builder();
        for (String language : languages) {
            resourceTableByLanguage.put((Object)language, (Object)LanguageResourcesSplitter.filterByLanguage(table, language));
        }
        if (!languages.contains("") && hasNonResourceEntries) {
            resourceTableByLanguage.put((Object)"", (Object)Resources.ResourceTable.getDefaultInstance());
        }
        return resourceTableByLanguage.build();
    }

    private static Resources.ResourceTable filterByLanguage(Resources.ResourceTable input, String language) {
        return ResourcesUtils.filterResourceTable(input, (Predicate<Resources.Type>)Predicates.alwaysFalse(), entry -> LanguageResourcesSplitter.filterEntryForLanguage(entry, language));
    }

    private static Resources.Entry filterEntryForLanguage(Resources.Entry initialEntry, String targetLanguage) {
        Iterable filteredConfigValues = Iterables.filter((Iterable)initialEntry.getConfigValueList(), configValue -> ResourcesUtils.convertLocaleToLanguage(configValue.getConfig().getLocale()).equals(targetLanguage));
        return initialEntry.toBuilder().clearConfigValue().addAllConfigValue(filteredConfigValues).build();
    }
}

